import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BranchDefaultConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_default.html#branch BranchDefault#branch}.
     *
     * @stability stable
     */
    readonly branch: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_default.html#repository BranchDefault#repository}.
     *
     * @stability stable
     */
    readonly repository: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/branch_default.html github_branch_default}.
 *
 * @stability stable
 */
export declare class BranchDefault extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/branch_default.html github_branch_default} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BranchDefaultConfig);
    private _branch;
    /**
     * @stability stable
     */
    get branch(): string;
    /**
     * @stability stable
     */
    set branch(value: string);
    /**
     * @stability stable
     */
    get branchInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _repository;
    /**
     * @stability stable
     */
    get repository(): string;
    /**
     * @stability stable
     */
    set repository(value: string);
    /**
     * @stability stable
     */
    get repositoryInput(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
