import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ActionsSecretConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_secret.html#encrypted_value ActionsSecret#encrypted_value}.
     *
     * @stability stable
     */
    readonly encryptedValue?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_secret.html#plaintext_value ActionsSecret#plaintext_value}.
     *
     * @stability stable
     */
    readonly plaintextValue?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_secret.html#repository ActionsSecret#repository}.
     *
     * @stability stable
     */
    readonly repository: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_secret.html#secret_name ActionsSecret#secret_name}.
     *
     * @stability stable
     */
    readonly secretName: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/actions_secret.html github_actions_secret}.
 *
 * @stability stable
 */
export declare class ActionsSecret extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/actions_secret.html github_actions_secret} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ActionsSecretConfig);
    /**
     * @stability stable
     */
    get createdAt(): string;
    private _encryptedValue?;
    /**
     * @stability stable
     */
    get encryptedValue(): string;
    /**
     * @stability stable
     */
    set encryptedValue(value: string);
    /**
     * @stability stable
     */
    resetEncryptedValue(): void;
    /**
     * @stability stable
     */
    get encryptedValueInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _plaintextValue?;
    /**
     * @stability stable
     */
    get plaintextValue(): string;
    /**
     * @stability stable
     */
    set plaintextValue(value: string);
    /**
     * @stability stable
     */
    resetPlaintextValue(): void;
    /**
     * @stability stable
     */
    get plaintextValueInput(): string | undefined;
    private _repository;
    /**
     * @stability stable
     */
    get repository(): string;
    /**
     * @stability stable
     */
    set repository(value: string);
    /**
     * @stability stable
     */
    get repositoryInput(): string;
    private _secretName;
    /**
     * @stability stable
     */
    get secretName(): string;
    /**
     * @stability stable
     */
    set secretName(value: string);
    /**
     * @stability stable
     */
    get secretNameInput(): string;
    /**
     * @stability stable
     */
    get updatedAt(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
