import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ActionsRunnerGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_runner_group.html#name ActionsRunnerGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_runner_group.html#selected_repository_ids ActionsRunnerGroup#selected_repository_ids}.
     *
     * @stability stable
     */
    readonly selectedRepositoryIds?: number[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_runner_group.html#visibility ActionsRunnerGroup#visibility}.
     *
     * @stability stable
     */
    readonly visibility: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/actions_runner_group.html github_actions_runner_group}.
 *
 * @stability stable
 */
export declare class ActionsRunnerGroup extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/actions_runner_group.html github_actions_runner_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ActionsRunnerGroupConfig);
    /**
     * @stability stable
     */
    get allowsPublicRepositories(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get default(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get inherited(): cdktf.IResolvable;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    /**
     * @stability stable
     */
    get runnersUrl(): string;
    /**
     * @stability stable
     */
    get selectedRepositoriesUrl(): string;
    private _selectedRepositoryIds?;
    /**
     * @stability stable
     */
    get selectedRepositoryIds(): number[];
    /**
     * @stability stable
     */
    set selectedRepositoryIds(value: number[]);
    /**
     * @stability stable
     */
    resetSelectedRepositoryIds(): void;
    /**
     * @stability stable
     */
    get selectedRepositoryIdsInput(): number[] | undefined;
    private _visibility;
    /**
     * @stability stable
     */
    get visibility(): string;
    /**
     * @stability stable
     */
    set visibility(value: string);
    /**
     * @stability stable
     */
    get visibilityInput(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
