import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ActionsOrganizationSecretConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret.html#encrypted_value ActionsOrganizationSecret#encrypted_value}.
     *
     * @stability stable
     */
    readonly encryptedValue?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret.html#plaintext_value ActionsOrganizationSecret#plaintext_value}.
     *
     * @stability stable
     */
    readonly plaintextValue?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret.html#secret_name ActionsOrganizationSecret#secret_name}.
     *
     * @stability stable
     */
    readonly secretName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret.html#selected_repository_ids ActionsOrganizationSecret#selected_repository_ids}.
     *
     * @stability stable
     */
    readonly selectedRepositoryIds?: number[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret.html#visibility ActionsOrganizationSecret#visibility}.
     *
     * @stability stable
     */
    readonly visibility: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret.html github_actions_organization_secret}.
 *
 * @stability stable
 */
export declare class ActionsOrganizationSecret extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret.html github_actions_organization_secret} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ActionsOrganizationSecretConfig);
    /**
     * @stability stable
     */
    get createdAt(): string;
    private _encryptedValue?;
    /**
     * @stability stable
     */
    get encryptedValue(): string;
    /**
     * @stability stable
     */
    set encryptedValue(value: string);
    /**
     * @stability stable
     */
    resetEncryptedValue(): void;
    /**
     * @stability stable
     */
    get encryptedValueInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _plaintextValue?;
    /**
     * @stability stable
     */
    get plaintextValue(): string;
    /**
     * @stability stable
     */
    set plaintextValue(value: string);
    /**
     * @stability stable
     */
    resetPlaintextValue(): void;
    /**
     * @stability stable
     */
    get plaintextValueInput(): string | undefined;
    private _secretName;
    /**
     * @stability stable
     */
    get secretName(): string;
    /**
     * @stability stable
     */
    set secretName(value: string);
    /**
     * @stability stable
     */
    get secretNameInput(): string;
    private _selectedRepositoryIds?;
    /**
     * @stability stable
     */
    get selectedRepositoryIds(): number[];
    /**
     * @stability stable
     */
    set selectedRepositoryIds(value: number[]);
    /**
     * @stability stable
     */
    resetSelectedRepositoryIds(): void;
    /**
     * @stability stable
     */
    get selectedRepositoryIdsInput(): number[] | undefined;
    /**
     * @stability stable
     */
    get updatedAt(): string;
    private _visibility;
    /**
     * @stability stable
     */
    get visibility(): string;
    /**
     * @stability stable
     */
    set visibility(value: string);
    /**
     * @stability stable
     */
    get visibilityInput(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
