import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ActionsOrganizationSecretRepositoriesConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret_repositories.html#secret_name ActionsOrganizationSecretRepositories#secret_name}.
     *
     * @stability stable
     */
    readonly secretName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret_repositories.html#selected_repository_ids ActionsOrganizationSecretRepositories#selected_repository_ids}.
     *
     * @stability stable
     */
    readonly selectedRepositoryIds: number[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret_repositories.html github_actions_organization_secret_repositories}.
 *
 * @stability stable
 */
export declare class ActionsOrganizationSecretRepositories extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret_repositories.html github_actions_organization_secret_repositories} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ActionsOrganizationSecretRepositoriesConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _secretName;
    /**
     * @stability stable
     */
    get secretName(): string;
    /**
     * @stability stable
     */
    set secretName(value: string);
    /**
     * @stability stable
     */
    get secretNameInput(): string;
    private _selectedRepositoryIds;
    /**
     * @stability stable
     */
    get selectedRepositoryIds(): number[];
    /**
     * @stability stable
     */
    set selectedRepositoryIds(value: number[]);
    /**
     * @stability stable
     */
    get selectedRepositoryIdsInput(): number[];
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
