# API Reference

**Classes**

Name|Description
----|-----------
[ActionsEnvironmentSecret](#cdktf-provider-github-actionsenvironmentsecret)|Represents a {@link https://www.terraform.io/docs/providers/github/r/actions_environment_secret.html github_actions_environment_secret}.
[ActionsOrganizationSecret](#cdktf-provider-github-actionsorganizationsecret)|Represents a {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret.html github_actions_organization_secret}.
[ActionsOrganizationSecretRepositories](#cdktf-provider-github-actionsorganizationsecretrepositories)|Represents a {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret_repositories.html github_actions_organization_secret_repositories}.
[ActionsRunnerGroup](#cdktf-provider-github-actionsrunnergroup)|Represents a {@link https://www.terraform.io/docs/providers/github/r/actions_runner_group.html github_actions_runner_group}.
[ActionsSecret](#cdktf-provider-github-actionssecret)|Represents a {@link https://www.terraform.io/docs/providers/github/r/actions_secret.html github_actions_secret}.
[AppInstallationRepository](#cdktf-provider-github-appinstallationrepository)|Represents a {@link https://www.terraform.io/docs/providers/github/r/app_installation_repository.html github_app_installation_repository}.
[Branch](#cdktf-provider-github-branch)|Represents a {@link https://www.terraform.io/docs/providers/github/r/branch.html github_branch}.
[BranchDefault](#cdktf-provider-github-branchdefault)|Represents a {@link https://www.terraform.io/docs/providers/github/r/branch_default.html github_branch_default}.
[BranchProtection](#cdktf-provider-github-branchprotection)|Represents a {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html github_branch_protection}.
[BranchProtectionV3](#cdktf-provider-github-branchprotectionv3)|Represents a {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html github_branch_protection_v3}.
[DataGithubActionsPublicKey](#cdktf-provider-github-datagithubactionspublickey)|Represents a {@link https://www.terraform.io/docs/providers/github/d/actions_public_key.html github_actions_public_key}.
[DataGithubBranch](#cdktf-provider-github-datagithubbranch)|Represents a {@link https://www.terraform.io/docs/providers/github/d/branch.html github_branch}.
[DataGithubCollaborators](#cdktf-provider-github-datagithubcollaborators)|Represents a {@link https://www.terraform.io/docs/providers/github/d/collaborators.html github_collaborators}.
[DataGithubCollaboratorsCollaborator](#cdktf-provider-github-datagithubcollaboratorscollaborator)|*No description*
[DataGithubIpRanges](#cdktf-provider-github-datagithubipranges)|Represents a {@link https://www.terraform.io/docs/providers/github/d/ip_ranges.html github_ip_ranges}.
[DataGithubMembership](#cdktf-provider-github-datagithubmembership)|Represents a {@link https://www.terraform.io/docs/providers/github/d/membership.html github_membership}.
[DataGithubOrganization](#cdktf-provider-github-datagithuborganization)|Represents a {@link https://www.terraform.io/docs/providers/github/d/organization.html github_organization}.
[DataGithubOrganizationTeamSyncGroups](#cdktf-provider-github-datagithuborganizationteamsyncgroups)|Represents a {@link https://www.terraform.io/docs/providers/github/d/organization_team_sync_groups.html github_organization_team_sync_groups}.
[DataGithubOrganizationTeamSyncGroupsGroups](#cdktf-provider-github-datagithuborganizationteamsyncgroupsgroups)|*No description*
[DataGithubOrganizationTeams](#cdktf-provider-github-datagithuborganizationteams)|Represents a {@link https://www.terraform.io/docs/providers/github/d/organization_teams.html github_organization_teams}.
[DataGithubOrganizationTeamsTeams](#cdktf-provider-github-datagithuborganizationteamsteams)|*No description*
[DataGithubRelease](#cdktf-provider-github-datagithubrelease)|Represents a {@link https://www.terraform.io/docs/providers/github/d/release.html github_release}.
[DataGithubRepositories](#cdktf-provider-github-datagithubrepositories)|Represents a {@link https://www.terraform.io/docs/providers/github/d/repositories.html github_repositories}.
[DataGithubRepository](#cdktf-provider-github-datagithubrepository)|Represents a {@link https://www.terraform.io/docs/providers/github/d/repository.html github_repository}.
[DataGithubRepositoryBranches](#cdktf-provider-github-datagithubrepositorybranches)|*No description*
[DataGithubRepositoryFile](#cdktf-provider-github-datagithubrepositoryfile)|Represents a {@link https://www.terraform.io/docs/providers/github/d/repository_file.html github_repository_file}.
[DataGithubRepositoryMilestone](#cdktf-provider-github-datagithubrepositorymilestone)|Represents a {@link https://www.terraform.io/docs/providers/github/d/repository_milestone.html github_repository_milestone}.
[DataGithubRepositoryPages](#cdktf-provider-github-datagithubrepositorypages)|*No description*
[DataGithubRepositoryPagesSource](#cdktf-provider-github-datagithubrepositorypagessource)|*No description*
[DataGithubRepositoryPullRequest](#cdktf-provider-github-datagithubrepositorypullrequest)|Represents a {@link https://www.terraform.io/docs/providers/github/d/repository_pull_request.html github_repository_pull_request}.
[DataGithubRepositoryPullRequests](#cdktf-provider-github-datagithubrepositorypullrequests)|Represents a {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html github_repository_pull_requests}.
[DataGithubRepositoryPullRequestsResults](#cdktf-provider-github-datagithubrepositorypullrequestsresults)|*No description*
[DataGithubTeam](#cdktf-provider-github-datagithubteam)|Represents a {@link https://www.terraform.io/docs/providers/github/d/team.html github_team}.
[DataGithubUser](#cdktf-provider-github-datagithubuser)|Represents a {@link https://www.terraform.io/docs/providers/github/d/user.html github_user}.
[GithubProvider](#cdktf-provider-github-githubprovider)|Represents a {@link https://www.terraform.io/docs/providers/github github}.
[IssueLabel](#cdktf-provider-github-issuelabel)|Represents a {@link https://www.terraform.io/docs/providers/github/r/issue_label.html github_issue_label}.
[Membership](#cdktf-provider-github-membership)|Represents a {@link https://www.terraform.io/docs/providers/github/r/membership.html github_membership}.
[OrganizationBlock](#cdktf-provider-github-organizationblock)|Represents a {@link https://www.terraform.io/docs/providers/github/r/organization_block.html github_organization_block}.
[OrganizationProject](#cdktf-provider-github-organizationproject)|Represents a {@link https://www.terraform.io/docs/providers/github/r/organization_project.html github_organization_project}.
[OrganizationWebhook](#cdktf-provider-github-organizationwebhook)|Represents a {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html github_organization_webhook}.
[ProjectCard](#cdktf-provider-github-projectcard)|Represents a {@link https://www.terraform.io/docs/providers/github/r/project_card.html github_project_card}.
[ProjectColumn](#cdktf-provider-github-projectcolumn)|Represents a {@link https://www.terraform.io/docs/providers/github/r/project_column.html github_project_column}.
[Repository](#cdktf-provider-github-repository)|Represents a {@link https://www.terraform.io/docs/providers/github/r/repository.html github_repository}.
[RepositoryCollaborator](#cdktf-provider-github-repositorycollaborator)|Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_collaborator.html github_repository_collaborator}.
[RepositoryDeployKey](#cdktf-provider-github-repositorydeploykey)|Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_deploy_key.html github_repository_deploy_key}.
[RepositoryEnvironment](#cdktf-provider-github-repositoryenvironment)|Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html github_repository_environment}.
[RepositoryFile](#cdktf-provider-github-repositoryfile)|Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_file.html github_repository_file}.
[RepositoryMilestone](#cdktf-provider-github-repositorymilestone)|Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_milestone.html github_repository_milestone}.
[RepositoryProject](#cdktf-provider-github-repositoryproject)|Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_project.html github_repository_project}.
[RepositoryPullRequest](#cdktf-provider-github-repositorypullrequest)|Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html github_repository_pull_request}.
[RepositoryWebhook](#cdktf-provider-github-repositorywebhook)|Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html github_repository_webhook}.
[Team](#cdktf-provider-github-team)|Represents a {@link https://www.terraform.io/docs/providers/github/r/team.html github_team}.
[TeamMembership](#cdktf-provider-github-teammembership)|Represents a {@link https://www.terraform.io/docs/providers/github/r/team_membership.html github_team_membership}.
[TeamRepository](#cdktf-provider-github-teamrepository)|Represents a {@link https://www.terraform.io/docs/providers/github/r/team_repository.html github_team_repository}.
[TeamSyncGroupMapping](#cdktf-provider-github-teamsyncgroupmapping)|Represents a {@link https://www.terraform.io/docs/providers/github/r/team_sync_group_mapping.html github_team_sync_group_mapping}.
[UserGpgKey](#cdktf-provider-github-usergpgkey)|Represents a {@link https://www.terraform.io/docs/providers/github/r/user_gpg_key.html github_user_gpg_key}.
[UserInvitationAccepter](#cdktf-provider-github-userinvitationaccepter)|Represents a {@link https://www.terraform.io/docs/providers/github/r/user_invitation_accepter.html github_user_invitation_accepter}.
[UserSshKey](#cdktf-provider-github-usersshkey)|Represents a {@link https://www.terraform.io/docs/providers/github/r/user_ssh_key.html github_user_ssh_key}.


**Structs**

Name|Description
----|-----------
[ActionsEnvironmentSecretConfig](#cdktf-provider-github-actionsenvironmentsecretconfig)|*No description*
[ActionsOrganizationSecretConfig](#cdktf-provider-github-actionsorganizationsecretconfig)|*No description*
[ActionsOrganizationSecretRepositoriesConfig](#cdktf-provider-github-actionsorganizationsecretrepositoriesconfig)|*No description*
[ActionsRunnerGroupConfig](#cdktf-provider-github-actionsrunnergroupconfig)|*No description*
[ActionsSecretConfig](#cdktf-provider-github-actionssecretconfig)|*No description*
[AppInstallationRepositoryConfig](#cdktf-provider-github-appinstallationrepositoryconfig)|*No description*
[BranchConfig](#cdktf-provider-github-branchconfig)|*No description*
[BranchDefaultConfig](#cdktf-provider-github-branchdefaultconfig)|*No description*
[BranchProtectionConfig](#cdktf-provider-github-branchprotectionconfig)|*No description*
[BranchProtectionRequiredPullRequestReviews](#cdktf-provider-github-branchprotectionrequiredpullrequestreviews)|*No description*
[BranchProtectionRequiredStatusChecks](#cdktf-provider-github-branchprotectionrequiredstatuschecks)|*No description*
[BranchProtectionV3Config](#cdktf-provider-github-branchprotectionv3config)|*No description*
[BranchProtectionV3RequiredPullRequestReviews](#cdktf-provider-github-branchprotectionv3requiredpullrequestreviews)|*No description*
[BranchProtectionV3RequiredStatusChecks](#cdktf-provider-github-branchprotectionv3requiredstatuschecks)|*No description*
[BranchProtectionV3Restrictions](#cdktf-provider-github-branchprotectionv3restrictions)|*No description*
[DataGithubActionsPublicKeyConfig](#cdktf-provider-github-datagithubactionspublickeyconfig)|*No description*
[DataGithubBranchConfig](#cdktf-provider-github-datagithubbranchconfig)|*No description*
[DataGithubCollaboratorsConfig](#cdktf-provider-github-datagithubcollaboratorsconfig)|*No description*
[DataGithubIpRangesConfig](#cdktf-provider-github-datagithubiprangesconfig)|*No description*
[DataGithubMembershipConfig](#cdktf-provider-github-datagithubmembershipconfig)|*No description*
[DataGithubOrganizationConfig](#cdktf-provider-github-datagithuborganizationconfig)|*No description*
[DataGithubOrganizationTeamSyncGroupsConfig](#cdktf-provider-github-datagithuborganizationteamsyncgroupsconfig)|*No description*
[DataGithubOrganizationTeamsConfig](#cdktf-provider-github-datagithuborganizationteamsconfig)|*No description*
[DataGithubReleaseConfig](#cdktf-provider-github-datagithubreleaseconfig)|*No description*
[DataGithubRepositoriesConfig](#cdktf-provider-github-datagithubrepositoriesconfig)|*No description*
[DataGithubRepositoryConfig](#cdktf-provider-github-datagithubrepositoryconfig)|*No description*
[DataGithubRepositoryFileConfig](#cdktf-provider-github-datagithubrepositoryfileconfig)|*No description*
[DataGithubRepositoryMilestoneConfig](#cdktf-provider-github-datagithubrepositorymilestoneconfig)|*No description*
[DataGithubRepositoryPullRequestConfig](#cdktf-provider-github-datagithubrepositorypullrequestconfig)|*No description*
[DataGithubRepositoryPullRequestsConfig](#cdktf-provider-github-datagithubrepositorypullrequestsconfig)|*No description*
[DataGithubTeamConfig](#cdktf-provider-github-datagithubteamconfig)|*No description*
[DataGithubUserConfig](#cdktf-provider-github-datagithubuserconfig)|*No description*
[GithubProviderAppAuth](#cdktf-provider-github-githubproviderappauth)|*No description*
[GithubProviderConfig](#cdktf-provider-github-githubproviderconfig)|*No description*
[IssueLabelConfig](#cdktf-provider-github-issuelabelconfig)|*No description*
[MembershipConfig](#cdktf-provider-github-membershipconfig)|*No description*
[OrganizationBlockConfig](#cdktf-provider-github-organizationblockconfig)|*No description*
[OrganizationProjectConfig](#cdktf-provider-github-organizationprojectconfig)|*No description*
[OrganizationWebhookConfig](#cdktf-provider-github-organizationwebhookconfig)|*No description*
[OrganizationWebhookConfiguration](#cdktf-provider-github-organizationwebhookconfiguration)|*No description*
[ProjectCardConfig](#cdktf-provider-github-projectcardconfig)|*No description*
[ProjectColumnConfig](#cdktf-provider-github-projectcolumnconfig)|*No description*
[RepositoryCollaboratorConfig](#cdktf-provider-github-repositorycollaboratorconfig)|*No description*
[RepositoryConfig](#cdktf-provider-github-repositoryconfig)|*No description*
[RepositoryDeployKeyConfig](#cdktf-provider-github-repositorydeploykeyconfig)|*No description*
[RepositoryEnvironmentConfig](#cdktf-provider-github-repositoryenvironmentconfig)|*No description*
[RepositoryEnvironmentDeploymentBranchPolicy](#cdktf-provider-github-repositoryenvironmentdeploymentbranchpolicy)|*No description*
[RepositoryEnvironmentReviewers](#cdktf-provider-github-repositoryenvironmentreviewers)|*No description*
[RepositoryFileConfig](#cdktf-provider-github-repositoryfileconfig)|*No description*
[RepositoryMilestoneConfig](#cdktf-provider-github-repositorymilestoneconfig)|*No description*
[RepositoryPages](#cdktf-provider-github-repositorypages)|*No description*
[RepositoryPagesSource](#cdktf-provider-github-repositorypagessource)|*No description*
[RepositoryProjectConfig](#cdktf-provider-github-repositoryprojectconfig)|*No description*
[RepositoryPullRequestConfig](#cdktf-provider-github-repositorypullrequestconfig)|*No description*
[RepositoryTemplate](#cdktf-provider-github-repositorytemplate)|*No description*
[RepositoryWebhookConfig](#cdktf-provider-github-repositorywebhookconfig)|*No description*
[RepositoryWebhookConfiguration](#cdktf-provider-github-repositorywebhookconfiguration)|*No description*
[TeamConfig](#cdktf-provider-github-teamconfig)|*No description*
[TeamMembershipConfig](#cdktf-provider-github-teammembershipconfig)|*No description*
[TeamRepositoryConfig](#cdktf-provider-github-teamrepositoryconfig)|*No description*
[TeamSyncGroupMappingConfig](#cdktf-provider-github-teamsyncgroupmappingconfig)|*No description*
[TeamSyncGroupMappingGroup](#cdktf-provider-github-teamsyncgroupmappinggroup)|*No description*
[UserGpgKeyConfig](#cdktf-provider-github-usergpgkeyconfig)|*No description*
[UserInvitationAccepterConfig](#cdktf-provider-github-userinvitationaccepterconfig)|*No description*
[UserSshKeyConfig](#cdktf-provider-github-usersshkeyconfig)|*No description*



## class ActionsEnvironmentSecret  <a id="cdktf-provider-github-actionsenvironmentsecret"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/actions_environment_secret.html github_actions_environment_secret}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/actions_environment_secret.html github_actions_environment_secret} Resource.

```ts
new ActionsEnvironmentSecret(scope: Construct, id: string, config: ActionsEnvironmentSecretConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[ActionsEnvironmentSecretConfig](#cdktf-provider-github-actionsenvironmentsecretconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **environment** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_environment_secret.html#environment ActionsEnvironmentSecret#environment}. 
  * **repository** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_environment_secret.html#repository ActionsEnvironmentSecret#repository}. 
  * **secretName** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_environment_secret.html#secret_name ActionsEnvironmentSecret#secret_name}. 
  * **encryptedValue** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_environment_secret.html#encrypted_value ActionsEnvironmentSecret#encrypted_value}. __*Optional*__
  * **plaintextValue** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_environment_secret.html#plaintext_value ActionsEnvironmentSecret#plaintext_value}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**createdAt** | <code>string</code> | <span></span>
**encryptedValue** | <code>string</code> | <span></span>
**environment** | <code>string</code> | <span></span>
**environmentInput** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**plaintextValue** | <code>string</code> | <span></span>
**repository** | <code>string</code> | <span></span>
**repositoryInput** | <code>string</code> | <span></span>
**secretName** | <code>string</code> | <span></span>
**secretNameInput** | <code>string</code> | <span></span>
**updatedAt** | <code>string</code> | <span></span>
**encryptedValueInput**? | <code>string</code> | __*Optional*__
**plaintextValueInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetEncryptedValue() <a id="cdktf-provider-github-actionsenvironmentsecret-resetencryptedvalue"></a>



```ts
resetEncryptedValue(): void
```





#### resetPlaintextValue() <a id="cdktf-provider-github-actionsenvironmentsecret-resetplaintextvalue"></a>



```ts
resetPlaintextValue(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-actionsenvironmentsecret-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class ActionsOrganizationSecret  <a id="cdktf-provider-github-actionsorganizationsecret"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret.html github_actions_organization_secret}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret.html github_actions_organization_secret} Resource.

```ts
new ActionsOrganizationSecret(scope: Construct, id: string, config: ActionsOrganizationSecretConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[ActionsOrganizationSecretConfig](#cdktf-provider-github-actionsorganizationsecretconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **secretName** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret.html#secret_name ActionsOrganizationSecret#secret_name}. 
  * **visibility** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret.html#visibility ActionsOrganizationSecret#visibility}. 
  * **encryptedValue** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret.html#encrypted_value ActionsOrganizationSecret#encrypted_value}. __*Optional*__
  * **plaintextValue** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret.html#plaintext_value ActionsOrganizationSecret#plaintext_value}. __*Optional*__
  * **selectedRepositoryIds** (<code>Array<number></code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret.html#selected_repository_ids ActionsOrganizationSecret#selected_repository_ids}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**createdAt** | <code>string</code> | <span></span>
**encryptedValue** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**plaintextValue** | <code>string</code> | <span></span>
**secretName** | <code>string</code> | <span></span>
**secretNameInput** | <code>string</code> | <span></span>
**selectedRepositoryIds** | <code>Array<number></code> | <span></span>
**updatedAt** | <code>string</code> | <span></span>
**visibility** | <code>string</code> | <span></span>
**visibilityInput** | <code>string</code> | <span></span>
**encryptedValueInput**? | <code>string</code> | __*Optional*__
**plaintextValueInput**? | <code>string</code> | __*Optional*__
**selectedRepositoryIdsInput**? | <code>Array<number></code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetEncryptedValue() <a id="cdktf-provider-github-actionsorganizationsecret-resetencryptedvalue"></a>



```ts
resetEncryptedValue(): void
```





#### resetPlaintextValue() <a id="cdktf-provider-github-actionsorganizationsecret-resetplaintextvalue"></a>



```ts
resetPlaintextValue(): void
```





#### resetSelectedRepositoryIds() <a id="cdktf-provider-github-actionsorganizationsecret-resetselectedrepositoryids"></a>



```ts
resetSelectedRepositoryIds(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-actionsorganizationsecret-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class ActionsOrganizationSecretRepositories  <a id="cdktf-provider-github-actionsorganizationsecretrepositories"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret_repositories.html github_actions_organization_secret_repositories}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret_repositories.html github_actions_organization_secret_repositories} Resource.

```ts
new ActionsOrganizationSecretRepositories(scope: Construct, id: string, config: ActionsOrganizationSecretRepositoriesConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[ActionsOrganizationSecretRepositoriesConfig](#cdktf-provider-github-actionsorganizationsecretrepositoriesconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **secretName** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret_repositories.html#secret_name ActionsOrganizationSecretRepositories#secret_name}. 
  * **selectedRepositoryIds** (<code>Array<number></code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret_repositories.html#selected_repository_ids ActionsOrganizationSecretRepositories#selected_repository_ids}. 



### Properties


Name | Type | Description 
-----|------|-------------
**id** | <code>string</code> | <span></span>
**secretName** | <code>string</code> | <span></span>
**secretNameInput** | <code>string</code> | <span></span>
**selectedRepositoryIds** | <code>Array<number></code> | <span></span>
**selectedRepositoryIdsInput** | <code>Array<number></code> | <span></span>
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### protected synthesizeAttributes() <a id="cdktf-provider-github-actionsorganizationsecretrepositories-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class ActionsRunnerGroup  <a id="cdktf-provider-github-actionsrunnergroup"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/actions_runner_group.html github_actions_runner_group}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/actions_runner_group.html github_actions_runner_group} Resource.

```ts
new ActionsRunnerGroup(scope: Construct, id: string, config: ActionsRunnerGroupConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[ActionsRunnerGroupConfig](#cdktf-provider-github-actionsrunnergroupconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **name** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_runner_group.html#name ActionsRunnerGroup#name}. 
  * **visibility** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_runner_group.html#visibility ActionsRunnerGroup#visibility}. 
  * **selectedRepositoryIds** (<code>Array<number></code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_runner_group.html#selected_repository_ids ActionsRunnerGroup#selected_repository_ids}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**allowsPublicRepositories** | <code>[IResolvable](#cdktf-iresolvable)</code> | <span></span>
**default** | <code>[IResolvable](#cdktf-iresolvable)</code> | <span></span>
**etag** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**inherited** | <code>[IResolvable](#cdktf-iresolvable)</code> | <span></span>
**name** | <code>string</code> | <span></span>
**nameInput** | <code>string</code> | <span></span>
**runnersUrl** | <code>string</code> | <span></span>
**selectedRepositoriesUrl** | <code>string</code> | <span></span>
**selectedRepositoryIds** | <code>Array<number></code> | <span></span>
**visibility** | <code>string</code> | <span></span>
**visibilityInput** | <code>string</code> | <span></span>
**selectedRepositoryIdsInput**? | <code>Array<number></code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetSelectedRepositoryIds() <a id="cdktf-provider-github-actionsrunnergroup-resetselectedrepositoryids"></a>



```ts
resetSelectedRepositoryIds(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-actionsrunnergroup-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class ActionsSecret  <a id="cdktf-provider-github-actionssecret"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/actions_secret.html github_actions_secret}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/actions_secret.html github_actions_secret} Resource.

```ts
new ActionsSecret(scope: Construct, id: string, config: ActionsSecretConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[ActionsSecretConfig](#cdktf-provider-github-actionssecretconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **repository** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_secret.html#repository ActionsSecret#repository}. 
  * **secretName** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_secret.html#secret_name ActionsSecret#secret_name}. 
  * **encryptedValue** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_secret.html#encrypted_value ActionsSecret#encrypted_value}. __*Optional*__
  * **plaintextValue** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_secret.html#plaintext_value ActionsSecret#plaintext_value}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**createdAt** | <code>string</code> | <span></span>
**encryptedValue** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**plaintextValue** | <code>string</code> | <span></span>
**repository** | <code>string</code> | <span></span>
**repositoryInput** | <code>string</code> | <span></span>
**secretName** | <code>string</code> | <span></span>
**secretNameInput** | <code>string</code> | <span></span>
**updatedAt** | <code>string</code> | <span></span>
**encryptedValueInput**? | <code>string</code> | __*Optional*__
**plaintextValueInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetEncryptedValue() <a id="cdktf-provider-github-actionssecret-resetencryptedvalue"></a>



```ts
resetEncryptedValue(): void
```





#### resetPlaintextValue() <a id="cdktf-provider-github-actionssecret-resetplaintextvalue"></a>



```ts
resetPlaintextValue(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-actionssecret-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class AppInstallationRepository  <a id="cdktf-provider-github-appinstallationrepository"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/app_installation_repository.html github_app_installation_repository}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/app_installation_repository.html github_app_installation_repository} Resource.

```ts
new AppInstallationRepository(scope: Construct, id: string, config: AppInstallationRepositoryConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[AppInstallationRepositoryConfig](#cdktf-provider-github-appinstallationrepositoryconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **installationId** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/app_installation_repository.html#installation_id AppInstallationRepository#installation_id}. 
  * **repository** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/app_installation_repository.html#repository AppInstallationRepository#repository}. 



### Properties


Name | Type | Description 
-----|------|-------------
**id** | <code>string</code> | <span></span>
**installationId** | <code>string</code> | <span></span>
**installationIdInput** | <code>string</code> | <span></span>
**repoId** | <code>number</code> | <span></span>
**repository** | <code>string</code> | <span></span>
**repositoryInput** | <code>string</code> | <span></span>
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### protected synthesizeAttributes() <a id="cdktf-provider-github-appinstallationrepository-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class Branch  <a id="cdktf-provider-github-branch"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/branch.html github_branch}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/branch.html github_branch} Resource.

```ts
new Branch(scope: Construct, id: string, config: BranchConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[BranchConfig](#cdktf-provider-github-branchconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **branch** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch.html#branch Branch#branch}. 
  * **repository** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch.html#repository Branch#repository}. 
  * **sourceBranch** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch.html#source_branch Branch#source_branch}. __*Optional*__
  * **sourceSha** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch.html#source_sha Branch#source_sha}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**branch** | <code>string</code> | <span></span>
**branchInput** | <code>string</code> | <span></span>
**etag** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**ref** | <code>string</code> | <span></span>
**repository** | <code>string</code> | <span></span>
**repositoryInput** | <code>string</code> | <span></span>
**sha** | <code>string</code> | <span></span>
**sourceBranch** | <code>string</code> | <span></span>
**sourceSha** | <code>string</code> | <span></span>
**sourceBranchInput**? | <code>string</code> | __*Optional*__
**sourceShaInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetSourceBranch() <a id="cdktf-provider-github-branch-resetsourcebranch"></a>



```ts
resetSourceBranch(): void
```





#### resetSourceSha() <a id="cdktf-provider-github-branch-resetsourcesha"></a>



```ts
resetSourceSha(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-branch-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class BranchDefault  <a id="cdktf-provider-github-branchdefault"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/branch_default.html github_branch_default}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/branch_default.html github_branch_default} Resource.

```ts
new BranchDefault(scope: Construct, id: string, config: BranchDefaultConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[BranchDefaultConfig](#cdktf-provider-github-branchdefaultconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **branch** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_default.html#branch BranchDefault#branch}. 
  * **repository** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_default.html#repository BranchDefault#repository}. 



### Properties


Name | Type | Description 
-----|------|-------------
**branch** | <code>string</code> | <span></span>
**branchInput** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**repository** | <code>string</code> | <span></span>
**repositoryInput** | <code>string</code> | <span></span>
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### protected synthesizeAttributes() <a id="cdktf-provider-github-branchdefault-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class BranchProtection  <a id="cdktf-provider-github-branchprotection"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html github_branch_protection}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html github_branch_protection} Resource.

```ts
new BranchProtection(scope: Construct, id: string, config: BranchProtectionConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[BranchProtectionConfig](#cdktf-provider-github-branchprotectionconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **pattern** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#pattern BranchProtection#pattern}. 
  * **repositoryId** (<code>string</code>)  Node ID or name of repository. 
  * **allowsDeletions** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#allows_deletions BranchProtection#allows_deletions}. __*Optional*__
  * **allowsForcePushes** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#allows_force_pushes BranchProtection#allows_force_pushes}. __*Optional*__
  * **enforceAdmins** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#enforce_admins BranchProtection#enforce_admins}. __*Optional*__
  * **pushRestrictions** (<code>Array<string></code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#push_restrictions BranchProtection#push_restrictions}. __*Optional*__
  * **requiredLinearHistory** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#required_linear_history BranchProtection#required_linear_history}. __*Optional*__
  * **requiredPullRequestReviews** (<code>Array<[BranchProtectionRequiredPullRequestReviews](#cdktf-provider-github-branchprotectionrequiredpullrequestreviews)></code>)  required_pull_request_reviews block. __*Optional*__
  * **requiredStatusChecks** (<code>Array<[BranchProtectionRequiredStatusChecks](#cdktf-provider-github-branchprotectionrequiredstatuschecks)></code>)  required_status_checks block. __*Optional*__
  * **requireSignedCommits** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#require_signed_commits BranchProtection#require_signed_commits}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**allowsDeletions** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**allowsForcePushes** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**enforceAdmins** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**id** | <code>string</code> | <span></span>
**pattern** | <code>string</code> | <span></span>
**patternInput** | <code>string</code> | <span></span>
**pushRestrictions** | <code>Array<string></code> | <span></span>
**repositoryId** | <code>string</code> | <span></span>
**repositoryIdInput** | <code>string</code> | <span></span>
**requireSignedCommits** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**requiredLinearHistory** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**requiredPullRequestReviews** | <code>Array<[BranchProtectionRequiredPullRequestReviews](#cdktf-provider-github-branchprotectionrequiredpullrequestreviews)></code> | <span></span>
**requiredStatusChecks** | <code>Array<[BranchProtectionRequiredStatusChecks](#cdktf-provider-github-branchprotectionrequiredstatuschecks)></code> | <span></span>
**allowsDeletionsInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**allowsForcePushesInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**enforceAdminsInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**pushRestrictionsInput**? | <code>Array<string></code> | __*Optional*__
**requireSignedCommitsInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**requiredLinearHistoryInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**requiredPullRequestReviewsInput**? | <code>Array<[BranchProtectionRequiredPullRequestReviews](#cdktf-provider-github-branchprotectionrequiredpullrequestreviews)></code> | __*Optional*__
**requiredStatusChecksInput**? | <code>Array<[BranchProtectionRequiredStatusChecks](#cdktf-provider-github-branchprotectionrequiredstatuschecks)></code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetAllowsDeletions() <a id="cdktf-provider-github-branchprotection-resetallowsdeletions"></a>



```ts
resetAllowsDeletions(): void
```





#### resetAllowsForcePushes() <a id="cdktf-provider-github-branchprotection-resetallowsforcepushes"></a>



```ts
resetAllowsForcePushes(): void
```





#### resetEnforceAdmins() <a id="cdktf-provider-github-branchprotection-resetenforceadmins"></a>



```ts
resetEnforceAdmins(): void
```





#### resetPushRestrictions() <a id="cdktf-provider-github-branchprotection-resetpushrestrictions"></a>



```ts
resetPushRestrictions(): void
```





#### resetRequireSignedCommits() <a id="cdktf-provider-github-branchprotection-resetrequiresignedcommits"></a>



```ts
resetRequireSignedCommits(): void
```





#### resetRequiredLinearHistory() <a id="cdktf-provider-github-branchprotection-resetrequiredlinearhistory"></a>



```ts
resetRequiredLinearHistory(): void
```





#### resetRequiredPullRequestReviews() <a id="cdktf-provider-github-branchprotection-resetrequiredpullrequestreviews"></a>



```ts
resetRequiredPullRequestReviews(): void
```





#### resetRequiredStatusChecks() <a id="cdktf-provider-github-branchprotection-resetrequiredstatuschecks"></a>



```ts
resetRequiredStatusChecks(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-branchprotection-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class BranchProtectionV3  <a id="cdktf-provider-github-branchprotectionv3"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html github_branch_protection_v3}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html github_branch_protection_v3} Resource.

```ts
new BranchProtectionV3(scope: Construct, id: string, config: BranchProtectionV3Config)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[BranchProtectionV3Config](#cdktf-provider-github-branchprotectionv3config)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **branch** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#branch BranchProtectionV3#branch}. 
  * **repository** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#repository BranchProtectionV3#repository}. 
  * **enforceAdmins** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#enforce_admins BranchProtectionV3#enforce_admins}. __*Optional*__
  * **requiredPullRequestReviews** (<code>Array<[BranchProtectionV3RequiredPullRequestReviews](#cdktf-provider-github-branchprotectionv3requiredpullrequestreviews)></code>)  required_pull_request_reviews block. __*Optional*__
  * **requiredStatusChecks** (<code>Array<[BranchProtectionV3RequiredStatusChecks](#cdktf-provider-github-branchprotectionv3requiredstatuschecks)></code>)  required_status_checks block. __*Optional*__
  * **requireSignedCommits** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#require_signed_commits BranchProtectionV3#require_signed_commits}. __*Optional*__
  * **restrictions** (<code>Array<[BranchProtectionV3Restrictions](#cdktf-provider-github-branchprotectionv3restrictions)></code>)  restrictions block. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**branch** | <code>string</code> | <span></span>
**branchInput** | <code>string</code> | <span></span>
**enforceAdmins** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**etag** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**repository** | <code>string</code> | <span></span>
**repositoryInput** | <code>string</code> | <span></span>
**requireSignedCommits** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**requiredPullRequestReviews** | <code>Array<[BranchProtectionV3RequiredPullRequestReviews](#cdktf-provider-github-branchprotectionv3requiredpullrequestreviews)></code> | <span></span>
**requiredStatusChecks** | <code>Array<[BranchProtectionV3RequiredStatusChecks](#cdktf-provider-github-branchprotectionv3requiredstatuschecks)></code> | <span></span>
**restrictions** | <code>Array<[BranchProtectionV3Restrictions](#cdktf-provider-github-branchprotectionv3restrictions)></code> | <span></span>
**enforceAdminsInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**requireSignedCommitsInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**requiredPullRequestReviewsInput**? | <code>Array<[BranchProtectionV3RequiredPullRequestReviews](#cdktf-provider-github-branchprotectionv3requiredpullrequestreviews)></code> | __*Optional*__
**requiredStatusChecksInput**? | <code>Array<[BranchProtectionV3RequiredStatusChecks](#cdktf-provider-github-branchprotectionv3requiredstatuschecks)></code> | __*Optional*__
**restrictionsInput**? | <code>Array<[BranchProtectionV3Restrictions](#cdktf-provider-github-branchprotectionv3restrictions)></code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetEnforceAdmins() <a id="cdktf-provider-github-branchprotectionv3-resetenforceadmins"></a>



```ts
resetEnforceAdmins(): void
```





#### resetRequireSignedCommits() <a id="cdktf-provider-github-branchprotectionv3-resetrequiresignedcommits"></a>



```ts
resetRequireSignedCommits(): void
```





#### resetRequiredPullRequestReviews() <a id="cdktf-provider-github-branchprotectionv3-resetrequiredpullrequestreviews"></a>



```ts
resetRequiredPullRequestReviews(): void
```





#### resetRequiredStatusChecks() <a id="cdktf-provider-github-branchprotectionv3-resetrequiredstatuschecks"></a>



```ts
resetRequiredStatusChecks(): void
```





#### resetRestrictions() <a id="cdktf-provider-github-branchprotectionv3-resetrestrictions"></a>



```ts
resetRestrictions(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-branchprotectionv3-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class DataGithubActionsPublicKey  <a id="cdktf-provider-github-datagithubactionspublickey"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/d/actions_public_key.html github_actions_public_key}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformDataSource](#cdktf-terraformdatasource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/d/actions_public_key.html github_actions_public_key} Data Source.

```ts
new DataGithubActionsPublicKey(scope: Construct, id: string, config: DataGithubActionsPublicKeyConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[DataGithubActionsPublicKeyConfig](#cdktf-provider-github-datagithubactionspublickeyconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **repository** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/actions_public_key.html#repository DataGithubActionsPublicKey#repository}. 



### Properties


Name | Type | Description 
-----|------|-------------
**id** | <code>string</code> | <span></span>
**key** | <code>string</code> | <span></span>
**keyId** | <code>string</code> | <span></span>
**repository** | <code>string</code> | <span></span>
**repositoryInput** | <code>string</code> | <span></span>
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### protected synthesizeAttributes() <a id="cdktf-provider-github-datagithubactionspublickey-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class DataGithubBranch  <a id="cdktf-provider-github-datagithubbranch"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/d/branch.html github_branch}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformDataSource](#cdktf-terraformdatasource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/d/branch.html github_branch} Data Source.

```ts
new DataGithubBranch(scope: Construct, id: string, config: DataGithubBranchConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[DataGithubBranchConfig](#cdktf-provider-github-datagithubbranchconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **branch** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/branch.html#branch DataGithubBranch#branch}. 
  * **repository** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/branch.html#repository DataGithubBranch#repository}. 



### Properties


Name | Type | Description 
-----|------|-------------
**branch** | <code>string</code> | <span></span>
**branchInput** | <code>string</code> | <span></span>
**etag** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**ref** | <code>string</code> | <span></span>
**repository** | <code>string</code> | <span></span>
**repositoryInput** | <code>string</code> | <span></span>
**sha** | <code>string</code> | <span></span>
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### protected synthesizeAttributes() <a id="cdktf-provider-github-datagithubbranch-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class DataGithubCollaborators  <a id="cdktf-provider-github-datagithubcollaborators"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/d/collaborators.html github_collaborators}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformDataSource](#cdktf-terraformdatasource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/d/collaborators.html github_collaborators} Data Source.

```ts
new DataGithubCollaborators(scope: Construct, id: string, config: DataGithubCollaboratorsConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[DataGithubCollaboratorsConfig](#cdktf-provider-github-datagithubcollaboratorsconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **owner** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/collaborators.html#owner DataGithubCollaborators#owner}. 
  * **repository** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/collaborators.html#repository DataGithubCollaborators#repository}. 
  * **affiliation** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/collaborators.html#affiliation DataGithubCollaborators#affiliation}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**affiliation** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**owner** | <code>string</code> | <span></span>
**ownerInput** | <code>string</code> | <span></span>
**repository** | <code>string</code> | <span></span>
**repositoryInput** | <code>string</code> | <span></span>
**affiliationInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### collaborator(index) <a id="cdktf-provider-github-datagithubcollaborators-collaborator"></a>



```ts
collaborator(index: string): DataGithubCollaboratorsCollaborator
```

* **index** (<code>string</code>)  *No description*

__Returns__:
* <code>[DataGithubCollaboratorsCollaborator](#cdktf-provider-github-datagithubcollaboratorscollaborator)</code>

#### resetAffiliation() <a id="cdktf-provider-github-datagithubcollaborators-resetaffiliation"></a>



```ts
resetAffiliation(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-datagithubcollaborators-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class DataGithubCollaboratorsCollaborator  <a id="cdktf-provider-github-datagithubcollaboratorscollaborator"></a>



__Extends__: [ComplexComputedList](#cdktf-complexcomputedlist)

### Initializer




```ts
new DataGithubCollaboratorsCollaborator(terraformResource: ITerraformResource, terraformAttribute: string, complexComputedListIndex: string)
```

* **terraformResource** (<code>[ITerraformResource](#cdktf-iterraformresource)</code>)  *No description*
* **terraformAttribute** (<code>string</code>)  *No description*
* **complexComputedListIndex** (<code>string</code>)  *No description*



### Properties


Name | Type | Description 
-----|------|-------------
**eventsUrl** | <code>string</code> | <span></span>
**followersUrl** | <code>string</code> | <span></span>
**followingUrl** | <code>string</code> | <span></span>
**gistsUrl** | <code>string</code> | <span></span>
**htmlUrl** | <code>string</code> | <span></span>
**id** | <code>number</code> | <span></span>
**login** | <code>string</code> | <span></span>
**organizationsUrl** | <code>string</code> | <span></span>
**permission** | <code>string</code> | <span></span>
**receivedEventsUrl** | <code>string</code> | <span></span>
**reposUrl** | <code>string</code> | <span></span>
**siteAdmin** | <code>any</code> | <span></span>
**starredUrl** | <code>string</code> | <span></span>
**subscriptionsUrl** | <code>string</code> | <span></span>
**type** | <code>string</code> | <span></span>
**url** | <code>string</code> | <span></span>



## class DataGithubIpRanges  <a id="cdktf-provider-github-datagithubipranges"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/d/ip_ranges.html github_ip_ranges}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformDataSource](#cdktf-terraformdatasource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/d/ip_ranges.html github_ip_ranges} Data Source.

```ts
new DataGithubIpRanges(scope: Construct, id: string, config?: DataGithubIpRangesConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[DataGithubIpRangesConfig](#cdktf-provider-github-datagithubiprangesconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**actions** | <code>Array<string></code> | <span></span>
**actionsIpv4** | <code>Array<string></code> | <span></span>
**actionsIpv6** | <code>Array<string></code> | <span></span>
**dependabot** | <code>Array<string></code> | <span></span>
**dependabotIpv4** | <code>Array<string></code> | <span></span>
**dependabotIpv6** | <code>Array<string></code> | <span></span>
**git** | <code>Array<string></code> | <span></span>
**gitIpv4** | <code>Array<string></code> | <span></span>
**gitIpv6** | <code>Array<string></code> | <span></span>
**hooks** | <code>Array<string></code> | <span></span>
**hooksIpv4** | <code>Array<string></code> | <span></span>
**hooksIpv6** | <code>Array<string></code> | <span></span>
**id** | <code>string</code> | <span></span>
**importer** | <code>Array<string></code> | <span></span>
**importerIpv4** | <code>Array<string></code> | <span></span>
**importerIpv6** | <code>Array<string></code> | <span></span>
**pages** | <code>Array<string></code> | <span></span>
**pagesIpv4** | <code>Array<string></code> | <span></span>
**pagesIpv6** | <code>Array<string></code> | <span></span>
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### protected synthesizeAttributes() <a id="cdktf-provider-github-datagithubipranges-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class DataGithubMembership  <a id="cdktf-provider-github-datagithubmembership"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/d/membership.html github_membership}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformDataSource](#cdktf-terraformdatasource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/d/membership.html github_membership} Data Source.

```ts
new DataGithubMembership(scope: Construct, id: string, config: DataGithubMembershipConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[DataGithubMembershipConfig](#cdktf-provider-github-datagithubmembershipconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **username** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/membership.html#username DataGithubMembership#username}. 
  * **organization** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/membership.html#organization DataGithubMembership#organization}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**etag** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**organization** | <code>string</code> | <span></span>
**role** | <code>string</code> | <span></span>
**username** | <code>string</code> | <span></span>
**usernameInput** | <code>string</code> | <span></span>
**organizationInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetOrganization() <a id="cdktf-provider-github-datagithubmembership-resetorganization"></a>



```ts
resetOrganization(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-datagithubmembership-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class DataGithubOrganization  <a id="cdktf-provider-github-datagithuborganization"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/d/organization.html github_organization}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformDataSource](#cdktf-terraformdatasource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/d/organization.html github_organization} Data Source.

```ts
new DataGithubOrganization(scope: Construct, id: string, config: DataGithubOrganizationConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[DataGithubOrganizationConfig](#cdktf-provider-github-datagithuborganizationconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **name** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/organization.html#name DataGithubOrganization#name}. 



### Properties


Name | Type | Description 
-----|------|-------------
**description** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**login** | <code>string</code> | <span></span>
**members** | <code>Array<string></code> | <span></span>
**name** | <code>string</code> | <span></span>
**nameInput** | <code>string</code> | <span></span>
**nodeId** | <code>string</code> | <span></span>
**plan** | <code>string</code> | <span></span>
**repositories** | <code>Array<string></code> | <span></span>
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### protected synthesizeAttributes() <a id="cdktf-provider-github-datagithuborganization-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class DataGithubOrganizationTeamSyncGroups  <a id="cdktf-provider-github-datagithuborganizationteamsyncgroups"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/d/organization_team_sync_groups.html github_organization_team_sync_groups}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformDataSource](#cdktf-terraformdatasource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/d/organization_team_sync_groups.html github_organization_team_sync_groups} Data Source.

```ts
new DataGithubOrganizationTeamSyncGroups(scope: Construct, id: string, config?: DataGithubOrganizationTeamSyncGroupsConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[DataGithubOrganizationTeamSyncGroupsConfig](#cdktf-provider-github-datagithuborganizationteamsyncgroupsconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**id** | <code>string</code> | <span></span>
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### groups(index) <a id="cdktf-provider-github-datagithuborganizationteamsyncgroups-groups"></a>



```ts
groups(index: string): DataGithubOrganizationTeamSyncGroupsGroups
```

* **index** (<code>string</code>)  *No description*

__Returns__:
* <code>[DataGithubOrganizationTeamSyncGroupsGroups](#cdktf-provider-github-datagithuborganizationteamsyncgroupsgroups)</code>

#### protected synthesizeAttributes() <a id="cdktf-provider-github-datagithuborganizationteamsyncgroups-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class DataGithubOrganizationTeamSyncGroupsGroups  <a id="cdktf-provider-github-datagithuborganizationteamsyncgroupsgroups"></a>



__Extends__: [ComplexComputedList](#cdktf-complexcomputedlist)

### Initializer




```ts
new DataGithubOrganizationTeamSyncGroupsGroups(terraformResource: ITerraformResource, terraformAttribute: string, complexComputedListIndex: string)
```

* **terraformResource** (<code>[ITerraformResource](#cdktf-iterraformresource)</code>)  *No description*
* **terraformAttribute** (<code>string</code>)  *No description*
* **complexComputedListIndex** (<code>string</code>)  *No description*



### Properties


Name | Type | Description 
-----|------|-------------
**groupDescription** | <code>string</code> | <span></span>
**groupId** | <code>string</code> | <span></span>
**groupName** | <code>string</code> | <span></span>



## class DataGithubOrganizationTeams  <a id="cdktf-provider-github-datagithuborganizationteams"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/d/organization_teams.html github_organization_teams}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformDataSource](#cdktf-terraformdatasource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/d/organization_teams.html github_organization_teams} Data Source.

```ts
new DataGithubOrganizationTeams(scope: Construct, id: string, config?: DataGithubOrganizationTeamsConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[DataGithubOrganizationTeamsConfig](#cdktf-provider-github-datagithuborganizationteamsconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **rootTeamsOnly** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/organization_teams.html#root_teams_only DataGithubOrganizationTeams#root_teams_only}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**id** | <code>string</code> | <span></span>
**rootTeamsOnly** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**rootTeamsOnlyInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetRootTeamsOnly() <a id="cdktf-provider-github-datagithuborganizationteams-resetrootteamsonly"></a>



```ts
resetRootTeamsOnly(): void
```





#### teams(index) <a id="cdktf-provider-github-datagithuborganizationteams-teams"></a>



```ts
teams(index: string): DataGithubOrganizationTeamsTeams
```

* **index** (<code>string</code>)  *No description*

__Returns__:
* <code>[DataGithubOrganizationTeamsTeams](#cdktf-provider-github-datagithuborganizationteamsteams)</code>

#### protected synthesizeAttributes() <a id="cdktf-provider-github-datagithuborganizationteams-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class DataGithubOrganizationTeamsTeams  <a id="cdktf-provider-github-datagithuborganizationteamsteams"></a>



__Extends__: [ComplexComputedList](#cdktf-complexcomputedlist)

### Initializer




```ts
new DataGithubOrganizationTeamsTeams(terraformResource: ITerraformResource, terraformAttribute: string, complexComputedListIndex: string)
```

* **terraformResource** (<code>[ITerraformResource](#cdktf-iterraformresource)</code>)  *No description*
* **terraformAttribute** (<code>string</code>)  *No description*
* **complexComputedListIndex** (<code>string</code>)  *No description*



### Properties


Name | Type | Description 
-----|------|-------------
**description** | <code>string</code> | <span></span>
**id** | <code>number</code> | <span></span>
**members** | <code>Array<string></code> | <span></span>
**name** | <code>string</code> | <span></span>
**nodeId** | <code>string</code> | <span></span>
**privacy** | <code>string</code> | <span></span>
**repositories** | <code>Array<string></code> | <span></span>
**slug** | <code>string</code> | <span></span>



## class DataGithubRelease  <a id="cdktf-provider-github-datagithubrelease"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/d/release.html github_release}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformDataSource](#cdktf-terraformdatasource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/d/release.html github_release} Data Source.

```ts
new DataGithubRelease(scope: Construct, id: string, config: DataGithubReleaseConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[DataGithubReleaseConfig](#cdktf-provider-github-datagithubreleaseconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **owner** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/release.html#owner DataGithubRelease#owner}. 
  * **repository** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/release.html#repository DataGithubRelease#repository}. 
  * **retrieveBy** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/release.html#retrieve_by DataGithubRelease#retrieve_by}. 
  * **releaseId** (<code>number</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/release.html#release_id DataGithubRelease#release_id}. __*Optional*__
  * **releaseTag** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/release.html#release_tag DataGithubRelease#release_tag}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**assertsUrl** | <code>string</code> | <span></span>
**body** | <code>string</code> | <span></span>
**createdAt** | <code>string</code> | <span></span>
**draft** | <code>[IResolvable](#cdktf-iresolvable)</code> | <span></span>
**htmlUrl** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**name** | <code>string</code> | <span></span>
**owner** | <code>string</code> | <span></span>
**ownerInput** | <code>string</code> | <span></span>
**prerelease** | <code>[IResolvable](#cdktf-iresolvable)</code> | <span></span>
**publishedAt** | <code>string</code> | <span></span>
**releaseId** | <code>number</code> | <span></span>
**releaseTag** | <code>string</code> | <span></span>
**repository** | <code>string</code> | <span></span>
**repositoryInput** | <code>string</code> | <span></span>
**retrieveBy** | <code>string</code> | <span></span>
**retrieveByInput** | <code>string</code> | <span></span>
**tarballUrl** | <code>string</code> | <span></span>
**targetCommitish** | <code>string</code> | <span></span>
**uploadUrl** | <code>string</code> | <span></span>
**url** | <code>string</code> | <span></span>
**zipballUrl** | <code>string</code> | <span></span>
**releaseIdInput**? | <code>number</code> | __*Optional*__
**releaseTagInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetReleaseId() <a id="cdktf-provider-github-datagithubrelease-resetreleaseid"></a>



```ts
resetReleaseId(): void
```





#### resetReleaseTag() <a id="cdktf-provider-github-datagithubrelease-resetreleasetag"></a>



```ts
resetReleaseTag(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-datagithubrelease-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class DataGithubRepositories  <a id="cdktf-provider-github-datagithubrepositories"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/d/repositories.html github_repositories}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformDataSource](#cdktf-terraformdatasource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/d/repositories.html github_repositories} Data Source.

```ts
new DataGithubRepositories(scope: Construct, id: string, config: DataGithubRepositoriesConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[DataGithubRepositoriesConfig](#cdktf-provider-github-datagithubrepositoriesconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **query** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repositories.html#query DataGithubRepositories#query}. 
  * **sort** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repositories.html#sort DataGithubRepositories#sort}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**fullNames** | <code>Array<string></code> | <span></span>
**id** | <code>string</code> | <span></span>
**names** | <code>Array<string></code> | <span></span>
**query** | <code>string</code> | <span></span>
**queryInput** | <code>string</code> | <span></span>
**sort** | <code>string</code> | <span></span>
**sortInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetSort() <a id="cdktf-provider-github-datagithubrepositories-resetsort"></a>



```ts
resetSort(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-datagithubrepositories-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class DataGithubRepository  <a id="cdktf-provider-github-datagithubrepository"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/d/repository.html github_repository}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformDataSource](#cdktf-terraformdatasource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/d/repository.html github_repository} Data Source.

```ts
new DataGithubRepository(scope: Construct, id: string, config?: DataGithubRepositoryConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[DataGithubRepositoryConfig](#cdktf-provider-github-datagithubrepositoryconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **description** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository.html#description DataGithubRepository#description}. __*Optional*__
  * **fullName** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository.html#full_name DataGithubRepository#full_name}. __*Optional*__
  * **homepageUrl** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository.html#homepage_url DataGithubRepository#homepage_url}. __*Optional*__
  * **name** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository.html#name DataGithubRepository#name}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**allowMergeCommit** | <code>[IResolvable](#cdktf-iresolvable)</code> | <span></span>
**allowRebaseMerge** | <code>[IResolvable](#cdktf-iresolvable)</code> | <span></span>
**allowSquashMerge** | <code>[IResolvable](#cdktf-iresolvable)</code> | <span></span>
**archived** | <code>[IResolvable](#cdktf-iresolvable)</code> | <span></span>
**defaultBranch** | <code>string</code> | <span></span>
**description** | <code>string</code> | <span></span>
**fullName** | <code>string</code> | <span></span>
**gitCloneUrl** | <code>string</code> | <span></span>
**hasDownloads** | <code>[IResolvable](#cdktf-iresolvable)</code> | <span></span>
**hasIssues** | <code>[IResolvable](#cdktf-iresolvable)</code> | <span></span>
**hasProjects** | <code>[IResolvable](#cdktf-iresolvable)</code> | <span></span>
**hasWiki** | <code>[IResolvable](#cdktf-iresolvable)</code> | <span></span>
**homepageUrl** | <code>string</code> | <span></span>
**htmlUrl** | <code>string</code> | <span></span>
**httpCloneUrl** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**name** | <code>string</code> | <span></span>
**nodeId** | <code>string</code> | <span></span>
**private** | <code>[IResolvable](#cdktf-iresolvable)</code> | <span></span>
**repoId** | <code>number</code> | <span></span>
**sshCloneUrl** | <code>string</code> | <span></span>
**svnUrl** | <code>string</code> | <span></span>
**topics** | <code>Array<string></code> | <span></span>
**visibility** | <code>string</code> | <span></span>
**descriptionInput**? | <code>string</code> | __*Optional*__
**fullNameInput**? | <code>string</code> | __*Optional*__
**homepageUrlInput**? | <code>string</code> | __*Optional*__
**nameInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### branches(index) <a id="cdktf-provider-github-datagithubrepository-branches"></a>



```ts
branches(index: string): DataGithubRepositoryBranches
```

* **index** (<code>string</code>)  *No description*

__Returns__:
* <code>[DataGithubRepositoryBranches](#cdktf-provider-github-datagithubrepositorybranches)</code>

#### pages(index) <a id="cdktf-provider-github-datagithubrepository-pages"></a>



```ts
pages(index: string): DataGithubRepositoryPages
```

* **index** (<code>string</code>)  *No description*

__Returns__:
* <code>[DataGithubRepositoryPages](#cdktf-provider-github-datagithubrepositorypages)</code>

#### resetDescription() <a id="cdktf-provider-github-datagithubrepository-resetdescription"></a>



```ts
resetDescription(): void
```





#### resetFullName() <a id="cdktf-provider-github-datagithubrepository-resetfullname"></a>



```ts
resetFullName(): void
```





#### resetHomepageUrl() <a id="cdktf-provider-github-datagithubrepository-resethomepageurl"></a>



```ts
resetHomepageUrl(): void
```





#### resetName() <a id="cdktf-provider-github-datagithubrepository-resetname"></a>



```ts
resetName(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-datagithubrepository-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class DataGithubRepositoryBranches  <a id="cdktf-provider-github-datagithubrepositorybranches"></a>



__Extends__: [ComplexComputedList](#cdktf-complexcomputedlist)

### Initializer




```ts
new DataGithubRepositoryBranches(terraformResource: ITerraformResource, terraformAttribute: string, complexComputedListIndex: string)
```

* **terraformResource** (<code>[ITerraformResource](#cdktf-iterraformresource)</code>)  *No description*
* **terraformAttribute** (<code>string</code>)  *No description*
* **complexComputedListIndex** (<code>string</code>)  *No description*



### Properties


Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | <span></span>
**protected** | <code>any</code> | <span></span>



## class DataGithubRepositoryFile  <a id="cdktf-provider-github-datagithubrepositoryfile"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/d/repository_file.html github_repository_file}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformDataSource](#cdktf-terraformdatasource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/d/repository_file.html github_repository_file} Data Source.

```ts
new DataGithubRepositoryFile(scope: Construct, id: string, config: DataGithubRepositoryFileConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[DataGithubRepositoryFileConfig](#cdktf-provider-github-datagithubrepositoryfileconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **file** (<code>string</code>)  The file path to manage. 
  * **repository** (<code>string</code>)  The repository name. 
  * **branch** (<code>string</code>)  The branch name, defaults to "main". __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**branch** | <code>string</code> | <span></span>
**commitAuthor** | <code>string</code> | <span></span>
**commitEmail** | <code>string</code> | <span></span>
**commitMessage** | <code>string</code> | <span></span>
**commitSha** | <code>string</code> | <span></span>
**content** | <code>string</code> | <span></span>
**file** | <code>string</code> | <span></span>
**fileInput** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**repository** | <code>string</code> | <span></span>
**repositoryInput** | <code>string</code> | <span></span>
**sha** | <code>string</code> | <span></span>
**branchInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetBranch() <a id="cdktf-provider-github-datagithubrepositoryfile-resetbranch"></a>



```ts
resetBranch(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-datagithubrepositoryfile-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class DataGithubRepositoryMilestone  <a id="cdktf-provider-github-datagithubrepositorymilestone"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/d/repository_milestone.html github_repository_milestone}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformDataSource](#cdktf-terraformdatasource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/d/repository_milestone.html github_repository_milestone} Data Source.

```ts
new DataGithubRepositoryMilestone(scope: Construct, id: string, config: DataGithubRepositoryMilestoneConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[DataGithubRepositoryMilestoneConfig](#cdktf-provider-github-datagithubrepositorymilestoneconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **number** (<code>number</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_milestone.html#number DataGithubRepositoryMilestone#number}. 
  * **owner** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_milestone.html#owner DataGithubRepositoryMilestone#owner}. 
  * **repository** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_milestone.html#repository DataGithubRepositoryMilestone#repository}. 



### Properties


Name | Type | Description 
-----|------|-------------
**description** | <code>string</code> | <span></span>
**dueDate** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**number** | <code>number</code> | <span></span>
**numberInput** | <code>number</code> | <span></span>
**owner** | <code>string</code> | <span></span>
**ownerInput** | <code>string</code> | <span></span>
**repository** | <code>string</code> | <span></span>
**repositoryInput** | <code>string</code> | <span></span>
**state** | <code>string</code> | <span></span>
**title** | <code>string</code> | <span></span>
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### protected synthesizeAttributes() <a id="cdktf-provider-github-datagithubrepositorymilestone-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class DataGithubRepositoryPages  <a id="cdktf-provider-github-datagithubrepositorypages"></a>



__Extends__: [ComplexComputedList](#cdktf-complexcomputedlist)

### Initializer




```ts
new DataGithubRepositoryPages(terraformResource: ITerraformResource, terraformAttribute: string, complexComputedListIndex: string)
```

* **terraformResource** (<code>[ITerraformResource](#cdktf-iterraformresource)</code>)  *No description*
* **terraformAttribute** (<code>string</code>)  *No description*
* **complexComputedListIndex** (<code>string</code>)  *No description*



### Properties


Name | Type | Description 
-----|------|-------------
**cname** | <code>string</code> | <span></span>
**custom404** | <code>any</code> | <span></span>
**htmlUrl** | <code>string</code> | <span></span>
**source** | <code>any</code> | <span></span>
**status** | <code>string</code> | <span></span>
**url** | <code>string</code> | <span></span>



## class DataGithubRepositoryPagesSource  <a id="cdktf-provider-github-datagithubrepositorypagessource"></a>



__Extends__: [ComplexComputedList](#cdktf-complexcomputedlist)

### Initializer




```ts
new DataGithubRepositoryPagesSource(terraformResource: ITerraformResource, terraformAttribute: string, complexComputedListIndex: string)
```

* **terraformResource** (<code>[ITerraformResource](#cdktf-iterraformresource)</code>)  *No description*
* **terraformAttribute** (<code>string</code>)  *No description*
* **complexComputedListIndex** (<code>string</code>)  *No description*



### Properties


Name | Type | Description 
-----|------|-------------
**branch** | <code>string</code> | <span></span>
**path** | <code>string</code> | <span></span>



## class DataGithubRepositoryPullRequest  <a id="cdktf-provider-github-datagithubrepositorypullrequest"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/d/repository_pull_request.html github_repository_pull_request}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformDataSource](#cdktf-terraformdatasource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/d/repository_pull_request.html github_repository_pull_request} Data Source.

```ts
new DataGithubRepositoryPullRequest(scope: Construct, id: string, config: DataGithubRepositoryPullRequestConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[DataGithubRepositoryPullRequestConfig](#cdktf-provider-github-datagithubrepositorypullrequestconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **baseRepository** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_request.html#base_repository DataGithubRepositoryPullRequest#base_repository}. 
  * **number** (<code>number</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_request.html#number DataGithubRepositoryPullRequest#number}. 
  * **owner** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_request.html#owner DataGithubRepositoryPullRequest#owner}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**baseRef** | <code>string</code> | <span></span>
**baseRepository** | <code>string</code> | <span></span>
**baseRepositoryInput** | <code>string</code> | <span></span>
**baseSha** | <code>string</code> | <span></span>
**body** | <code>string</code> | <span></span>
**draft** | <code>[IResolvable](#cdktf-iresolvable)</code> | <span></span>
**headOwner** | <code>string</code> | <span></span>
**headRef** | <code>string</code> | <span></span>
**headRepository** | <code>string</code> | <span></span>
**headSha** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**labels** | <code>Array<string></code> | <span></span>
**maintainerCanModify** | <code>[IResolvable](#cdktf-iresolvable)</code> | <span></span>
**number** | <code>number</code> | <span></span>
**numberInput** | <code>number</code> | <span></span>
**openedAt** | <code>number</code> | <span></span>
**openedBy** | <code>string</code> | <span></span>
**owner** | <code>string</code> | <span></span>
**state** | <code>string</code> | <span></span>
**title** | <code>string</code> | <span></span>
**updatedAt** | <code>number</code> | <span></span>
**ownerInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetOwner() <a id="cdktf-provider-github-datagithubrepositorypullrequest-resetowner"></a>



```ts
resetOwner(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-datagithubrepositorypullrequest-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class DataGithubRepositoryPullRequests  <a id="cdktf-provider-github-datagithubrepositorypullrequests"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html github_repository_pull_requests}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformDataSource](#cdktf-terraformdatasource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html github_repository_pull_requests} Data Source.

```ts
new DataGithubRepositoryPullRequests(scope: Construct, id: string, config: DataGithubRepositoryPullRequestsConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[DataGithubRepositoryPullRequestsConfig](#cdktf-provider-github-datagithubrepositorypullrequestsconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **baseRepository** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html#base_repository DataGithubRepositoryPullRequests#base_repository}. 
  * **baseRef** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html#base_ref DataGithubRepositoryPullRequests#base_ref}. __*Optional*__
  * **headRef** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html#head_ref DataGithubRepositoryPullRequests#head_ref}. __*Optional*__
  * **owner** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html#owner DataGithubRepositoryPullRequests#owner}. __*Optional*__
  * **sortBy** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html#sort_by DataGithubRepositoryPullRequests#sort_by}. __*Optional*__
  * **sortDirection** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html#sort_direction DataGithubRepositoryPullRequests#sort_direction}. __*Optional*__
  * **state** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html#state DataGithubRepositoryPullRequests#state}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**baseRef** | <code>string</code> | <span></span>
**baseRepository** | <code>string</code> | <span></span>
**baseRepositoryInput** | <code>string</code> | <span></span>
**headRef** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**owner** | <code>string</code> | <span></span>
**sortBy** | <code>string</code> | <span></span>
**sortDirection** | <code>string</code> | <span></span>
**state** | <code>string</code> | <span></span>
**baseRefInput**? | <code>string</code> | __*Optional*__
**headRefInput**? | <code>string</code> | __*Optional*__
**ownerInput**? | <code>string</code> | __*Optional*__
**sortByInput**? | <code>string</code> | __*Optional*__
**sortDirectionInput**? | <code>string</code> | __*Optional*__
**stateInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetBaseRef() <a id="cdktf-provider-github-datagithubrepositorypullrequests-resetbaseref"></a>



```ts
resetBaseRef(): void
```





#### resetHeadRef() <a id="cdktf-provider-github-datagithubrepositorypullrequests-resetheadref"></a>



```ts
resetHeadRef(): void
```





#### resetOwner() <a id="cdktf-provider-github-datagithubrepositorypullrequests-resetowner"></a>



```ts
resetOwner(): void
```





#### resetSortBy() <a id="cdktf-provider-github-datagithubrepositorypullrequests-resetsortby"></a>



```ts
resetSortBy(): void
```





#### resetSortDirection() <a id="cdktf-provider-github-datagithubrepositorypullrequests-resetsortdirection"></a>



```ts
resetSortDirection(): void
```





#### resetState() <a id="cdktf-provider-github-datagithubrepositorypullrequests-resetstate"></a>



```ts
resetState(): void
```





#### results(index) <a id="cdktf-provider-github-datagithubrepositorypullrequests-results"></a>



```ts
results(index: string): DataGithubRepositoryPullRequestsResults
```

* **index** (<code>string</code>)  *No description*

__Returns__:
* <code>[DataGithubRepositoryPullRequestsResults](#cdktf-provider-github-datagithubrepositorypullrequestsresults)</code>

#### protected synthesizeAttributes() <a id="cdktf-provider-github-datagithubrepositorypullrequests-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class DataGithubRepositoryPullRequestsResults  <a id="cdktf-provider-github-datagithubrepositorypullrequestsresults"></a>



__Extends__: [ComplexComputedList](#cdktf-complexcomputedlist)

### Initializer




```ts
new DataGithubRepositoryPullRequestsResults(terraformResource: ITerraformResource, terraformAttribute: string, complexComputedListIndex: string)
```

* **terraformResource** (<code>[ITerraformResource](#cdktf-iterraformresource)</code>)  *No description*
* **terraformAttribute** (<code>string</code>)  *No description*
* **complexComputedListIndex** (<code>string</code>)  *No description*



### Properties


Name | Type | Description 
-----|------|-------------
**baseRef** | <code>string</code> | <span></span>
**baseSha** | <code>string</code> | <span></span>
**body** | <code>string</code> | <span></span>
**draft** | <code>any</code> | <span></span>
**headOwner** | <code>string</code> | <span></span>
**headRef** | <code>string</code> | <span></span>
**headRepository** | <code>string</code> | <span></span>
**headSha** | <code>string</code> | <span></span>
**labels** | <code>Array<string></code> | <span></span>
**maintainerCanModify** | <code>any</code> | <span></span>
**number** | <code>number</code> | <span></span>
**openedAt** | <code>number</code> | <span></span>
**openedBy** | <code>string</code> | <span></span>
**state** | <code>string</code> | <span></span>
**title** | <code>string</code> | <span></span>
**updatedAt** | <code>number</code> | <span></span>



## class DataGithubTeam  <a id="cdktf-provider-github-datagithubteam"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/d/team.html github_team}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformDataSource](#cdktf-terraformdatasource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/d/team.html github_team} Data Source.

```ts
new DataGithubTeam(scope: Construct, id: string, config: DataGithubTeamConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[DataGithubTeamConfig](#cdktf-provider-github-datagithubteamconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **slug** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/team.html#slug DataGithubTeam#slug}. 



### Properties


Name | Type | Description 
-----|------|-------------
**description** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**members** | <code>Array<string></code> | <span></span>
**name** | <code>string</code> | <span></span>
**nodeId** | <code>string</code> | <span></span>
**permission** | <code>string</code> | <span></span>
**privacy** | <code>string</code> | <span></span>
**repositories** | <code>Array<string></code> | <span></span>
**slug** | <code>string</code> | <span></span>
**slugInput** | <code>string</code> | <span></span>
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### protected synthesizeAttributes() <a id="cdktf-provider-github-datagithubteam-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class DataGithubUser  <a id="cdktf-provider-github-datagithubuser"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/d/user.html github_user}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformDataSource](#cdktf-terraformdatasource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/d/user.html github_user} Data Source.

```ts
new DataGithubUser(scope: Construct, id: string, config: DataGithubUserConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[DataGithubUserConfig](#cdktf-provider-github-datagithubuserconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **username** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/user.html#username DataGithubUser#username}. 



### Properties


Name | Type | Description 
-----|------|-------------
**avatarUrl** | <code>string</code> | <span></span>
**bio** | <code>string</code> | <span></span>
**blog** | <code>string</code> | <span></span>
**company** | <code>string</code> | <span></span>
**createdAt** | <code>string</code> | <span></span>
**email** | <code>string</code> | <span></span>
**followers** | <code>number</code> | <span></span>
**following** | <code>number</code> | <span></span>
**gpgKeys** | <code>Array<string></code> | <span></span>
**gravatarId** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**location** | <code>string</code> | <span></span>
**login** | <code>string</code> | <span></span>
**name** | <code>string</code> | <span></span>
**nodeId** | <code>string</code> | <span></span>
**publicGists** | <code>number</code> | <span></span>
**publicRepos** | <code>number</code> | <span></span>
**siteAdmin** | <code>[IResolvable](#cdktf-iresolvable)</code> | <span></span>
**sshKeys** | <code>Array<string></code> | <span></span>
**updatedAt** | <code>string</code> | <span></span>
**username** | <code>string</code> | <span></span>
**usernameInput** | <code>string</code> | <span></span>
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### protected synthesizeAttributes() <a id="cdktf-provider-github-datagithubuser-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class GithubProvider  <a id="cdktf-provider-github-githubprovider"></a>

Represents a {@link https://www.terraform.io/docs/providers/github github}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Extends__: [TerraformProvider](#cdktf-terraformprovider)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github github} Resource.

```ts
new GithubProvider(scope: Construct, id: string, config?: GithubProviderConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[GithubProviderConfig](#cdktf-provider-github-githubproviderconfig)</code>)  *No description*
  * **alias** (<code>string</code>)  Alias name. __*Optional*__
  * **appAuth** (<code>Array<[GithubProviderAppAuth](#cdktf-provider-github-githubproviderappauth)></code>)  app_auth block. __*Optional*__
  * **baseUrl** (<code>string</code>)  The GitHub Base API URL. __*Optional*__
  * **insecure** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Enable `insecure` mode for testing purposes. __*Optional*__
  * **organization** (<code>string</code>)  The GitHub organization name to manage. Use this field instead of `owner` when managing organization accounts. __*Optional*__
  * **owner** (<code>string</code>)  The GitHub owner name to manage. Use this field instead of `organization` when managing individual accounts. __*Optional*__
  * **token** (<code>string</code>)  The OAuth token used to connect to GitHub. __*Optional*__
  * **writeDelayMs** (<code>number</code>)  Amount of time in milliseconds to sleep in between writes to GitHub API. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**alias**? | <code>string</code> | __*Optional*__
**aliasInput**? | <code>string</code> | __*Optional*__
**appAuth**? | <code>Array<[GithubProviderAppAuth](#cdktf-provider-github-githubproviderappauth)></code> | __*Optional*__
**appAuthInput**? | <code>Array<[GithubProviderAppAuth](#cdktf-provider-github-githubproviderappauth)></code> | __*Optional*__
**baseUrl**? | <code>string</code> | __*Optional*__
**baseUrlInput**? | <code>string</code> | __*Optional*__
**insecure**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**insecureInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**organization**? | <code>string</code> | __*Optional*__
**organizationInput**? | <code>string</code> | __*Optional*__
**owner**? | <code>string</code> | __*Optional*__
**ownerInput**? | <code>string</code> | __*Optional*__
**token**? | <code>string</code> | __*Optional*__
**tokenInput**? | <code>string</code> | __*Optional*__
**writeDelayMs**? | <code>number</code> | __*Optional*__
**writeDelayMsInput**? | <code>number</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetAlias() <a id="cdktf-provider-github-githubprovider-resetalias"></a>



```ts
resetAlias(): void
```





#### resetAppAuth() <a id="cdktf-provider-github-githubprovider-resetappauth"></a>



```ts
resetAppAuth(): void
```





#### resetBaseUrl() <a id="cdktf-provider-github-githubprovider-resetbaseurl"></a>



```ts
resetBaseUrl(): void
```





#### resetInsecure() <a id="cdktf-provider-github-githubprovider-resetinsecure"></a>



```ts
resetInsecure(): void
```





#### resetOrganization() <a id="cdktf-provider-github-githubprovider-resetorganization"></a>



```ts
resetOrganization(): void
```





#### resetOwner() <a id="cdktf-provider-github-githubprovider-resetowner"></a>



```ts
resetOwner(): void
```





#### resetToken() <a id="cdktf-provider-github-githubprovider-resettoken"></a>



```ts
resetToken(): void
```





#### resetWriteDelayMs() <a id="cdktf-provider-github-githubprovider-resetwritedelayms"></a>



```ts
resetWriteDelayMs(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-githubprovider-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class IssueLabel  <a id="cdktf-provider-github-issuelabel"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/issue_label.html github_issue_label}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/issue_label.html github_issue_label} Resource.

```ts
new IssueLabel(scope: Construct, id: string, config: IssueLabelConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[IssueLabelConfig](#cdktf-provider-github-issuelabelconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **color** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/issue_label.html#color IssueLabel#color}. 
  * **name** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/issue_label.html#name IssueLabel#name}. 
  * **repository** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/issue_label.html#repository IssueLabel#repository}. 
  * **description** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/issue_label.html#description IssueLabel#description}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**color** | <code>string</code> | <span></span>
**colorInput** | <code>string</code> | <span></span>
**description** | <code>string</code> | <span></span>
**etag** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**name** | <code>string</code> | <span></span>
**nameInput** | <code>string</code> | <span></span>
**repository** | <code>string</code> | <span></span>
**repositoryInput** | <code>string</code> | <span></span>
**url** | <code>string</code> | <span></span>
**descriptionInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetDescription() <a id="cdktf-provider-github-issuelabel-resetdescription"></a>



```ts
resetDescription(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-issuelabel-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class Membership  <a id="cdktf-provider-github-membership"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/membership.html github_membership}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/membership.html github_membership} Resource.

```ts
new Membership(scope: Construct, id: string, config: MembershipConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[MembershipConfig](#cdktf-provider-github-membershipconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **username** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/membership.html#username Membership#username}. 
  * **role** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/membership.html#role Membership#role}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**etag** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**role** | <code>string</code> | <span></span>
**username** | <code>string</code> | <span></span>
**usernameInput** | <code>string</code> | <span></span>
**roleInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetRole() <a id="cdktf-provider-github-membership-resetrole"></a>



```ts
resetRole(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-membership-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class OrganizationBlock  <a id="cdktf-provider-github-organizationblock"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/organization_block.html github_organization_block}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/organization_block.html github_organization_block} Resource.

```ts
new OrganizationBlock(scope: Construct, id: string, config: OrganizationBlockConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[OrganizationBlockConfig](#cdktf-provider-github-organizationblockconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **username** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_block.html#username OrganizationBlock#username}. 



### Properties


Name | Type | Description 
-----|------|-------------
**etag** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**username** | <code>string</code> | <span></span>
**usernameInput** | <code>string</code> | <span></span>
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### protected synthesizeAttributes() <a id="cdktf-provider-github-organizationblock-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class OrganizationProject  <a id="cdktf-provider-github-organizationproject"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/organization_project.html github_organization_project}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/organization_project.html github_organization_project} Resource.

```ts
new OrganizationProject(scope: Construct, id: string, config: OrganizationProjectConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[OrganizationProjectConfig](#cdktf-provider-github-organizationprojectconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **name** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_project.html#name OrganizationProject#name}. 
  * **body** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_project.html#body OrganizationProject#body}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**body** | <code>string</code> | <span></span>
**etag** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**name** | <code>string</code> | <span></span>
**nameInput** | <code>string</code> | <span></span>
**url** | <code>string</code> | <span></span>
**bodyInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetBody() <a id="cdktf-provider-github-organizationproject-resetbody"></a>



```ts
resetBody(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-organizationproject-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class OrganizationWebhook  <a id="cdktf-provider-github-organizationwebhook"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html github_organization_webhook}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html github_organization_webhook} Resource.

```ts
new OrganizationWebhook(scope: Construct, id: string, config: OrganizationWebhookConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[OrganizationWebhookConfig](#cdktf-provider-github-organizationwebhookconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **events** (<code>Array<string></code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html#events OrganizationWebhook#events}. 
  * **active** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html#active OrganizationWebhook#active}. __*Optional*__
  * **configuration** (<code>Array<[OrganizationWebhookConfiguration](#cdktf-provider-github-organizationwebhookconfiguration)></code>)  configuration block. __*Optional*__
  * **name** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html#name OrganizationWebhook#name}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**active** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**configuration** | <code>Array<[OrganizationWebhookConfiguration](#cdktf-provider-github-organizationwebhookconfiguration)></code> | <span></span>
**etag** | <code>string</code> | <span></span>
**events** | <code>Array<string></code> | <span></span>
**eventsInput** | <code>Array<string></code> | <span></span>
**id** | <code>string</code> | <span></span>
**name** | <code>string</code> | <span></span>
**url** | <code>string</code> | <span></span>
**activeInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**configurationInput**? | <code>Array<[OrganizationWebhookConfiguration](#cdktf-provider-github-organizationwebhookconfiguration)></code> | __*Optional*__
**nameInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetActive() <a id="cdktf-provider-github-organizationwebhook-resetactive"></a>



```ts
resetActive(): void
```





#### resetConfiguration() <a id="cdktf-provider-github-organizationwebhook-resetconfiguration"></a>



```ts
resetConfiguration(): void
```





#### resetName() <a id="cdktf-provider-github-organizationwebhook-resetname"></a>



```ts
resetName(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-organizationwebhook-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class ProjectCard  <a id="cdktf-provider-github-projectcard"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/project_card.html github_project_card}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/project_card.html github_project_card} Resource.

```ts
new ProjectCard(scope: Construct, id: string, config: ProjectCardConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[ProjectCardConfig](#cdktf-provider-github-projectcardconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **columnId** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/project_card.html#column_id ProjectCard#column_id}. 
  * **note** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/project_card.html#note ProjectCard#note}. 



### Properties


Name | Type | Description 
-----|------|-------------
**cardId** | <code>number</code> | <span></span>
**columnId** | <code>string</code> | <span></span>
**columnIdInput** | <code>string</code> | <span></span>
**etag** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**note** | <code>string</code> | <span></span>
**noteInput** | <code>string</code> | <span></span>
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### protected synthesizeAttributes() <a id="cdktf-provider-github-projectcard-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class ProjectColumn  <a id="cdktf-provider-github-projectcolumn"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/project_column.html github_project_column}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/project_column.html github_project_column} Resource.

```ts
new ProjectColumn(scope: Construct, id: string, config: ProjectColumnConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[ProjectColumnConfig](#cdktf-provider-github-projectcolumnconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **name** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/project_column.html#name ProjectColumn#name}. 
  * **projectId** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/project_column.html#project_id ProjectColumn#project_id}. 



### Properties


Name | Type | Description 
-----|------|-------------
**columnId** | <code>number</code> | <span></span>
**etag** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**name** | <code>string</code> | <span></span>
**nameInput** | <code>string</code> | <span></span>
**projectId** | <code>string</code> | <span></span>
**projectIdInput** | <code>string</code> | <span></span>
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### protected synthesizeAttributes() <a id="cdktf-provider-github-projectcolumn-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class Repository  <a id="cdktf-provider-github-repository"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/repository.html github_repository}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/repository.html github_repository} Resource.

```ts
new Repository(scope: Construct, id: string, config: RepositoryConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[RepositoryConfig](#cdktf-provider-github-repositoryconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **name** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#name Repository#name}. 
  * **allowMergeCommit** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#allow_merge_commit Repository#allow_merge_commit}. __*Optional*__
  * **allowRebaseMerge** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#allow_rebase_merge Repository#allow_rebase_merge}. __*Optional*__
  * **allowSquashMerge** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#allow_squash_merge Repository#allow_squash_merge}. __*Optional*__
  * **archived** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#archived Repository#archived}. __*Optional*__
  * **archiveOnDestroy** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#archive_on_destroy Repository#archive_on_destroy}. __*Optional*__
  * **autoInit** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#auto_init Repository#auto_init}. __*Optional*__
  * **defaultBranch** (<code>string</code>)  Can only be set after initial repository creation, and only if the target branch exists. __*Optional*__
  * **deleteBranchOnMerge** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#delete_branch_on_merge Repository#delete_branch_on_merge}. __*Optional*__
  * **description** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#description Repository#description}. __*Optional*__
  * **gitignoreTemplate** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#gitignore_template Repository#gitignore_template}. __*Optional*__
  * **hasDownloads** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#has_downloads Repository#has_downloads}. __*Optional*__
  * **hasIssues** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#has_issues Repository#has_issues}. __*Optional*__
  * **hasProjects** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#has_projects Repository#has_projects}. __*Optional*__
  * **hasWiki** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#has_wiki Repository#has_wiki}. __*Optional*__
  * **homepageUrl** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#homepage_url Repository#homepage_url}. __*Optional*__
  * **isTemplate** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#is_template Repository#is_template}. __*Optional*__
  * **licenseTemplate** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#license_template Repository#license_template}. __*Optional*__
  * **pages** (<code>Array<[RepositoryPages](#cdktf-provider-github-repositorypages)></code>)  pages block. __*Optional*__
  * **private** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#private Repository#private}. __*Optional*__
  * **template** (<code>Array<[RepositoryTemplate](#cdktf-provider-github-repositorytemplate)></code>)  template block. __*Optional*__
  * **topics** (<code>Array<string></code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#topics Repository#topics}. __*Optional*__
  * **visibility** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#visibility Repository#visibility}. __*Optional*__
  * **vulnerabilityAlerts** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#vulnerability_alerts Repository#vulnerability_alerts}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**allowMergeCommit** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**allowRebaseMerge** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**allowSquashMerge** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**archiveOnDestroy** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**archived** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**autoInit** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**defaultBranch** | <code>string</code> | <span></span>
**deleteBranchOnMerge** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**description** | <code>string</code> | <span></span>
**etag** | <code>string</code> | <span></span>
**fullName** | <code>string</code> | <span></span>
**gitCloneUrl** | <code>string</code> | <span></span>
**gitignoreTemplate** | <code>string</code> | <span></span>
**hasDownloads** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**hasIssues** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**hasProjects** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**hasWiki** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**homepageUrl** | <code>string</code> | <span></span>
**htmlUrl** | <code>string</code> | <span></span>
**httpCloneUrl** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**isTemplate** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**licenseTemplate** | <code>string</code> | <span></span>
**name** | <code>string</code> | <span></span>
**nameInput** | <code>string</code> | <span></span>
**nodeId** | <code>string</code> | <span></span>
**pages** | <code>Array<[RepositoryPages](#cdktf-provider-github-repositorypages)></code> | <span></span>
**private** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**repoId** | <code>number</code> | <span></span>
**sshCloneUrl** | <code>string</code> | <span></span>
**svnUrl** | <code>string</code> | <span></span>
**template** | <code>Array<[RepositoryTemplate](#cdktf-provider-github-repositorytemplate)></code> | <span></span>
**topics** | <code>Array<string></code> | <span></span>
**visibility** | <code>string</code> | <span></span>
**vulnerabilityAlerts** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**allowMergeCommitInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**allowRebaseMergeInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**allowSquashMergeInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**archiveOnDestroyInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**archivedInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**autoInitInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**defaultBranchInput**? | <code>string</code> | __*Optional*__
**deleteBranchOnMergeInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**descriptionInput**? | <code>string</code> | __*Optional*__
**gitignoreTemplateInput**? | <code>string</code> | __*Optional*__
**hasDownloadsInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**hasIssuesInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**hasProjectsInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**hasWikiInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**homepageUrlInput**? | <code>string</code> | __*Optional*__
**isTemplateInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**licenseTemplateInput**? | <code>string</code> | __*Optional*__
**pagesInput**? | <code>Array<[RepositoryPages](#cdktf-provider-github-repositorypages)></code> | __*Optional*__
**privateInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**templateInput**? | <code>Array<[RepositoryTemplate](#cdktf-provider-github-repositorytemplate)></code> | __*Optional*__
**topicsInput**? | <code>Array<string></code> | __*Optional*__
**visibilityInput**? | <code>string</code> | __*Optional*__
**vulnerabilityAlertsInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetAllowMergeCommit() <a id="cdktf-provider-github-repository-resetallowmergecommit"></a>



```ts
resetAllowMergeCommit(): void
```





#### resetAllowRebaseMerge() <a id="cdktf-provider-github-repository-resetallowrebasemerge"></a>



```ts
resetAllowRebaseMerge(): void
```





#### resetAllowSquashMerge() <a id="cdktf-provider-github-repository-resetallowsquashmerge"></a>



```ts
resetAllowSquashMerge(): void
```





#### resetArchiveOnDestroy() <a id="cdktf-provider-github-repository-resetarchiveondestroy"></a>



```ts
resetArchiveOnDestroy(): void
```





#### resetArchived() <a id="cdktf-provider-github-repository-resetarchived"></a>



```ts
resetArchived(): void
```





#### resetAutoInit() <a id="cdktf-provider-github-repository-resetautoinit"></a>



```ts
resetAutoInit(): void
```





#### resetDefaultBranch() <a id="cdktf-provider-github-repository-resetdefaultbranch"></a>



```ts
resetDefaultBranch(): void
```





#### resetDeleteBranchOnMerge() <a id="cdktf-provider-github-repository-resetdeletebranchonmerge"></a>



```ts
resetDeleteBranchOnMerge(): void
```





#### resetDescription() <a id="cdktf-provider-github-repository-resetdescription"></a>



```ts
resetDescription(): void
```





#### resetGitignoreTemplate() <a id="cdktf-provider-github-repository-resetgitignoretemplate"></a>



```ts
resetGitignoreTemplate(): void
```





#### resetHasDownloads() <a id="cdktf-provider-github-repository-resethasdownloads"></a>



```ts
resetHasDownloads(): void
```





#### resetHasIssues() <a id="cdktf-provider-github-repository-resethasissues"></a>



```ts
resetHasIssues(): void
```





#### resetHasProjects() <a id="cdktf-provider-github-repository-resethasprojects"></a>



```ts
resetHasProjects(): void
```





#### resetHasWiki() <a id="cdktf-provider-github-repository-resethaswiki"></a>



```ts
resetHasWiki(): void
```





#### resetHomepageUrl() <a id="cdktf-provider-github-repository-resethomepageurl"></a>



```ts
resetHomepageUrl(): void
```





#### resetIsTemplate() <a id="cdktf-provider-github-repository-resetistemplate"></a>



```ts
resetIsTemplate(): void
```





#### resetLicenseTemplate() <a id="cdktf-provider-github-repository-resetlicensetemplate"></a>



```ts
resetLicenseTemplate(): void
```





#### resetPages() <a id="cdktf-provider-github-repository-resetpages"></a>



```ts
resetPages(): void
```





#### resetPrivate() <a id="cdktf-provider-github-repository-resetprivate"></a>



```ts
resetPrivate(): void
```





#### resetTemplate() <a id="cdktf-provider-github-repository-resettemplate"></a>



```ts
resetTemplate(): void
```





#### resetTopics() <a id="cdktf-provider-github-repository-resettopics"></a>



```ts
resetTopics(): void
```





#### resetVisibility() <a id="cdktf-provider-github-repository-resetvisibility"></a>



```ts
resetVisibility(): void
```





#### resetVulnerabilityAlerts() <a id="cdktf-provider-github-repository-resetvulnerabilityalerts"></a>



```ts
resetVulnerabilityAlerts(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-repository-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class RepositoryCollaborator  <a id="cdktf-provider-github-repositorycollaborator"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_collaborator.html github_repository_collaborator}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/repository_collaborator.html github_repository_collaborator} Resource.

```ts
new RepositoryCollaborator(scope: Construct, id: string, config: RepositoryCollaboratorConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[RepositoryCollaboratorConfig](#cdktf-provider-github-repositorycollaboratorconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **repository** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_collaborator.html#repository RepositoryCollaborator#repository}. 
  * **username** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_collaborator.html#username RepositoryCollaborator#username}. 
  * **permission** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_collaborator.html#permission RepositoryCollaborator#permission}. __*Optional*__
  * **permissionDiffSuppression** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_collaborator.html#permission_diff_suppression RepositoryCollaborator#permission_diff_suppression}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**id** | <code>string</code> | <span></span>
**invitationId** | <code>string</code> | <span></span>
**permission** | <code>string</code> | <span></span>
**permissionDiffSuppression** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**repository** | <code>string</code> | <span></span>
**repositoryInput** | <code>string</code> | <span></span>
**username** | <code>string</code> | <span></span>
**usernameInput** | <code>string</code> | <span></span>
**permissionDiffSuppressionInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**permissionInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetPermission() <a id="cdktf-provider-github-repositorycollaborator-resetpermission"></a>



```ts
resetPermission(): void
```





#### resetPermissionDiffSuppression() <a id="cdktf-provider-github-repositorycollaborator-resetpermissiondiffsuppression"></a>



```ts
resetPermissionDiffSuppression(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-repositorycollaborator-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class RepositoryDeployKey  <a id="cdktf-provider-github-repositorydeploykey"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_deploy_key.html github_repository_deploy_key}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/repository_deploy_key.html github_repository_deploy_key} Resource.

```ts
new RepositoryDeployKey(scope: Construct, id: string, config: RepositoryDeployKeyConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[RepositoryDeployKeyConfig](#cdktf-provider-github-repositorydeploykeyconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **key** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_deploy_key.html#key RepositoryDeployKey#key}. 
  * **repository** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_deploy_key.html#repository RepositoryDeployKey#repository}. 
  * **title** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_deploy_key.html#title RepositoryDeployKey#title}. 
  * **readOnly** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_deploy_key.html#read_only RepositoryDeployKey#read_only}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**etag** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**key** | <code>string</code> | <span></span>
**keyInput** | <code>string</code> | <span></span>
**readOnly** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**repository** | <code>string</code> | <span></span>
**repositoryInput** | <code>string</code> | <span></span>
**title** | <code>string</code> | <span></span>
**titleInput** | <code>string</code> | <span></span>
**readOnlyInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetReadOnly() <a id="cdktf-provider-github-repositorydeploykey-resetreadonly"></a>



```ts
resetReadOnly(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-repositorydeploykey-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class RepositoryEnvironment  <a id="cdktf-provider-github-repositoryenvironment"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html github_repository_environment}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html github_repository_environment} Resource.

```ts
new RepositoryEnvironment(scope: Construct, id: string, config: RepositoryEnvironmentConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[RepositoryEnvironmentConfig](#cdktf-provider-github-repositoryenvironmentconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **environment** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html#environment RepositoryEnvironment#environment}. 
  * **repository** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html#repository RepositoryEnvironment#repository}. 
  * **deploymentBranchPolicy** (<code>Array<[RepositoryEnvironmentDeploymentBranchPolicy](#cdktf-provider-github-repositoryenvironmentdeploymentbranchpolicy)></code>)  deployment_branch_policy block. __*Optional*__
  * **reviewers** (<code>Array<[RepositoryEnvironmentReviewers](#cdktf-provider-github-repositoryenvironmentreviewers)></code>)  reviewers block. __*Optional*__
  * **waitTimer** (<code>number</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html#wait_timer RepositoryEnvironment#wait_timer}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**deploymentBranchPolicy** | <code>Array<[RepositoryEnvironmentDeploymentBranchPolicy](#cdktf-provider-github-repositoryenvironmentdeploymentbranchpolicy)></code> | <span></span>
**environment** | <code>string</code> | <span></span>
**environmentInput** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**repository** | <code>string</code> | <span></span>
**repositoryInput** | <code>string</code> | <span></span>
**reviewers** | <code>Array<[RepositoryEnvironmentReviewers](#cdktf-provider-github-repositoryenvironmentreviewers)></code> | <span></span>
**waitTimer** | <code>number</code> | <span></span>
**deploymentBranchPolicyInput**? | <code>Array<[RepositoryEnvironmentDeploymentBranchPolicy](#cdktf-provider-github-repositoryenvironmentdeploymentbranchpolicy)></code> | __*Optional*__
**reviewersInput**? | <code>Array<[RepositoryEnvironmentReviewers](#cdktf-provider-github-repositoryenvironmentreviewers)></code> | __*Optional*__
**waitTimerInput**? | <code>number</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetDeploymentBranchPolicy() <a id="cdktf-provider-github-repositoryenvironment-resetdeploymentbranchpolicy"></a>



```ts
resetDeploymentBranchPolicy(): void
```





#### resetReviewers() <a id="cdktf-provider-github-repositoryenvironment-resetreviewers"></a>



```ts
resetReviewers(): void
```





#### resetWaitTimer() <a id="cdktf-provider-github-repositoryenvironment-resetwaittimer"></a>



```ts
resetWaitTimer(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-repositoryenvironment-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class RepositoryFile  <a id="cdktf-provider-github-repositoryfile"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_file.html github_repository_file}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/repository_file.html github_repository_file} Resource.

```ts
new RepositoryFile(scope: Construct, id: string, config: RepositoryFileConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[RepositoryFileConfig](#cdktf-provider-github-repositoryfileconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **content** (<code>string</code>)  The file's content. 
  * **file** (<code>string</code>)  The file path to manage. 
  * **repository** (<code>string</code>)  The repository name. 
  * **branch** (<code>string</code>)  The branch name, defaults to "main". __*Optional*__
  * **commitAuthor** (<code>string</code>)  The commit author name, defaults to the authenticated user's name. __*Optional*__
  * **commitEmail** (<code>string</code>)  The commit author email address, defaults to the authenticated user's email address. __*Optional*__
  * **commitMessage** (<code>string</code>)  The commit message when creating or updating the file. __*Optional*__
  * **overwriteOnCreate** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Enable overwriting existing files, defaults to "false". __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**branch** | <code>string</code> | <span></span>
**commitAuthor** | <code>string</code> | <span></span>
**commitEmail** | <code>string</code> | <span></span>
**commitMessage** | <code>string</code> | <span></span>
**commitSha** | <code>string</code> | <span></span>
**content** | <code>string</code> | <span></span>
**contentInput** | <code>string</code> | <span></span>
**file** | <code>string</code> | <span></span>
**fileInput** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**overwriteOnCreate** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**repository** | <code>string</code> | <span></span>
**repositoryInput** | <code>string</code> | <span></span>
**sha** | <code>string</code> | <span></span>
**branchInput**? | <code>string</code> | __*Optional*__
**commitAuthorInput**? | <code>string</code> | __*Optional*__
**commitEmailInput**? | <code>string</code> | __*Optional*__
**commitMessageInput**? | <code>string</code> | __*Optional*__
**overwriteOnCreateInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetBranch() <a id="cdktf-provider-github-repositoryfile-resetbranch"></a>



```ts
resetBranch(): void
```





#### resetCommitAuthor() <a id="cdktf-provider-github-repositoryfile-resetcommitauthor"></a>



```ts
resetCommitAuthor(): void
```





#### resetCommitEmail() <a id="cdktf-provider-github-repositoryfile-resetcommitemail"></a>



```ts
resetCommitEmail(): void
```





#### resetCommitMessage() <a id="cdktf-provider-github-repositoryfile-resetcommitmessage"></a>



```ts
resetCommitMessage(): void
```





#### resetOverwriteOnCreate() <a id="cdktf-provider-github-repositoryfile-resetoverwriteoncreate"></a>



```ts
resetOverwriteOnCreate(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-repositoryfile-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class RepositoryMilestone  <a id="cdktf-provider-github-repositorymilestone"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_milestone.html github_repository_milestone}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/repository_milestone.html github_repository_milestone} Resource.

```ts
new RepositoryMilestone(scope: Construct, id: string, config: RepositoryMilestoneConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[RepositoryMilestoneConfig](#cdktf-provider-github-repositorymilestoneconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **owner** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_milestone.html#owner RepositoryMilestone#owner}. 
  * **repository** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_milestone.html#repository RepositoryMilestone#repository}. 
  * **title** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_milestone.html#title RepositoryMilestone#title}. 
  * **description** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_milestone.html#description RepositoryMilestone#description}. __*Optional*__
  * **dueDate** (<code>string</code>)  in yyyy-mm-dd format. __*Optional*__
  * **state** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_milestone.html#state RepositoryMilestone#state}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**description** | <code>string</code> | <span></span>
**dueDate** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**number** | <code>number</code> | <span></span>
**owner** | <code>string</code> | <span></span>
**ownerInput** | <code>string</code> | <span></span>
**repository** | <code>string</code> | <span></span>
**repositoryInput** | <code>string</code> | <span></span>
**state** | <code>string</code> | <span></span>
**title** | <code>string</code> | <span></span>
**titleInput** | <code>string</code> | <span></span>
**descriptionInput**? | <code>string</code> | __*Optional*__
**dueDateInput**? | <code>string</code> | __*Optional*__
**stateInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetDescription() <a id="cdktf-provider-github-repositorymilestone-resetdescription"></a>



```ts
resetDescription(): void
```





#### resetDueDate() <a id="cdktf-provider-github-repositorymilestone-resetduedate"></a>



```ts
resetDueDate(): void
```





#### resetState() <a id="cdktf-provider-github-repositorymilestone-resetstate"></a>



```ts
resetState(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-repositorymilestone-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class RepositoryProject  <a id="cdktf-provider-github-repositoryproject"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_project.html github_repository_project}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/repository_project.html github_repository_project} Resource.

```ts
new RepositoryProject(scope: Construct, id: string, config: RepositoryProjectConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[RepositoryProjectConfig](#cdktf-provider-github-repositoryprojectconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **name** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_project.html#name RepositoryProject#name}. 
  * **repository** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_project.html#repository RepositoryProject#repository}. 
  * **body** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_project.html#body RepositoryProject#body}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**body** | <code>string</code> | <span></span>
**etag** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**name** | <code>string</code> | <span></span>
**nameInput** | <code>string</code> | <span></span>
**repository** | <code>string</code> | <span></span>
**repositoryInput** | <code>string</code> | <span></span>
**url** | <code>string</code> | <span></span>
**bodyInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetBody() <a id="cdktf-provider-github-repositoryproject-resetbody"></a>



```ts
resetBody(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-repositoryproject-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class RepositoryPullRequest  <a id="cdktf-provider-github-repositorypullrequest"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html github_repository_pull_request}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html github_repository_pull_request} Resource.

```ts
new RepositoryPullRequest(scope: Construct, id: string, config: RepositoryPullRequestConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[RepositoryPullRequestConfig](#cdktf-provider-github-repositorypullrequestconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **baseRef** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html#base_ref RepositoryPullRequest#base_ref}. 
  * **baseRepository** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html#base_repository RepositoryPullRequest#base_repository}. 
  * **headRef** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html#head_ref RepositoryPullRequest#head_ref}. 
  * **title** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html#title RepositoryPullRequest#title}. 
  * **body** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html#body RepositoryPullRequest#body}. __*Optional*__
  * **maintainerCanModify** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html#maintainer_can_modify RepositoryPullRequest#maintainer_can_modify}. __*Optional*__
  * **owner** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html#owner RepositoryPullRequest#owner}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**baseRef** | <code>string</code> | <span></span>
**baseRefInput** | <code>string</code> | <span></span>
**baseRepository** | <code>string</code> | <span></span>
**baseRepositoryInput** | <code>string</code> | <span></span>
**baseSha** | <code>string</code> | <span></span>
**body** | <code>string</code> | <span></span>
**draft** | <code>[IResolvable](#cdktf-iresolvable)</code> | <span></span>
**headRef** | <code>string</code> | <span></span>
**headRefInput** | <code>string</code> | <span></span>
**headSha** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**labels** | <code>Array<string></code> | <span></span>
**maintainerCanModify** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**number** | <code>number</code> | <span></span>
**openedAt** | <code>number</code> | <span></span>
**openedBy** | <code>string</code> | <span></span>
**owner** | <code>string</code> | <span></span>
**state** | <code>string</code> | <span></span>
**title** | <code>string</code> | <span></span>
**titleInput** | <code>string</code> | <span></span>
**updatedAt** | <code>number</code> | <span></span>
**bodyInput**? | <code>string</code> | __*Optional*__
**maintainerCanModifyInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**ownerInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetBody() <a id="cdktf-provider-github-repositorypullrequest-resetbody"></a>



```ts
resetBody(): void
```





#### resetMaintainerCanModify() <a id="cdktf-provider-github-repositorypullrequest-resetmaintainercanmodify"></a>



```ts
resetMaintainerCanModify(): void
```





#### resetOwner() <a id="cdktf-provider-github-repositorypullrequest-resetowner"></a>



```ts
resetOwner(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-repositorypullrequest-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class RepositoryWebhook  <a id="cdktf-provider-github-repositorywebhook"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html github_repository_webhook}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html github_repository_webhook} Resource.

```ts
new RepositoryWebhook(scope: Construct, id: string, config: RepositoryWebhookConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[RepositoryWebhookConfig](#cdktf-provider-github-repositorywebhookconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **events** (<code>Array<string></code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html#events RepositoryWebhook#events}. 
  * **repository** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html#repository RepositoryWebhook#repository}. 
  * **active** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html#active RepositoryWebhook#active}. __*Optional*__
  * **configuration** (<code>Array<[RepositoryWebhookConfiguration](#cdktf-provider-github-repositorywebhookconfiguration)></code>)  configuration block. __*Optional*__
  * **name** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html#name RepositoryWebhook#name}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**active** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**configuration** | <code>Array<[RepositoryWebhookConfiguration](#cdktf-provider-github-repositorywebhookconfiguration)></code> | <span></span>
**etag** | <code>string</code> | <span></span>
**events** | <code>Array<string></code> | <span></span>
**eventsInput** | <code>Array<string></code> | <span></span>
**id** | <code>string</code> | <span></span>
**name** | <code>string</code> | <span></span>
**repository** | <code>string</code> | <span></span>
**repositoryInput** | <code>string</code> | <span></span>
**url** | <code>string</code> | <span></span>
**activeInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**configurationInput**? | <code>Array<[RepositoryWebhookConfiguration](#cdktf-provider-github-repositorywebhookconfiguration)></code> | __*Optional*__
**nameInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetActive() <a id="cdktf-provider-github-repositorywebhook-resetactive"></a>



```ts
resetActive(): void
```





#### resetConfiguration() <a id="cdktf-provider-github-repositorywebhook-resetconfiguration"></a>



```ts
resetConfiguration(): void
```





#### resetName() <a id="cdktf-provider-github-repositorywebhook-resetname"></a>



```ts
resetName(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-repositorywebhook-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class Team  <a id="cdktf-provider-github-team"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/team.html github_team}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/team.html github_team} Resource.

```ts
new Team(scope: Construct, id: string, config: TeamConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[TeamConfig](#cdktf-provider-github-teamconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **name** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team.html#name Team#name}. 
  * **createDefaultMaintainer** (<code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team.html#create_default_maintainer Team#create_default_maintainer}. __*Optional*__
  * **description** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team.html#description Team#description}. __*Optional*__
  * **ldapDn** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team.html#ldap_dn Team#ldap_dn}. __*Optional*__
  * **parentTeamId** (<code>number</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team.html#parent_team_id Team#parent_team_id}. __*Optional*__
  * **privacy** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team.html#privacy Team#privacy}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**createDefaultMaintainer** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | <span></span>
**description** | <code>string</code> | <span></span>
**etag** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**ldapDn** | <code>string</code> | <span></span>
**membersCount** | <code>number</code> | <span></span>
**name** | <code>string</code> | <span></span>
**nameInput** | <code>string</code> | <span></span>
**nodeId** | <code>string</code> | <span></span>
**parentTeamId** | <code>number</code> | <span></span>
**privacy** | <code>string</code> | <span></span>
**slug** | <code>string</code> | <span></span>
**createDefaultMaintainerInput**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | __*Optional*__
**descriptionInput**? | <code>string</code> | __*Optional*__
**ldapDnInput**? | <code>string</code> | __*Optional*__
**parentTeamIdInput**? | <code>number</code> | __*Optional*__
**privacyInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetCreateDefaultMaintainer() <a id="cdktf-provider-github-team-resetcreatedefaultmaintainer"></a>



```ts
resetCreateDefaultMaintainer(): void
```





#### resetDescription() <a id="cdktf-provider-github-team-resetdescription"></a>



```ts
resetDescription(): void
```





#### resetLdapDn() <a id="cdktf-provider-github-team-resetldapdn"></a>



```ts
resetLdapDn(): void
```





#### resetParentTeamId() <a id="cdktf-provider-github-team-resetparentteamid"></a>



```ts
resetParentTeamId(): void
```





#### resetPrivacy() <a id="cdktf-provider-github-team-resetprivacy"></a>



```ts
resetPrivacy(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-team-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class TeamMembership  <a id="cdktf-provider-github-teammembership"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/team_membership.html github_team_membership}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/team_membership.html github_team_membership} Resource.

```ts
new TeamMembership(scope: Construct, id: string, config: TeamMembershipConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[TeamMembershipConfig](#cdktf-provider-github-teammembershipconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **teamId** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_membership.html#team_id TeamMembership#team_id}. 
  * **username** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_membership.html#username TeamMembership#username}. 
  * **role** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_membership.html#role TeamMembership#role}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**etag** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**role** | <code>string</code> | <span></span>
**teamId** | <code>string</code> | <span></span>
**teamIdInput** | <code>string</code> | <span></span>
**username** | <code>string</code> | <span></span>
**usernameInput** | <code>string</code> | <span></span>
**roleInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetRole() <a id="cdktf-provider-github-teammembership-resetrole"></a>



```ts
resetRole(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-teammembership-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class TeamRepository  <a id="cdktf-provider-github-teamrepository"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/team_repository.html github_team_repository}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/team_repository.html github_team_repository} Resource.

```ts
new TeamRepository(scope: Construct, id: string, config: TeamRepositoryConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[TeamRepositoryConfig](#cdktf-provider-github-teamrepositoryconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **repository** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_repository.html#repository TeamRepository#repository}. 
  * **teamId** (<code>string</code>)  ID or slug of team. 
  * **permission** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_repository.html#permission TeamRepository#permission}. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**etag** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**permission** | <code>string</code> | <span></span>
**repository** | <code>string</code> | <span></span>
**repositoryInput** | <code>string</code> | <span></span>
**teamId** | <code>string</code> | <span></span>
**teamIdInput** | <code>string</code> | <span></span>
**permissionInput**? | <code>string</code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetPermission() <a id="cdktf-provider-github-teamrepository-resetpermission"></a>



```ts
resetPermission(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-teamrepository-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class TeamSyncGroupMapping  <a id="cdktf-provider-github-teamsyncgroupmapping"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/team_sync_group_mapping.html github_team_sync_group_mapping}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/team_sync_group_mapping.html github_team_sync_group_mapping} Resource.

```ts
new TeamSyncGroupMapping(scope: Construct, id: string, config: TeamSyncGroupMappingConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[TeamSyncGroupMappingConfig](#cdktf-provider-github-teamsyncgroupmappingconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **teamSlug** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_sync_group_mapping.html#team_slug TeamSyncGroupMapping#team_slug}. 
  * **group** (<code>Array<[TeamSyncGroupMappingGroup](#cdktf-provider-github-teamsyncgroupmappinggroup)></code>)  group block. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**etag** | <code>string</code> | <span></span>
**group** | <code>Array<[TeamSyncGroupMappingGroup](#cdktf-provider-github-teamsyncgroupmappinggroup)></code> | <span></span>
**id** | <code>string</code> | <span></span>
**teamSlug** | <code>string</code> | <span></span>
**teamSlugInput** | <code>string</code> | <span></span>
**groupInput**? | <code>Array<[TeamSyncGroupMappingGroup](#cdktf-provider-github-teamsyncgroupmappinggroup)></code> | __*Optional*__
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### resetGroup() <a id="cdktf-provider-github-teamsyncgroupmapping-resetgroup"></a>



```ts
resetGroup(): void
```





#### protected synthesizeAttributes() <a id="cdktf-provider-github-teamsyncgroupmapping-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class UserGpgKey  <a id="cdktf-provider-github-usergpgkey"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/user_gpg_key.html github_user_gpg_key}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/user_gpg_key.html github_user_gpg_key} Resource.

```ts
new UserGpgKey(scope: Construct, id: string, config: UserGpgKeyConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[UserGpgKeyConfig](#cdktf-provider-github-usergpgkeyconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **armoredPublicKey** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/user_gpg_key.html#armored_public_key UserGpgKey#armored_public_key}. 



### Properties


Name | Type | Description 
-----|------|-------------
**armoredPublicKey** | <code>string</code> | <span></span>
**armoredPublicKeyInput** | <code>string</code> | <span></span>
**etag** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**keyId** | <code>string</code> | <span></span>
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### protected synthesizeAttributes() <a id="cdktf-provider-github-usergpgkey-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class UserInvitationAccepter  <a id="cdktf-provider-github-userinvitationaccepter"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/user_invitation_accepter.html github_user_invitation_accepter}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/user_invitation_accepter.html github_user_invitation_accepter} Resource.

```ts
new UserInvitationAccepter(scope: Construct, id: string, config: UserInvitationAccepterConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[UserInvitationAccepterConfig](#cdktf-provider-github-userinvitationaccepterconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **invitationId** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/user_invitation_accepter.html#invitation_id UserInvitationAccepter#invitation_id}. 



### Properties


Name | Type | Description 
-----|------|-------------
**id** | <code>string</code> | <span></span>
**invitationId** | <code>string</code> | <span></span>
**invitationIdInput** | <code>string</code> | <span></span>
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### protected synthesizeAttributes() <a id="cdktf-provider-github-userinvitationaccepter-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## class UserSshKey  <a id="cdktf-provider-github-usersshkey"></a>

Represents a {@link https://www.terraform.io/docs/providers/github/r/user_ssh_key.html github_user_ssh_key}.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable), [ITerraformResource](#cdktf-iterraformresource), [ITerraformDependable](#cdktf-iterraformdependable)
__Extends__: [TerraformResource](#cdktf-terraformresource)

### Initializer


Create a new {@link https://www.terraform.io/docs/providers/github/r/user_ssh_key.html github_user_ssh_key} Resource.

```ts
new UserSshKey(scope: Construct, id: string, config: UserSshKeyConfig)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  The scope in which to define this construct.
* **id** (<code>string</code>)  The scoped construct ID.
* **config** (<code>[UserSshKeyConfig](#cdktf-provider-github-usersshkeyconfig)</code>)  *No description*
  * **count** (<code>number</code>)  *No description* __*Optional*__
  * **dependsOn** (<code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code>)  *No description* __*Optional*__
  * **lifecycle** (<code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code>)  *No description* __*Optional*__
  * **provider** (<code>[TerraformProvider](#cdktf-terraformprovider)</code>)  *No description* __*Optional*__
  * **key** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/user_ssh_key.html#key UserSshKey#key}. 
  * **title** (<code>string</code>)  Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/user_ssh_key.html#title UserSshKey#title}. 



### Properties


Name | Type | Description 
-----|------|-------------
**etag** | <code>string</code> | <span></span>
**id** | <code>string</code> | <span></span>
**key** | <code>string</code> | <span></span>
**keyInput** | <code>string</code> | <span></span>
**title** | <code>string</code> | <span></span>
**titleInput** | <code>string</code> | <span></span>
**url** | <code>string</code> | <span></span>
*static* **tfResourceType** | <code>string</code> | <span></span>

### Methods


#### protected synthesizeAttributes() <a id="cdktf-provider-github-usersshkey-synthesizeattributes"></a>



```ts
protected synthesizeAttributes(): Map<string, any>
```


__Returns__:
* <code>Map<string, any></code>



## struct ActionsEnvironmentSecretConfig  <a id="cdktf-provider-github-actionsenvironmentsecretconfig"></a>






Name | Type | Description 
-----|------|-------------
**environment** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_environment_secret.html#environment ActionsEnvironmentSecret#environment}.
**repository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_environment_secret.html#repository ActionsEnvironmentSecret#repository}.
**secretName** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_environment_secret.html#secret_name ActionsEnvironmentSecret#secret_name}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**encryptedValue**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_environment_secret.html#encrypted_value ActionsEnvironmentSecret#encrypted_value}.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**plaintextValue**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_environment_secret.html#plaintext_value ActionsEnvironmentSecret#plaintext_value}.<br/>__*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct ActionsOrganizationSecretConfig  <a id="cdktf-provider-github-actionsorganizationsecretconfig"></a>






Name | Type | Description 
-----|------|-------------
**secretName** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret.html#secret_name ActionsOrganizationSecret#secret_name}.
**visibility** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret.html#visibility ActionsOrganizationSecret#visibility}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**encryptedValue**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret.html#encrypted_value ActionsOrganizationSecret#encrypted_value}.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**plaintextValue**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret.html#plaintext_value ActionsOrganizationSecret#plaintext_value}.<br/>__*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__
**selectedRepositoryIds**? | <code>Array<number></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret.html#selected_repository_ids ActionsOrganizationSecret#selected_repository_ids}.<br/>__*Optional*__



## struct ActionsOrganizationSecretRepositoriesConfig  <a id="cdktf-provider-github-actionsorganizationsecretrepositoriesconfig"></a>






Name | Type | Description 
-----|------|-------------
**secretName** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret_repositories.html#secret_name ActionsOrganizationSecretRepositories#secret_name}.
**selectedRepositoryIds** | <code>Array<number></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_organization_secret_repositories.html#selected_repository_ids ActionsOrganizationSecretRepositories#selected_repository_ids}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct ActionsRunnerGroupConfig  <a id="cdktf-provider-github-actionsrunnergroupconfig"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_runner_group.html#name ActionsRunnerGroup#name}.
**visibility** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_runner_group.html#visibility ActionsRunnerGroup#visibility}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__
**selectedRepositoryIds**? | <code>Array<number></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_runner_group.html#selected_repository_ids ActionsRunnerGroup#selected_repository_ids}.<br/>__*Optional*__



## struct ActionsSecretConfig  <a id="cdktf-provider-github-actionssecretconfig"></a>






Name | Type | Description 
-----|------|-------------
**repository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_secret.html#repository ActionsSecret#repository}.
**secretName** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_secret.html#secret_name ActionsSecret#secret_name}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**encryptedValue**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_secret.html#encrypted_value ActionsSecret#encrypted_value}.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**plaintextValue**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/actions_secret.html#plaintext_value ActionsSecret#plaintext_value}.<br/>__*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct AppInstallationRepositoryConfig  <a id="cdktf-provider-github-appinstallationrepositoryconfig"></a>






Name | Type | Description 
-----|------|-------------
**installationId** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/app_installation_repository.html#installation_id AppInstallationRepository#installation_id}.
**repository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/app_installation_repository.html#repository AppInstallationRepository#repository}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct BranchConfig  <a id="cdktf-provider-github-branchconfig"></a>






Name | Type | Description 
-----|------|-------------
**branch** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch.html#branch Branch#branch}.
**repository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch.html#repository Branch#repository}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__
**sourceBranch**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch.html#source_branch Branch#source_branch}.<br/>__*Optional*__
**sourceSha**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch.html#source_sha Branch#source_sha}.<br/>__*Optional*__



## struct BranchDefaultConfig  <a id="cdktf-provider-github-branchdefaultconfig"></a>






Name | Type | Description 
-----|------|-------------
**branch** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_default.html#branch BranchDefault#branch}.
**repository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_default.html#repository BranchDefault#repository}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct BranchProtectionConfig  <a id="cdktf-provider-github-branchprotectionconfig"></a>






Name | Type | Description 
-----|------|-------------
**pattern** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#pattern BranchProtection#pattern}.
**repositoryId** | <code>string</code> | Node ID or name of repository.
**allowsDeletions**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#allows_deletions BranchProtection#allows_deletions}.<br/>__*Optional*__
**allowsForcePushes**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#allows_force_pushes BranchProtection#allows_force_pushes}.<br/>__*Optional*__
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**enforceAdmins**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#enforce_admins BranchProtection#enforce_admins}.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__
**pushRestrictions**? | <code>Array<string></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#push_restrictions BranchProtection#push_restrictions}.<br/>__*Optional*__
**requireSignedCommits**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#require_signed_commits BranchProtection#require_signed_commits}.<br/>__*Optional*__
**requiredLinearHistory**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#required_linear_history BranchProtection#required_linear_history}.<br/>__*Optional*__
**requiredPullRequestReviews**? | <code>Array<[BranchProtectionRequiredPullRequestReviews](#cdktf-provider-github-branchprotectionrequiredpullrequestreviews)></code> | required_pull_request_reviews block.<br/>__*Optional*__
**requiredStatusChecks**? | <code>Array<[BranchProtectionRequiredStatusChecks](#cdktf-provider-github-branchprotectionrequiredstatuschecks)></code> | required_status_checks block.<br/>__*Optional*__



## struct BranchProtectionRequiredPullRequestReviews  <a id="cdktf-provider-github-branchprotectionrequiredpullrequestreviews"></a>






Name | Type | Description 
-----|------|-------------
**dismissStaleReviews**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#dismiss_stale_reviews BranchProtection#dismiss_stale_reviews}.<br/>__*Optional*__
**dismissalRestrictions**? | <code>Array<string></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#dismissal_restrictions BranchProtection#dismissal_restrictions}.<br/>__*Optional*__
**requireCodeOwnerReviews**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#require_code_owner_reviews BranchProtection#require_code_owner_reviews}.<br/>__*Optional*__
**requiredApprovingReviewCount**? | <code>number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#required_approving_review_count BranchProtection#required_approving_review_count}.<br/>__*Optional*__
**restrictDismissals**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#restrict_dismissals BranchProtection#restrict_dismissals}.<br/>__*Optional*__



## struct BranchProtectionRequiredStatusChecks  <a id="cdktf-provider-github-branchprotectionrequiredstatuschecks"></a>






Name | Type | Description 
-----|------|-------------
**contexts**? | <code>Array<string></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#contexts BranchProtection#contexts}.<br/>__*Optional*__
**strict**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#strict BranchProtection#strict}.<br/>__*Optional*__



## struct BranchProtectionV3Config  <a id="cdktf-provider-github-branchprotectionv3config"></a>






Name | Type | Description 
-----|------|-------------
**branch** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#branch BranchProtectionV3#branch}.
**repository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#repository BranchProtectionV3#repository}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**enforceAdmins**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#enforce_admins BranchProtectionV3#enforce_admins}.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__
**requireSignedCommits**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#require_signed_commits BranchProtectionV3#require_signed_commits}.<br/>__*Optional*__
**requiredPullRequestReviews**? | <code>Array<[BranchProtectionV3RequiredPullRequestReviews](#cdktf-provider-github-branchprotectionv3requiredpullrequestreviews)></code> | required_pull_request_reviews block.<br/>__*Optional*__
**requiredStatusChecks**? | <code>Array<[BranchProtectionV3RequiredStatusChecks](#cdktf-provider-github-branchprotectionv3requiredstatuschecks)></code> | required_status_checks block.<br/>__*Optional*__
**restrictions**? | <code>Array<[BranchProtectionV3Restrictions](#cdktf-provider-github-branchprotectionv3restrictions)></code> | restrictions block.<br/>__*Optional*__



## struct BranchProtectionV3RequiredPullRequestReviews  <a id="cdktf-provider-github-branchprotectionv3requiredpullrequestreviews"></a>






Name | Type | Description 
-----|------|-------------
**dismissStaleReviews**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#dismiss_stale_reviews BranchProtectionV3#dismiss_stale_reviews}.<br/>__*Optional*__
**dismissalTeams**? | <code>Array<string></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#dismissal_teams BranchProtectionV3#dismissal_teams}.<br/>__*Optional*__
**dismissalUsers**? | <code>Array<string></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#dismissal_users BranchProtectionV3#dismissal_users}.<br/>__*Optional*__
**includeAdmins**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#include_admins BranchProtectionV3#include_admins}.<br/>__*Optional*__
**requireCodeOwnerReviews**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#require_code_owner_reviews BranchProtectionV3#require_code_owner_reviews}.<br/>__*Optional*__
**requiredApprovingReviewCount**? | <code>number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#required_approving_review_count BranchProtectionV3#required_approving_review_count}.<br/>__*Optional*__



## struct BranchProtectionV3RequiredStatusChecks  <a id="cdktf-provider-github-branchprotectionv3requiredstatuschecks"></a>






Name | Type | Description 
-----|------|-------------
**contexts**? | <code>Array<string></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#contexts BranchProtectionV3#contexts}.<br/>__*Optional*__
**includeAdmins**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#include_admins BranchProtectionV3#include_admins}.<br/>__*Optional*__
**strict**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#strict BranchProtectionV3#strict}.<br/>__*Optional*__



## struct BranchProtectionV3Restrictions  <a id="cdktf-provider-github-branchprotectionv3restrictions"></a>






Name | Type | Description 
-----|------|-------------
**apps**? | <code>Array<string></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#apps BranchProtectionV3#apps}.<br/>__*Optional*__
**teams**? | <code>Array<string></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#teams BranchProtectionV3#teams}.<br/>__*Optional*__
**users**? | <code>Array<string></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#users BranchProtectionV3#users}.<br/>__*Optional*__



## struct DataGithubActionsPublicKeyConfig  <a id="cdktf-provider-github-datagithubactionspublickeyconfig"></a>






Name | Type | Description 
-----|------|-------------
**repository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/actions_public_key.html#repository DataGithubActionsPublicKey#repository}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct DataGithubBranchConfig  <a id="cdktf-provider-github-datagithubbranchconfig"></a>






Name | Type | Description 
-----|------|-------------
**branch** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/branch.html#branch DataGithubBranch#branch}.
**repository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/branch.html#repository DataGithubBranch#repository}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct DataGithubCollaboratorsConfig  <a id="cdktf-provider-github-datagithubcollaboratorsconfig"></a>






Name | Type | Description 
-----|------|-------------
**owner** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/collaborators.html#owner DataGithubCollaborators#owner}.
**repository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/collaborators.html#repository DataGithubCollaborators#repository}.
**affiliation**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/collaborators.html#affiliation DataGithubCollaborators#affiliation}.<br/>__*Optional*__
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct DataGithubIpRangesConfig  <a id="cdktf-provider-github-datagithubiprangesconfig"></a>






Name | Type | Description 
-----|------|-------------
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct DataGithubMembershipConfig  <a id="cdktf-provider-github-datagithubmembershipconfig"></a>






Name | Type | Description 
-----|------|-------------
**username** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/membership.html#username DataGithubMembership#username}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**organization**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/membership.html#organization DataGithubMembership#organization}.<br/>__*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct DataGithubOrganizationConfig  <a id="cdktf-provider-github-datagithuborganizationconfig"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/organization.html#name DataGithubOrganization#name}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct DataGithubOrganizationTeamSyncGroupsConfig  <a id="cdktf-provider-github-datagithuborganizationteamsyncgroupsconfig"></a>






Name | Type | Description 
-----|------|-------------
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct DataGithubOrganizationTeamsConfig  <a id="cdktf-provider-github-datagithuborganizationteamsconfig"></a>






Name | Type | Description 
-----|------|-------------
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__
**rootTeamsOnly**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/organization_teams.html#root_teams_only DataGithubOrganizationTeams#root_teams_only}.<br/>__*Optional*__



## struct DataGithubReleaseConfig  <a id="cdktf-provider-github-datagithubreleaseconfig"></a>






Name | Type | Description 
-----|------|-------------
**owner** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/release.html#owner DataGithubRelease#owner}.
**repository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/release.html#repository DataGithubRelease#repository}.
**retrieveBy** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/release.html#retrieve_by DataGithubRelease#retrieve_by}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__
**releaseId**? | <code>number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/release.html#release_id DataGithubRelease#release_id}.<br/>__*Optional*__
**releaseTag**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/release.html#release_tag DataGithubRelease#release_tag}.<br/>__*Optional*__



## struct DataGithubRepositoriesConfig  <a id="cdktf-provider-github-datagithubrepositoriesconfig"></a>






Name | Type | Description 
-----|------|-------------
**query** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repositories.html#query DataGithubRepositories#query}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__
**sort**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repositories.html#sort DataGithubRepositories#sort}.<br/>__*Optional*__



## struct DataGithubRepositoryConfig  <a id="cdktf-provider-github-datagithubrepositoryconfig"></a>






Name | Type | Description 
-----|------|-------------
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**description**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository.html#description DataGithubRepository#description}.<br/>__*Optional*__
**fullName**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository.html#full_name DataGithubRepository#full_name}.<br/>__*Optional*__
**homepageUrl**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository.html#homepage_url DataGithubRepository#homepage_url}.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**name**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository.html#name DataGithubRepository#name}.<br/>__*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct DataGithubRepositoryFileConfig  <a id="cdktf-provider-github-datagithubrepositoryfileconfig"></a>






Name | Type | Description 
-----|------|-------------
**file** | <code>string</code> | The file path to manage.
**repository** | <code>string</code> | The repository name.
**branch**? | <code>string</code> | The branch name, defaults to "main".<br/>__*Optional*__
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct DataGithubRepositoryMilestoneConfig  <a id="cdktf-provider-github-datagithubrepositorymilestoneconfig"></a>






Name | Type | Description 
-----|------|-------------
**number** | <code>number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_milestone.html#number DataGithubRepositoryMilestone#number}.
**owner** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_milestone.html#owner DataGithubRepositoryMilestone#owner}.
**repository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_milestone.html#repository DataGithubRepositoryMilestone#repository}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct DataGithubRepositoryPullRequestConfig  <a id="cdktf-provider-github-datagithubrepositorypullrequestconfig"></a>






Name | Type | Description 
-----|------|-------------
**baseRepository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_request.html#base_repository DataGithubRepositoryPullRequest#base_repository}.
**number** | <code>number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_request.html#number DataGithubRepositoryPullRequest#number}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**owner**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_request.html#owner DataGithubRepositoryPullRequest#owner}.<br/>__*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct DataGithubRepositoryPullRequestsConfig  <a id="cdktf-provider-github-datagithubrepositorypullrequestsconfig"></a>






Name | Type | Description 
-----|------|-------------
**baseRepository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html#base_repository DataGithubRepositoryPullRequests#base_repository}.
**baseRef**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html#base_ref DataGithubRepositoryPullRequests#base_ref}.<br/>__*Optional*__
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**headRef**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html#head_ref DataGithubRepositoryPullRequests#head_ref}.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**owner**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html#owner DataGithubRepositoryPullRequests#owner}.<br/>__*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__
**sortBy**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html#sort_by DataGithubRepositoryPullRequests#sort_by}.<br/>__*Optional*__
**sortDirection**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html#sort_direction DataGithubRepositoryPullRequests#sort_direction}.<br/>__*Optional*__
**state**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html#state DataGithubRepositoryPullRequests#state}.<br/>__*Optional*__



## struct DataGithubTeamConfig  <a id="cdktf-provider-github-datagithubteamconfig"></a>






Name | Type | Description 
-----|------|-------------
**slug** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/team.html#slug DataGithubTeam#slug}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct DataGithubUserConfig  <a id="cdktf-provider-github-datagithubuserconfig"></a>






Name | Type | Description 
-----|------|-------------
**username** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/user.html#username DataGithubUser#username}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct GithubProviderAppAuth  <a id="cdktf-provider-github-githubproviderappauth"></a>






Name | Type | Description 
-----|------|-------------
**id** | <code>string</code> | The GitHub App ID.
**installationId** | <code>string</code> | The GitHub App installation instance ID.
**pemFile** | <code>string</code> | The GitHub App PEM file contents.



## struct GithubProviderConfig  <a id="cdktf-provider-github-githubproviderconfig"></a>






Name | Type | Description 
-----|------|-------------
**alias**? | <code>string</code> | Alias name.<br/>__*Optional*__
**appAuth**? | <code>Array<[GithubProviderAppAuth](#cdktf-provider-github-githubproviderappauth)></code> | app_auth block.<br/>__*Optional*__
**baseUrl**? | <code>string</code> | The GitHub Base API URL.<br/>__*Optional*__
**insecure**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Enable `insecure` mode for testing purposes.<br/>__*Optional*__
**organization**? | <code>string</code> | The GitHub organization name to manage. Use this field instead of `owner` when managing organization accounts.<br/>__*Optional*__
**owner**? | <code>string</code> | The GitHub owner name to manage. Use this field instead of `organization` when managing individual accounts.<br/>__*Optional*__
**token**? | <code>string</code> | The OAuth token used to connect to GitHub.<br/>__*Optional*__
**writeDelayMs**? | <code>number</code> | Amount of time in milliseconds to sleep in between writes to GitHub API.<br/>__*Optional*__



## struct IssueLabelConfig  <a id="cdktf-provider-github-issuelabelconfig"></a>






Name | Type | Description 
-----|------|-------------
**color** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/issue_label.html#color IssueLabel#color}.
**name** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/issue_label.html#name IssueLabel#name}.
**repository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/issue_label.html#repository IssueLabel#repository}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**description**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/issue_label.html#description IssueLabel#description}.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct MembershipConfig  <a id="cdktf-provider-github-membershipconfig"></a>






Name | Type | Description 
-----|------|-------------
**username** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/membership.html#username Membership#username}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__
**role**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/membership.html#role Membership#role}.<br/>__*Optional*__



## struct OrganizationBlockConfig  <a id="cdktf-provider-github-organizationblockconfig"></a>






Name | Type | Description 
-----|------|-------------
**username** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_block.html#username OrganizationBlock#username}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct OrganizationProjectConfig  <a id="cdktf-provider-github-organizationprojectconfig"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_project.html#name OrganizationProject#name}.
**body**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_project.html#body OrganizationProject#body}.<br/>__*Optional*__
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct OrganizationWebhookConfig  <a id="cdktf-provider-github-organizationwebhookconfig"></a>






Name | Type | Description 
-----|------|-------------
**events** | <code>Array<string></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html#events OrganizationWebhook#events}.
**active**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html#active OrganizationWebhook#active}.<br/>__*Optional*__
**configuration**? | <code>Array<[OrganizationWebhookConfiguration](#cdktf-provider-github-organizationwebhookconfiguration)></code> | configuration block.<br/>__*Optional*__
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**name**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html#name OrganizationWebhook#name}.<br/>__*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct OrganizationWebhookConfiguration  <a id="cdktf-provider-github-organizationwebhookconfiguration"></a>






Name | Type | Description 
-----|------|-------------
**url** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html#url OrganizationWebhook#url}.
**contentType**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html#content_type OrganizationWebhook#content_type}.<br/>__*Optional*__
**insecureSsl**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html#insecure_ssl OrganizationWebhook#insecure_ssl}.<br/>__*Optional*__
**secret**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html#secret OrganizationWebhook#secret}.<br/>__*Optional*__



## struct ProjectCardConfig  <a id="cdktf-provider-github-projectcardconfig"></a>






Name | Type | Description 
-----|------|-------------
**columnId** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/project_card.html#column_id ProjectCard#column_id}.
**note** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/project_card.html#note ProjectCard#note}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct ProjectColumnConfig  <a id="cdktf-provider-github-projectcolumnconfig"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/project_column.html#name ProjectColumn#name}.
**projectId** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/project_column.html#project_id ProjectColumn#project_id}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct RepositoryCollaboratorConfig  <a id="cdktf-provider-github-repositorycollaboratorconfig"></a>






Name | Type | Description 
-----|------|-------------
**repository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_collaborator.html#repository RepositoryCollaborator#repository}.
**username** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_collaborator.html#username RepositoryCollaborator#username}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**permission**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_collaborator.html#permission RepositoryCollaborator#permission}.<br/>__*Optional*__
**permissionDiffSuppression**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_collaborator.html#permission_diff_suppression RepositoryCollaborator#permission_diff_suppression}.<br/>__*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct RepositoryConfig  <a id="cdktf-provider-github-repositoryconfig"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#name Repository#name}.
**allowMergeCommit**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#allow_merge_commit Repository#allow_merge_commit}.<br/>__*Optional*__
**allowRebaseMerge**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#allow_rebase_merge Repository#allow_rebase_merge}.<br/>__*Optional*__
**allowSquashMerge**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#allow_squash_merge Repository#allow_squash_merge}.<br/>__*Optional*__
**archiveOnDestroy**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#archive_on_destroy Repository#archive_on_destroy}.<br/>__*Optional*__
**archived**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#archived Repository#archived}.<br/>__*Optional*__
**autoInit**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#auto_init Repository#auto_init}.<br/>__*Optional*__
**count**?🔹 | <code>number</code> | __*Optional*__
**defaultBranch**? | <code>string</code> | Can only be set after initial repository creation, and only if the target branch exists.<br/>__*Optional*__
**deleteBranchOnMerge**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#delete_branch_on_merge Repository#delete_branch_on_merge}.<br/>__*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**description**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#description Repository#description}.<br/>__*Optional*__
**gitignoreTemplate**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#gitignore_template Repository#gitignore_template}.<br/>__*Optional*__
**hasDownloads**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#has_downloads Repository#has_downloads}.<br/>__*Optional*__
**hasIssues**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#has_issues Repository#has_issues}.<br/>__*Optional*__
**hasProjects**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#has_projects Repository#has_projects}.<br/>__*Optional*__
**hasWiki**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#has_wiki Repository#has_wiki}.<br/>__*Optional*__
**homepageUrl**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#homepage_url Repository#homepage_url}.<br/>__*Optional*__
**isTemplate**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#is_template Repository#is_template}.<br/>__*Optional*__
**licenseTemplate**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#license_template Repository#license_template}.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**pages**? | <code>Array<[RepositoryPages](#cdktf-provider-github-repositorypages)></code> | pages block.<br/>__*Optional*__
**private**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#private Repository#private}.<br/>__*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__
**template**? | <code>Array<[RepositoryTemplate](#cdktf-provider-github-repositorytemplate)></code> | template block.<br/>__*Optional*__
**topics**? | <code>Array<string></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#topics Repository#topics}.<br/>__*Optional*__
**visibility**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#visibility Repository#visibility}.<br/>__*Optional*__
**vulnerabilityAlerts**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#vulnerability_alerts Repository#vulnerability_alerts}.<br/>__*Optional*__



## struct RepositoryDeployKeyConfig  <a id="cdktf-provider-github-repositorydeploykeyconfig"></a>






Name | Type | Description 
-----|------|-------------
**key** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_deploy_key.html#key RepositoryDeployKey#key}.
**repository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_deploy_key.html#repository RepositoryDeployKey#repository}.
**title** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_deploy_key.html#title RepositoryDeployKey#title}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__
**readOnly**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_deploy_key.html#read_only RepositoryDeployKey#read_only}.<br/>__*Optional*__



## struct RepositoryEnvironmentConfig  <a id="cdktf-provider-github-repositoryenvironmentconfig"></a>






Name | Type | Description 
-----|------|-------------
**environment** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html#environment RepositoryEnvironment#environment}.
**repository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html#repository RepositoryEnvironment#repository}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**deploymentBranchPolicy**? | <code>Array<[RepositoryEnvironmentDeploymentBranchPolicy](#cdktf-provider-github-repositoryenvironmentdeploymentbranchpolicy)></code> | deployment_branch_policy block.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__
**reviewers**? | <code>Array<[RepositoryEnvironmentReviewers](#cdktf-provider-github-repositoryenvironmentreviewers)></code> | reviewers block.<br/>__*Optional*__
**waitTimer**? | <code>number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html#wait_timer RepositoryEnvironment#wait_timer}.<br/>__*Optional*__



## struct RepositoryEnvironmentDeploymentBranchPolicy  <a id="cdktf-provider-github-repositoryenvironmentdeploymentbranchpolicy"></a>






Name | Type | Description 
-----|------|-------------
**customBranchPolicies** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html#custom_branch_policies RepositoryEnvironment#custom_branch_policies}.
**protectedBranches** | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html#protected_branches RepositoryEnvironment#protected_branches}.



## struct RepositoryEnvironmentReviewers  <a id="cdktf-provider-github-repositoryenvironmentreviewers"></a>






Name | Type | Description 
-----|------|-------------
**teams**? | <code>Array<number></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html#teams RepositoryEnvironment#teams}.<br/>__*Optional*__
**users**? | <code>Array<number></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html#users RepositoryEnvironment#users}.<br/>__*Optional*__



## struct RepositoryFileConfig  <a id="cdktf-provider-github-repositoryfileconfig"></a>






Name | Type | Description 
-----|------|-------------
**content** | <code>string</code> | The file's content.
**file** | <code>string</code> | The file path to manage.
**repository** | <code>string</code> | The repository name.
**branch**? | <code>string</code> | The branch name, defaults to "main".<br/>__*Optional*__
**commitAuthor**? | <code>string</code> | The commit author name, defaults to the authenticated user's name.<br/>__*Optional*__
**commitEmail**? | <code>string</code> | The commit author email address, defaults to the authenticated user's email address.<br/>__*Optional*__
**commitMessage**? | <code>string</code> | The commit message when creating or updating the file.<br/>__*Optional*__
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**overwriteOnCreate**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Enable overwriting existing files, defaults to "false".<br/>__*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct RepositoryMilestoneConfig  <a id="cdktf-provider-github-repositorymilestoneconfig"></a>






Name | Type | Description 
-----|------|-------------
**owner** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_milestone.html#owner RepositoryMilestone#owner}.
**repository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_milestone.html#repository RepositoryMilestone#repository}.
**title** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_milestone.html#title RepositoryMilestone#title}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**description**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_milestone.html#description RepositoryMilestone#description}.<br/>__*Optional*__
**dueDate**? | <code>string</code> | in yyyy-mm-dd format.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__
**state**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_milestone.html#state RepositoryMilestone#state}.<br/>__*Optional*__



## struct RepositoryPages  <a id="cdktf-provider-github-repositorypages"></a>






Name | Type | Description 
-----|------|-------------
**source** | <code>Array<[RepositoryPagesSource](#cdktf-provider-github-repositorypagessource)></code> | source block.
**cname**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#cname Repository#cname}.<br/>__*Optional*__



## struct RepositoryPagesSource  <a id="cdktf-provider-github-repositorypagessource"></a>






Name | Type | Description 
-----|------|-------------
**branch** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#branch Repository#branch}.
**path**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#path Repository#path}.<br/>__*Optional*__



## struct RepositoryProjectConfig  <a id="cdktf-provider-github-repositoryprojectconfig"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_project.html#name RepositoryProject#name}.
**repository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_project.html#repository RepositoryProject#repository}.
**body**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_project.html#body RepositoryProject#body}.<br/>__*Optional*__
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct RepositoryPullRequestConfig  <a id="cdktf-provider-github-repositorypullrequestconfig"></a>






Name | Type | Description 
-----|------|-------------
**baseRef** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html#base_ref RepositoryPullRequest#base_ref}.
**baseRepository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html#base_repository RepositoryPullRequest#base_repository}.
**headRef** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html#head_ref RepositoryPullRequest#head_ref}.
**title** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html#title RepositoryPullRequest#title}.
**body**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html#body RepositoryPullRequest#body}.<br/>__*Optional*__
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**maintainerCanModify**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html#maintainer_can_modify RepositoryPullRequest#maintainer_can_modify}.<br/>__*Optional*__
**owner**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html#owner RepositoryPullRequest#owner}.<br/>__*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct RepositoryTemplate  <a id="cdktf-provider-github-repositorytemplate"></a>






Name | Type | Description 
-----|------|-------------
**owner** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#owner Repository#owner}.
**repository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#repository Repository#repository}.



## struct RepositoryWebhookConfig  <a id="cdktf-provider-github-repositorywebhookconfig"></a>






Name | Type | Description 
-----|------|-------------
**events** | <code>Array<string></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html#events RepositoryWebhook#events}.
**repository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html#repository RepositoryWebhook#repository}.
**active**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html#active RepositoryWebhook#active}.<br/>__*Optional*__
**configuration**? | <code>Array<[RepositoryWebhookConfiguration](#cdktf-provider-github-repositorywebhookconfiguration)></code> | configuration block.<br/>__*Optional*__
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**name**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html#name RepositoryWebhook#name}.<br/>__*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct RepositoryWebhookConfiguration  <a id="cdktf-provider-github-repositorywebhookconfiguration"></a>






Name | Type | Description 
-----|------|-------------
**url** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html#url RepositoryWebhook#url}.
**contentType**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html#content_type RepositoryWebhook#content_type}.<br/>__*Optional*__
**insecureSsl**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html#insecure_ssl RepositoryWebhook#insecure_ssl}.<br/>__*Optional*__
**secret**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html#secret RepositoryWebhook#secret}.<br/>__*Optional*__



## struct TeamConfig  <a id="cdktf-provider-github-teamconfig"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team.html#name Team#name}.
**count**?🔹 | <code>number</code> | __*Optional*__
**createDefaultMaintainer**? | <code>boolean &#124; [IResolvable](#cdktf-iresolvable)</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team.html#create_default_maintainer Team#create_default_maintainer}.<br/>__*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**description**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team.html#description Team#description}.<br/>__*Optional*__
**ldapDn**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team.html#ldap_dn Team#ldap_dn}.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**parentTeamId**? | <code>number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team.html#parent_team_id Team#parent_team_id}.<br/>__*Optional*__
**privacy**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team.html#privacy Team#privacy}.<br/>__*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct TeamMembershipConfig  <a id="cdktf-provider-github-teammembershipconfig"></a>






Name | Type | Description 
-----|------|-------------
**teamId** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_membership.html#team_id TeamMembership#team_id}.
**username** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_membership.html#username TeamMembership#username}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__
**role**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_membership.html#role TeamMembership#role}.<br/>__*Optional*__



## struct TeamRepositoryConfig  <a id="cdktf-provider-github-teamrepositoryconfig"></a>






Name | Type | Description 
-----|------|-------------
**repository** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_repository.html#repository TeamRepository#repository}.
**teamId** | <code>string</code> | ID or slug of team.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**permission**? | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_repository.html#permission TeamRepository#permission}.<br/>__*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct TeamSyncGroupMappingConfig  <a id="cdktf-provider-github-teamsyncgroupmappingconfig"></a>






Name | Type | Description 
-----|------|-------------
**teamSlug** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_sync_group_mapping.html#team_slug TeamSyncGroupMapping#team_slug}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**group**? | <code>Array<[TeamSyncGroupMappingGroup](#cdktf-provider-github-teamsyncgroupmappinggroup)></code> | group block.<br/>__*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct TeamSyncGroupMappingGroup  <a id="cdktf-provider-github-teamsyncgroupmappinggroup"></a>






Name | Type | Description 
-----|------|-------------
**groupDescription** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_sync_group_mapping.html#group_description TeamSyncGroupMapping#group_description}.
**groupId** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_sync_group_mapping.html#group_id TeamSyncGroupMapping#group_id}.
**groupName** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_sync_group_mapping.html#group_name TeamSyncGroupMapping#group_name}.



## struct UserGpgKeyConfig  <a id="cdktf-provider-github-usergpgkeyconfig"></a>






Name | Type | Description 
-----|------|-------------
**armoredPublicKey** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/user_gpg_key.html#armored_public_key UserGpgKey#armored_public_key}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct UserInvitationAccepterConfig  <a id="cdktf-provider-github-userinvitationaccepterconfig"></a>






Name | Type | Description 
-----|------|-------------
**invitationId** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/user_invitation_accepter.html#invitation_id UserInvitationAccepter#invitation_id}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



## struct UserSshKeyConfig  <a id="cdktf-provider-github-usersshkeyconfig"></a>






Name | Type | Description 
-----|------|-------------
**key** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/user_ssh_key.html#key UserSshKey#key}.
**title** | <code>string</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/user_ssh_key.html#title UserSshKey#title}.
**count**?🔹 | <code>number</code> | __*Optional*__
**dependsOn**?🔹 | <code>Array<[ITerraformDependable](#cdktf-iterraformdependable)></code> | __*Optional*__
**lifecycle**?🔹 | <code>[TerraformResourceLifecycle](#cdktf-terraformresourcelifecycle)</code> | __*Optional*__
**provider**?🔹 | <code>[TerraformProvider](#cdktf-terraformprovider)</code> | __*Optional*__



