# hackhttp2

## intro

This repo is inspired by `hackhttp`, but it's out of date already. so, I create this repo to make `simulation` and `Network request` easier.

## Aims to

- make simulation **easier**
- use the raw request that generated by burp **directly**
- make the use of multi-thread **easier**
- make the use of coroutines **easier**
- config every thing **easier**

## startup

```python
### send a request from raw
from hackhttp2 import hackhttp
hh = hackhttp()
# set global configs, if you don't have special needs, default settings is ok.
# hh.globals.xxx = xxx

resp = hh.load_raw("path_of_raw.txt").send()

### useage of coroutine
hh.globals.kwargs.update({"allow_redirects":False})
req = hh.load_raw("baidu.txt")

with hh.create_pool_coroutine() as p:
  p.add_reqs([req]*num)
  p.start_all()
  
### useage of multi-thread
with hh.create_pool_thread() as p:
  p.add_reqs([req]*num)
  p.start_all()
  p.join_all()

```

## concepts

hackhttp2 is based on `requests` for ordinary requests and `httpx` for async requests. when you use `hh.load_raw()`, you'll get a `Request` obj, which can be modified by yourself. Once the modification is completed, you can use `req.send()` to send the request.

`hh.globals`is a global configuration for hackhttp, you can set `global header/cookie/kwargs(kwargs of requests.request)`by your self.

You can setup some `hackhttp()` to manage your connections, because one `hackhttp()` shares one Session which is the value of the attribute `.client`, and it'll be changed when using coroutine.

## ending

It's still in developing, but it can satisfy your basic needs. The useage of thread_pool & coroutine_pool needs to be careful when number of conn is higher than 10, because the limit of conn_pool in the requests. I'm working on how to make it gracefully to control the api.

​ 
