import * as lambda from '@aws-cdk/aws-lambda';
import * as cdk from '@aws-cdk/core';
/**
 * Properties for a NodejsFunction
 */
export interface NodejsFunctionProps extends lambda.FunctionOptions {
    /**
     * Path to the entry file (JavaScript or TypeScript).
     *
     * @default - Derived from the name of the defining file and the construct's id.
     * If the `NodejsFunction` is defined in `stack.ts` with `my-handler` as id
     * (`new NodejsFunction(this, 'my-handler')`), the construct will look at `stack.my-handler.ts`
     * and `stack.my-handler.js`.
     */
    readonly entry?: string;
    /**
     * The name of the exported handler in the entry file.
     *
     * @default handler
     */
    readonly handler?: string;
    /**
     * The runtime environment. Only runtimes of the Node.js family are
     * supported.
     *
     * @default - `NODEJS_12_X` if `process.versions.node` >= '12.0.0',
     * `NODEJS_10_X` otherwise.
     */
    readonly runtime?: lambda.Runtime;
    /**
     * Whether to minify files when bundling.
     *
     * @default false
     */
    readonly minify?: boolean;
    /**
     * Whether to include source maps when bundling.
     *
     * @default false
     */
    readonly sourceMaps?: boolean;
    /**
     * The build directory
     *
     * @default - `.build` in the entry file directory
     */
    readonly buildDir?: string;
    /**
     * The cache directory
     *
     * Parcel uses a filesystem cache for fast rebuilds.
     *
     * @default - `.cache` in the root directory
     */
    readonly cacheDir?: string;
    /**
     * The docker tag of the node base image to use in the parcel-bundler docker image
     *
     * @see https://hub.docker.com/_/node/?tab=tags
     *
     * @default - the `process.versions.node` alpine image
     */
    readonly nodeDockerTag?: string;
    /**
     * The root of the project. This will be used as the source for the volume
     * mounted in the Docker container. If you specify this prop, ensure that
     * this path includes `entry` and any module/dependencies used by your
     * function otherwise bundling will not be possible.
     *
     * @default - the closest path containing a .git folder
     */
    readonly projectRoot?: string;
    /**
     * The environment variables to pass to the container running Parcel.
     *
     * @default - no environment variables are passed to the container
     */
    readonly containerEnvironment?: {
        [key: string]: string;
    };
}
/**
 * A Node.js Lambda function bundled using Parcel
 */
export declare class NodejsFunction extends lambda.Function {
    constructor(scope: cdk.Construct, id: string, props?: NodejsFunctionProps);
}
