# -*- coding: utf-8 -*-
#
# This file is part of the python-shogi library.
# Copyright (C) 2015- Tasuku SUENAGA <tasuku-s-github@titech.ac>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

import re

NAME_SUFFIX_RE = re.compile(
    r"(小\d|奨励会|アマ|さん|[四五六七八九]段|[一二三四五六]冠|前?(名人|棋聖|王位|王座|王将|棋王|九段|十段|竜王|nhk杯|新人王|女王|女流王座|女流名人|女流王将|女流王位|倉敷藤花)+)$"
)

NAMES_OF_PROFESSIONAL_PLAYERS = [
    # old
    "天野宗歩",
    "小野五平",
    "溝呂木光治",
    "小菅剣之助",
    "関根金次郎",
    "花田長太郎",
    "小林東伯斎",
    "阪田三吉",
    "坂田三吉",
    "木見金治郎",
    "井上義雄",
    "大崎熊雄",
    "宮松関三郎",
    "川井房郷",
    "石井秀吉",
    "長谷川清二郎",
    "神田辰之助",
    "土居市太郎",
    "山本樟郎",
    "小泉雅信",
    "平野信助",
    "藤内金吾",
    "飯塚勘一郎",
    "斎藤銀次郎",
    "鈴木禎一",
    "建部和歌夫",
    "上田三三",
    "畝美与吉",
    "松田辰雄",
    "大和久彪",
    "橋爪敏太郎",
    "野村慶虎",
    "村上真一",
    "金高清吉",
    "間宮純一",
    "藤川義夫",
    "京須行男",
    "松浦卓造",
    "山田道美",
    "市川伸",
    # shogi renmei
    "金易二郎",
    "木村義雄",
    "金子金五郎",
    "渡辺東一",
    "萩原淳",
    "中井捨吉",
    "大野源一",
    "志沢春吉",
    "市川一郎",
    "坂口允彦",
    "塚田正夫",
    "梶一郎",
    "角田三男",
    "加藤治郎",
    "松下力",
    "奥野基芳",
    "小堀清一",
    "升田幸三",
    "高島一岐代",
    "荒巻三之",
    "永沢勝雄",
    "加藤恵三",
    "岡崎史明",
    "北楯修哉",
    "松田茂役",
    "大山康晴",
    "山本武雄",
    "山中和正",
    "板谷四郎",
    "本間爽悦",
    "高柳敏夫",
    "廣津久雄",
    "吉田六彦",
    "富沢幹雄",
    "原田泰夫",
    "星田啓三",
    "南口繁一",
    "北村秀治郎",
    "花村元司",
    "山川次彦",
    "佐瀬勇次",
    "加藤博二",
    "丸田祐三",
    "灘蓮照",
    "平野広吉",
    "五十嵐豊一",
    "清野静男",
    "佐藤豊",
    "木川貴一",
    "下平幸男",
    "二見敬三",
    "西本馨",
    "神田鎮雄",
    "熊谷達人",
    "増田敏二",
    "浅沼一",
    "二上達也",
    "橋本三治",
    "津村常吉",
    "北村昌男",
    "関根茂",
    "大友昇",
    "佐藤庄平",
    "加藤一二三",
    "宮坂幸雄",
    "有吉道夫",
    "長谷部久雄",
    "芹沢博文",
    "関屋喜代作",
    "賀集正三",
    "大村和久",
    "大原英二",
    "剱持松二",
    "佐藤大五郎",
    "吉田利勝",
    "北村文男",
    "内藤國雄",
    "伊達康夫",
    "佐伯昌優",
    "木村嘉孝",
    "山口千嶺",
    "木村義徳",
    "高島弘光",
    "板谷進",
    "米長邦雄",
    "大内延介",
    "西村一義",
    "木下晃",
    "山口英夫",
    "桜井昇",
    "田辺一郎",
    "中原誠",
    "桐山清澄",
    "高田丈資",
    "河口俊彦",
    "勝浦修",
    "石田和雄",
    "若松政和",
    "森安秀光",
    "森雞二",
    "森けい二",
    "滝誠一郎",
    "池田修一",
    "野本虎次",
    "田中魁秀",
    "坪内利幸",
    "佐藤義則",
    "安恵照剛",
    "森安正幸",
    "田丸昇",
    "宮田利男",
    "真部一男",
    "小阪昇",
    "淡路仁茂",
    "青野照市",
    "椎橋金司",
    "前田祐司",
    "飯野健二",
    "伊藤果",
    "菊地常夫",
    "桐谷広人",
    "沼春雄",
    "有野芳人",
    "小林健二",
    "土佐浩司",
    "酒井順吉",
    "森信雄",
    "田中寅彦",
    "東和男",
    "中田章道",
    "大島映二",
    "谷川浩司",
    "松浦隆一",
    "青木清",
    "小野修一",
    "福崎文吾",
    "鈴木輝彦",
    "武者野勝巳",
    "脇謙二",
    "永作芳也",
    "瀬戸博晴",
    "児玉孝一",
    "高橋道雄",
    "中村修",
    "泉正樹",
    "依田有司",
    "島朗",
    "南芳一",
    "塚田泰明",
    "神谷広志",
    "植山悦行",
    "西川慶二",
    "武市三郎",
    "室岡克彦",
    "堀口弘治",
    "大野八一雄",
    "加瀬純一",
    "井上慶太",
    "有森浩三",
    "飯田弘之",
    "神吉宏充",
    "森下卓",
    "浦野真彦",
    "小野敦生",
    "日浦市郎",
    "達正光",
    "伊藤博文",
    "小林宏",
    "富岡英作",
    "関浩",
    "本間博",
    "阿部隆",
    "所司和晴",
    "中田宏樹",
    "安西勝一",
    "羽生善治",
    "中田功",
    "石川陽生",
    "長沼洋",
    "神崎健二",
    "村山聖",
    "櫛田陽一",
    "佐藤康光",
    "森内俊之",
    "中川大輔",
    "先崎学",
    "野田敬三",
    "木下浩一",
    "小倉久史",
    "屋敷伸之",
    "藤原直哉",
    "高田尚平",
    "畠山鎮",
    "畠山成幸",
    "丸山忠久",
    "郷田真隆",
    "佐藤秀司",
    "杉本昌隆",
    "藤井猛",
    "平藤眞吾",
    "豊川孝弘",
    "深浦康市",
    "真田圭一",
    "飯塚祐紀",
    "三浦弘行",
    "伊藤能",
    "川上猛",
    "久保利明",
    "行方尚史",
    "岡崎洋",
    "窪田義行",
    "北浜健介",
    "矢倉規広",
    "鈴木大介",
    "北島忠雄",
    "勝又清和",
    "松本佳介",
    "田村康介",
    "堀口一史座",
    "中座真",
    "近藤正和",
    "野月浩貴",
    "木村一基",
    "小林裕士",
    "佐藤紳哉",
    "増田裕司",
    "高野秀行",
    "山崎隆之",
    "伊奈祐介",
    "山本真也",
    "中尾敏之",
    "松尾歩",
    "金沢孝史",
    "阿久津主税",
    "安用寺孝功",
    "渡辺明",
    "飯島栄治",
    "千葉幸生",
    "上野裕和",
    "橋本崇載",
    "佐々木慎",
    "宮田敦史",
    "村田智弘",
    "大平武洋",
    "熊坂学",
    "藤倉勇樹",
    "横山泰明",
    "島本亮",
    "西尾明",
    "村山慈明",
    "佐藤和俊",
    "片上大輔",
    "中村亮介",
    "村中秀史",
    "阪口悟",
    "広瀬章人",
    "長岡裕也",
    "高崎一生",
    "遠山雄亮",
    "瀬川晶司",
    "糸谷哲郎",
    "中村太地",
    "戸辺誠",
    "佐藤天彦",
    "豊島将之",
    "金井恒太",
    "伊藤真吾",
    "村田顕弘",
    "及川拓馬",
    "稲葉陽",
    "田中悠一",
    "佐藤慎一",
    "西川和宏",
    "吉田正和",
    "澤田真吾",
    "大石直嗣",
    "永瀬拓矢",
    "阿部健治郎",
    "菅井竜也",
    "牧野光則",
    "佐々木勇気",
    "船江恒平",
    "門倉啓太",
    "阿部光瑠",
    "高見泰地",
    "藤森哲也",
    "斎藤慎太郎",
    "八代弥",
    "上村亘",
    "石田直裕",
    "渡辺大夢",
    "千田翔太",
    "竹内雄悟",
    "石井健太郎",
    "三枚堂達也",
    "星野良生",
    "宮本広志",
    "増田康宏",
    "黒沢怜生",
    "今泉健司",
    "青嶋未来",
    "梶浦宏孝",
    "高野智史",
    "近藤誠也",
    "都成竜馬",
    "井出隼平",
    "佐々木大地",
    "藤井聡太",
    "大橋貴洸",
    "西田拓也",
    "杉本和陽",
]

NAMES_OF_LADIES_PROFESSIONAL_PLAYERS = [
    "蛸島彰子",
    "関根紀代子",
    "多田佳子",
    "山下カズ子",
    "寺下紀子",
    "村山幸子",
    "杉崎里子",
    "福崎睦美",
    "佐藤寿子",
    "谷川治恵",
    "森安多恵子",
    "宇治正子",
    "藤森奈津子",
    "長沢千和子",
    "神田真由美",
    "林葉直子",
    "中井広恵",
    "山田久美",
    "清水市代",
    "高群佐知子",
    "斎田晴子",
    "石高澄恵",
    "鹿野圭生",
    "植村真理",
    "船戸陽子",
    "大庭美樹",
    "真田彩子",
    "高橋和",
    "林まゆみ",
    "本田小百合",
    "久津知子",
    "矢内理絵子",
    "石橋幸緒",
    "中倉彰",
    "千葉涼子",
    "伊藤明日香",
    "竹部さゆり",
    "中倉宏美",
    "島井咲緒里",
    "早水千紗",
    "甲斐智美",
    "藤田麻衣子",
    "安食総子",
    "大庭美夏",
    "藤田綾",
    "上川香織",
    "野田澤彩乃",
    "山田朱未",
    "北尾まどか",
    "上田初美",
    "坂東香菜子",
    "村田智穂",
    "鈴木環那",
    "中村真梨花",
    "貞升南",
    "岩根忍",
    "里見香奈",
    "井道千尋",
    "室田伊緒",
    "伊奈川愛菓",
    "熊倉紫野",
    "中村桃子",
    "山口恵梨子",
    "香川愛生",
    "渡辺弥生",
    "室谷由紀",
    "長谷川優貴",
    "竹俣紅",
    "北村桂香",
    "相川春香",
    "飯野愛",
    "渡部愛",
    "山根ことみ",
    "和田あき",
    "塚田恵梨花",
    "伊藤沙恵",
    "中澤沙耶",
    "高浜愛子",
    "山口絵美菜",
    "里見咲紀",
    "石本さくら",
    "頼本奈菜",
    "カロリーナ・ステチェンスカ",
    "堀彩乃",
]


class Name:
    @staticmethod
    def normalize(name):
        if name is None:
            return None
        name = name.translate(
            {
                ord(" "): None,  # space
                ord("　"): None,  # full-width space
                ord("・"): None,  # full-width center dot
            }
        )
        name = NAME_SUFFIX_RE.sub("", name)

        return name

    @staticmethod
    def is_professional(name):
        normalized = Name.normalize(name)
        return normalized in NAMES_OF_PROFESSIONAL_PLAYERS

    @staticmethod
    def is_ladies_professional(name):
        normalized = Name.normalize(name)
        return normalized in NAMES_OF_LADIES_PROFESSIONAL_PLAYERS
