"""
    STACKL

    stackl  # noqa: E501

    The version of the OpenAPI document: 0.3.4.dev0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from stackl_client.api_client import ApiClient, Endpoint as _Endpoint
from stackl_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from stackl_client.model.http_validation_error import HTTPValidationError
from stackl_client.model.infrastructure_base_document import InfrastructureBaseDocument


class InfrastructureBaseApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __delete_infrastructure_base(
            self,
            infrastructure_base_type,
            infrastructure_base_name,
            **kwargs
        ):
            """Delete Infrastructure Base  # noqa: E501

            Delete an infrastructure base document by name and type Type is environment, location or zone  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_infrastructure_base(infrastructure_base_type, infrastructure_base_name, async_req=True)
            >>> result = thread.get()

            Args:
                infrastructure_base_type (str):
                infrastructure_base_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                bool, date, datetime, dict, float, int, list, str, none_type
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['infrastructure_base_type'] = \
                infrastructure_base_type
            kwargs['infrastructure_base_name'] = \
                infrastructure_base_name
            return self.call_with_http_info(**kwargs)

        self.delete_infrastructure_base = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/infrastructure_base/{infrastructure_base_type}/{infrastructure_base_name}',
                'operation_id': 'delete_infrastructure_base',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'infrastructure_base_type',
                    'infrastructure_base_name',
                ],
                'required': [
                    'infrastructure_base_type',
                    'infrastructure_base_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'infrastructure_base_type':
                        (str,),
                    'infrastructure_base_name':
                        (str,),
                },
                'attribute_map': {
                    'infrastructure_base_type': 'infrastructure_base_type',
                    'infrastructure_base_name': 'infrastructure_base_name',
                },
                'location_map': {
                    'infrastructure_base_type': 'path',
                    'infrastructure_base_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_infrastructure_base
        )

        def __get_infrastructure_base_by_type(
            self,
            infrastructure_base_type,
            **kwargs
        ):
            """Get Infrastructure Base By Type  # noqa: E501

            Returns a specific infrastructure_base document with a type and name  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_infrastructure_base_by_type(infrastructure_base_type, async_req=True)
            >>> result = thread.get()

            Args:
                infrastructure_base_type (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [InfrastructureBaseDocument]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['infrastructure_base_type'] = \
                infrastructure_base_type
            return self.call_with_http_info(**kwargs)

        self.get_infrastructure_base_by_type = _Endpoint(
            settings={
                'response_type': ([InfrastructureBaseDocument],),
                'auth': [],
                'endpoint_path': '/infrastructure_base/{infrastructure_base_type}',
                'operation_id': 'get_infrastructure_base_by_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'infrastructure_base_type',
                ],
                'required': [
                    'infrastructure_base_type',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'infrastructure_base_type':
                        (str,),
                },
                'attribute_map': {
                    'infrastructure_base_type': 'infrastructure_base_type',
                },
                'location_map': {
                    'infrastructure_base_type': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_infrastructure_base_by_type
        )

        def __get_infrastructure_base_by_type_and_name(
            self,
            infrastructure_base_type,
            infrastructure_base_name,
            **kwargs
        ):
            """Get Infrastructure Base By Type And Name  # noqa: E501

            Returns a specific infrastructure_base document with a type and name  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_infrastructure_base_by_type_and_name(infrastructure_base_type, infrastructure_base_name, async_req=True)
            >>> result = thread.get()

            Args:
                infrastructure_base_type (str):
                infrastructure_base_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InfrastructureBaseDocument
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['infrastructure_base_type'] = \
                infrastructure_base_type
            kwargs['infrastructure_base_name'] = \
                infrastructure_base_name
            return self.call_with_http_info(**kwargs)

        self.get_infrastructure_base_by_type_and_name = _Endpoint(
            settings={
                'response_type': (InfrastructureBaseDocument,),
                'auth': [],
                'endpoint_path': '/infrastructure_base/{infrastructure_base_type}/{infrastructure_base_name}',
                'operation_id': 'get_infrastructure_base_by_type_and_name',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'infrastructure_base_type',
                    'infrastructure_base_name',
                ],
                'required': [
                    'infrastructure_base_type',
                    'infrastructure_base_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'infrastructure_base_type':
                        (str,),
                    'infrastructure_base_name':
                        (str,),
                },
                'attribute_map': {
                    'infrastructure_base_type': 'infrastructure_base_type',
                    'infrastructure_base_name': 'infrastructure_base_name',
                },
                'location_map': {
                    'infrastructure_base_type': 'path',
                    'infrastructure_base_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_infrastructure_base_by_type_and_name
        )

        def __post_infrastructure_base(
            self,
            infrastructure_base_document,
            **kwargs
        ):
            """Post Infrastructure Base  # noqa: E501

            Create the infrastructure_base document with a specific type and an optional name given in the payload  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_infrastructure_base(infrastructure_base_document, async_req=True)
            >>> result = thread.get()

            Args:
                infrastructure_base_document (InfrastructureBaseDocument):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InfrastructureBaseDocument
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['infrastructure_base_document'] = \
                infrastructure_base_document
            return self.call_with_http_info(**kwargs)

        self.post_infrastructure_base = _Endpoint(
            settings={
                'response_type': (InfrastructureBaseDocument,),
                'auth': [],
                'endpoint_path': '/infrastructure_base',
                'operation_id': 'post_infrastructure_base',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'infrastructure_base_document',
                ],
                'required': [
                    'infrastructure_base_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'infrastructure_base_document':
                        (InfrastructureBaseDocument,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'infrastructure_base_document': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_infrastructure_base
        )

        def __put_infrastructure_base(
            self,
            infrastructure_base_document,
            **kwargs
        ):
            """Put Infrastructure Base  # noqa: E501

            Updates the infrastructure_base document with a specific type and an optional name given in the payload  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.put_infrastructure_base(infrastructure_base_document, async_req=True)
            >>> result = thread.get()

            Args:
                infrastructure_base_document (InfrastructureBaseDocument):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InfrastructureBaseDocument
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['infrastructure_base_document'] = \
                infrastructure_base_document
            return self.call_with_http_info(**kwargs)

        self.put_infrastructure_base = _Endpoint(
            settings={
                'response_type': (InfrastructureBaseDocument,),
                'auth': [],
                'endpoint_path': '/infrastructure_base',
                'operation_id': 'put_infrastructure_base',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'infrastructure_base_document',
                ],
                'required': [
                    'infrastructure_base_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'infrastructure_base_document':
                        (InfrastructureBaseDocument,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'infrastructure_base_document': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__put_infrastructure_base
        )
