# ehelply-python-sdk
eHelply SDK for SuperStack Services

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.1.83
- Package version: 1.1.83
- Build package: org.openapitools.codegen.languages.PythonExperimentalClientCodegen
For more information, please visit [https://superstack.ehelply.com/support](https://superstack.ehelply.com/support)

## Requirements.

Python &gt;&#x3D;3.9
v3.9 is needed so one can combine classmethod and property decorators to define
object schema properties as classes

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import ehelply_python_sdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import ehelply_python_sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import ehelply_python_sdk
from pprint import pprint
from ehelply_python_sdk.api import billing_api
from ehelply_python_sdk.model.http_validation_error import HTTPValidationError
from ehelply_python_sdk.model.payment import Payment
from ehelply_python_sdk.model.payment_method_response import PaymentMethodResponse
from ehelply_python_sdk.model.stripe_account_response import StripeAccountResponse
from ehelply_python_sdk.model.stripe_customer_secret_response import StripeCustomerSecretResponse
# Defining the host is optional and defaults to https://api.prod.ehelply.com
# See configuration.py for a list of all supported configuration parameters.
configuration = ehelply_python_sdk.Configuration(
    host = "https://api.prod.ehelply.com"
)


# Enter a context with an instance of the API client
with ehelply_python_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = billing_api.BillingApi(api_client)
    x_access_token = "x-access-token_example" # str |  (optional)
x_secret_token = "x-secret-token_example" # str |  (optional)
authorization = "authorization_example" # str |  (optional)
ehelply_active_participant = "ehelply-active-participant_example" # str |  (optional)
ehelply_project = "ehelply-project_example" # str |  (optional)
ehelply_data = "ehelply-data_example" # str |  (optional)

    try:
        # Createbillingaccount
        api_response = api_instance.create_billing_account(x_access_token=x_access_tokenx_secret_token=x_secret_tokenauthorization=authorizationehelply_active_participant=ehelply_active_participantehelply_project=ehelply_projectehelply_data=ehelply_data)
        pprint(api_response)
    except ehelply_python_sdk.ApiException as e:
        print("Exception when calling BillingApi->create_billing_account: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.prod.ehelply.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BillingApi* | [**create_billing_account**](docs/BillingApi.md#create_billing_account) | **POST** /sam/billing/create_billing_account | Createbillingaccount
*BillingApi* | [**get_client_secret**](docs/BillingApi.md#get_client_secret) | **GET** /sam/billing/retrieve_secret | Getclientsecret
*BillingApi* | [**has_payment**](docs/BillingApi.md#has_payment) | **GET** /sam/billing/has_payment | Haspayment
*BillingApi* | [**list_payment_methods**](docs/BillingApi.md#list_payment_methods) | **GET** /sam/billing/view_payment_method | Listpaymentmethods
*BillingApi* | [**process_payment**](docs/BillingApi.md#process_payment) | **POST** /sam/billing/process_payment | Processpayment
*BillingApi* | [**reconcile_payment_method**](docs/BillingApi.md#reconcile_payment_method) | **GET** /sam/billing/reconcile_payment | Reconcilepaymentmethod
*BillingApi* | [**remove_payment_method**](docs/BillingApi.md#remove_payment_method) | **DELETE** /sam/billing/remove_payment_method | Removepaymentmethod
*CategoryApi* | [**create_category_places_categories_post**](docs/CategoryApi.md#create_category_places_categories_post) | **POST** /places/categories | Create Category
*CategoryApi* | [**delete_category_places_categories_category_uuid_delete**](docs/CategoryApi.md#delete_category_places_categories_category_uuid_delete) | **DELETE** /places/categories/{category_uuid} | Delete Category
*CategoryApi* | [**get_category_places_categories_category_uuid_get**](docs/CategoryApi.md#get_category_places_categories_category_uuid_get) | **GET** /places/categories/{category_uuid} | Get Category
*CategoryApi* | [**search_categories_places_categories_get**](docs/CategoryApi.md#search_categories_places_categories_get) | **GET** /places/categories | Search Categories
*CategoryApi* | [**update_category_places_categories_category_uuid_put**](docs/CategoryApi.md#update_category_places_categories_category_uuid_put) | **PUT** /places/categories/{category_uuid} | Update Category
*CompaniesApi* | [**create_company_places_companies_post**](docs/CompaniesApi.md#create_company_places_companies_post) | **POST** /places/companies | Create Company
*CompaniesApi* | [**delete_place_places_companies_company_uuid_delete**](docs/CompaniesApi.md#delete_place_places_companies_company_uuid_delete) | **DELETE** /places/companies/{company_uuid} | Delete Place
*CompaniesApi* | [**get_company_places_companies_company_uuid_get**](docs/CompaniesApi.md#get_company_places_companies_company_uuid_get) | **GET** /places/companies/{company_uuid} | Get Company
*CompaniesApi* | [**search_companies_places_companies_get**](docs/CompaniesApi.md#search_companies_places_companies_get) | **GET** /places/companies | Search Companies
*CompaniesApi* | [**update_company_places_companies_company_uuid_put**](docs/CompaniesApi.md#update_company_places_companies_company_uuid_put) | **PUT** /places/companies/{company_uuid} | Update Company
*DefaultApi* | [**attach_entity_to_appointment**](docs/DefaultApi.md#attach_entity_to_appointment) | **POST** /appointments/appointments/{appointment_uuid}/entities/{entity_uuid} | Attach Entity To Appointment
*DefaultApi* | [**attach_product_to_catalog**](docs/DefaultApi.md#attach_product_to_catalog) | **POST** /products/catalogs/{catalog_uuid}/products/{product_uuid} | Attach Product To Catalog
*DefaultApi* | [**create_appointment**](docs/DefaultApi.md#create_appointment) | **POST** /appointments/appointments | Create Appointment
*DefaultApi* | [**create_catalog**](docs/DefaultApi.md#create_catalog) | **POST** /products/catalogs | Create Catalog
*DefaultApi* | [**create_product**](docs/DefaultApi.md#create_product) | **POST** /products/products | Create Product
*DefaultApi* | [**create_review**](docs/DefaultApi.md#create_review) | **POST** /products/reviews/types/{entity_type}/entities/{entity_uuid} | Create Review
*DefaultApi* | [**delete_appointment**](docs/DefaultApi.md#delete_appointment) | **DELETE** /appointments/appointments/{appointment_uuid} | Delete Appointment
*DefaultApi* | [**delete_catalog**](docs/DefaultApi.md#delete_catalog) | **DELETE** /products/catalogs/{catalog_uuid} | Delete Catalog
*DefaultApi* | [**delete_product**](docs/DefaultApi.md#delete_product) | **DELETE** /products/products/{product_uuid} | Delete Product
*DefaultApi* | [**delete_review**](docs/DefaultApi.md#delete_review) | **DELETE** /products/reviews/types/{entity_type}/entities/{entity_uuid}/reviews/{review_uuid} | Delete Review
*DefaultApi* | [**detach_entity_from_appointment**](docs/DefaultApi.md#detach_entity_from_appointment) | **DELETE** /appointments/appointments/{appointment_uuid}/entities/{entity_uuid} | Detach Entity From Appointment
*DefaultApi* | [**detach_product_from_catalog**](docs/DefaultApi.md#detach_product_from_catalog) | **DELETE** /products/catalogs/{catalog_uuid}/products/{product_uuid} | Detach Product From Catalog
*DefaultApi* | [**get_appointment**](docs/DefaultApi.md#get_appointment) | **GET** /appointments/appointments/{appointment_uuid} | Get Appointment
*DefaultApi* | [**get_catalog**](docs/DefaultApi.md#get_catalog) | **GET** /products/catalogs/{catalog_uuid} | Get Catalog
*DefaultApi* | [**get_product**](docs/DefaultApi.md#get_product) | **GET** /products/products/{product_uuid} | Get Product
*DefaultApi* | [**get_review**](docs/DefaultApi.md#get_review) | **GET** /products/reviews/types/{entity_type}/entities/{entity_uuid}/reviews/{review_uuid} | Get Review
*DefaultApi* | [**search_appointment**](docs/DefaultApi.md#search_appointment) | **GET** /appointments/appointments | Search Appointment
*DefaultApi* | [**search_appointment_entities**](docs/DefaultApi.md#search_appointment_entities) | **GET** /appointments/appointments/{appointment_uuid}/entities | Search Appointment Entities
*DefaultApi* | [**search_catalog_products**](docs/DefaultApi.md#search_catalog_products) | **GET** /products/catalogs/{catalog_uuid}/products | Search Catalog Products
*DefaultApi* | [**search_catalogs**](docs/DefaultApi.md#search_catalogs) | **GET** /products/catalogs | Search Catalogs
*DefaultApi* | [**search_entity_appointments**](docs/DefaultApi.md#search_entity_appointments) | **GET** /appointments/appointments/entities/{entity_uuid}/appointments | Get Entities Appointments
*DefaultApi* | [**search_product**](docs/DefaultApi.md#search_product) | **GET** /products/products | Search Products
*DefaultApi* | [**search_product_catalog**](docs/DefaultApi.md#search_product_catalog) | **GET** /products/products/{product_uuid}/catalogs | Search Product Catalogs
*DefaultApi* | [**search_reviews**](docs/DefaultApi.md#search_reviews) | **GET** /products/reviews/types/{entity_type}/entities/{entity_uuid} | Search Review
*DefaultApi* | [**update_appointment**](docs/DefaultApi.md#update_appointment) | **PUT** /appointments/appointments/{appointment_uuid} | Update Appointment
*DefaultApi* | [**update_catalog**](docs/DefaultApi.md#update_catalog) | **PUT** /products/catalogs/{catalog_uuid} | Update Catalog
*DefaultApi* | [**update_product**](docs/DefaultApi.md#update_product) | **PUT** /products/products/{product_uuid} | Update Product
*DefaultApi* | [**update_review**](docs/DefaultApi.md#update_review) | **PUT** /products/reviews/types/{entity_type}/entities/{entity_uuid}/reviews/{review_uuid} | Update Review
*LoggingApi* | [**get_logs**](docs/LoggingApi.md#get_logs) | **GET** /sam/logging/logs | Getlogs
*LoggingApi* | [**get_service_logs**](docs/LoggingApi.md#get_service_logs) | **GET** /sam/logging/logs/services/{service} | Getservicelogs
*LoggingApi* | [**get_subject_logs**](docs/LoggingApi.md#get_subject_logs) | **GET** /sam/logging/logs/services/{service}/subjects/{subject} | Getsubjectlogs
*MetaApi* | [**create_field**](docs/MetaApi.md#create_field) | **POST** /meta/field | Create Field
*MetaApi* | [**create_meta**](docs/MetaApi.md#create_meta) | **POST** /meta/meta/service/{service}/type/{type_str}/entity/{entity_uuid} | Create Meta
*MetaApi* | [**delete_field**](docs/MetaApi.md#delete_field) | **DELETE** /meta/field/{field_uuid} | Delete Field
*MetaApi* | [**delete_meta**](docs/MetaApi.md#delete_meta) | **DELETE** /meta/meta/service/{service}/type/{type_str}/entity/{entity_uuid} | Delete Meta
*MetaApi* | [**delete_meta_from_uuid**](docs/MetaApi.md#delete_meta_from_uuid) | **DELETE** /meta/meta/{meta_uuid} | Delete Meta From Uuid
*MetaApi* | [**get_field**](docs/MetaApi.md#get_field) | **GET** /meta/field/{field_uuid} | Get Field
*MetaApi* | [**get_meta**](docs/MetaApi.md#get_meta) | **GET** /meta/meta/service/{service}/type/{type_str}/entity/{entity_uuid} | Get Meta
*MetaApi* | [**get_meta_from_uuid**](docs/MetaApi.md#get_meta_from_uuid) | **GET** /meta/meta/{meta_uuid} | Get Meta From Uuid
*MetaApi* | [**make_slug**](docs/MetaApi.md#make_slug) | **POST** /meta/meta/slug | Make Slug
*MetaApi* | [**touch_meta**](docs/MetaApi.md#touch_meta) | **POST** /meta/meta/service/{service}/type/{type_str}/entity/{entity_uuid}/touch | Touch Meta
*MetaApi* | [**update_field**](docs/MetaApi.md#update_field) | **PUT** /meta/field/{field_uuid} | Update Field
*MetaApi* | [**update_meta**](docs/MetaApi.md#update_meta) | **PUT** /meta/meta/service/{service}/type/{type_str}/entity/{entity_uuid} | Update Meta
*MetaApi* | [**update_meta_from_uuid**](docs/MetaApi.md#update_meta_from_uuid) | **PUT** /meta/meta/{meta_uuid} | Update Meta From Uuid
*MonitorApi* | [**acknowledge_alarm**](docs/MonitorApi.md#acknowledge_alarm) | **POST** /sam/monitor/services/{service}/stages/{stage}/alarms/{alarm_uuid}/acknowledge | Acknowledgealarm
*MonitorApi* | [**assign_alarm**](docs/MonitorApi.md#assign_alarm) | **POST** /sam/monitor/services/{service}/stages/{stage}/alarms/{alarm_uuid}/assign | Assignalarm
*MonitorApi* | [**attach_alarm_note**](docs/MonitorApi.md#attach_alarm_note) | **POST** /sam/monitor/services/{service}/stages/{stage}/alarms/{alarm_uuid}/note | Attachalarmnote
*MonitorApi* | [**attach_alarm_ticket**](docs/MonitorApi.md#attach_alarm_ticket) | **POST** /sam/monitor/services/{service}/stages/{stage}/alarms/{alarm_uuid}/ticket | Attachalarmticket
*MonitorApi* | [**clear_alarm**](docs/MonitorApi.md#clear_alarm) | **POST** /sam/monitor/services/{service}/stages/{stage}/alarms/{alarm_uuid}/clear | Clearalarm
*MonitorApi* | [**get_service**](docs/MonitorApi.md#get_service) | **GET** /sam/monitor/services/{service} | Getservice
*MonitorApi* | [**get_service_alarm**](docs/MonitorApi.md#get_service_alarm) | **GET** /sam/monitor/services/{service}/stages/{stage}/alarms/{alarm_uuid} | Getservicealarm
*MonitorApi* | [**get_service_alarms**](docs/MonitorApi.md#get_service_alarms) | **GET** /sam/monitor/services/{service}/stages/{stage}/alarms | Getservicealarms
*MonitorApi* | [**get_service_heartbeat**](docs/MonitorApi.md#get_service_heartbeat) | **GET** /sam/monitor/services/{service}/stages/{stage}/heartbeats | Getserviceheartbeat
*MonitorApi* | [**get_service_kpis**](docs/MonitorApi.md#get_service_kpis) | **GET** /sam/monitor/services/{service}/kpis | Getservicekpis
*MonitorApi* | [**get_service_spec**](docs/MonitorApi.md#get_service_spec) | **GET** /sam/monitor/services/{service}/specs/{spec} | Getservicespec
*MonitorApi* | [**get_service_specs**](docs/MonitorApi.md#get_service_specs) | **GET** /sam/monitor/services/{service}/specs | Getservicespecs
*MonitorApi* | [**get_service_vitals**](docs/MonitorApi.md#get_service_vitals) | **GET** /sam/monitor/services/{service}/stages/{stage}/vitals | Getservicevitals
*MonitorApi* | [**get_services**](docs/MonitorApi.md#get_services) | **GET** /sam/monitor/services | Getservices
*MonitorApi* | [**get_services_with_specs**](docs/MonitorApi.md#get_services_with_specs) | **GET** /sam/monitor/specs/services | Getserviceswithspecs
*MonitorApi* | [**hide_service**](docs/MonitorApi.md#hide_service) | **POST** /sam/monitor/services/{service}/stages/{stage}/hide | Hideservice
*MonitorApi* | [**ignore_alarm**](docs/MonitorApi.md#ignore_alarm) | **POST** /sam/monitor/services/{service}/stages/{stage}/alarms/{alarm_uuid}/ignore | Ignorealarm
*MonitorApi* | [**register_service**](docs/MonitorApi.md#register_service) | **POST** /sam/monitor/services | Registerservice
*MonitorApi* | [**search_alarms**](docs/MonitorApi.md#search_alarms) | **GET** /sam/monitor/services/{service}/alarms | Searchalarms
*MonitorApi* | [**show_service**](docs/MonitorApi.md#show_service) | **POST** /sam/monitor/services/{service}/stages/{stage}/show | Showservice
*MonitorApi* | [**terminate_alarm**](docs/MonitorApi.md#terminate_alarm) | **POST** /sam/monitor/services/{service}/stages/{stage}/alarms/{alarm_uuid}/terminate | Terminatealarm
*MonitorApi* | [**trigger_alarm**](docs/MonitorApi.md#trigger_alarm) | **POST** /sam/monitor/services/{service}/stages/{stage}/alarms | Triggeralarm
*NotesApi* | [**create_note**](docs/NotesApi.md#create_note) | **POST** /notes/notes | Create Note
*NotesApi* | [**delete_note**](docs/NotesApi.md#delete_note) | **DELETE** /notes/notes/{note_id} | Delete Note
*NotesApi* | [**get_note**](docs/NotesApi.md#get_note) | **GET** /notes/notes/{note_id} | Get Note
*NotesApi* | [**update_note**](docs/NotesApi.md#update_note) | **PUT** /notes/notes/{note_id} | Update Note
*PlacesApi* | [**create_place_places_places_post**](docs/PlacesApi.md#create_place_places_places_post) | **POST** /places/places | Create Place
*PlacesApi* | [**delete_place_places_places_place_uuid_delete**](docs/PlacesApi.md#delete_place_places_places_place_uuid_delete) | **DELETE** /places/places/{place_uuid} | Delete Place
*PlacesApi* | [**forward_geocoding_places_geocoding_forward_get**](docs/PlacesApi.md#forward_geocoding_places_geocoding_forward_get) | **GET** /places/geocoding/forward | Forward Geocoding
*PlacesApi* | [**get_place_places_places_place_uuid_get**](docs/PlacesApi.md#get_place_places_places_place_uuid_get) | **GET** /places/places/{place_uuid} | Get Place
*PlacesApi* | [**reverse_geocoding_places_geocoding_reverse_get**](docs/PlacesApi.md#reverse_geocoding_places_geocoding_reverse_get) | **GET** /places/geocoding/reverse | Reverse Geocoding
*PlacesApi* | [**search_places_by_search_string_places_search_places_string_get**](docs/PlacesApi.md#search_places_by_search_string_places_search_places_string_get) | **GET** /places/search/places/string | Search Places By Search String
*PlacesApi* | [**search_places_places_places_get**](docs/PlacesApi.md#search_places_places_places_get) | **GET** /places/places | Search Places
*PlacesApi* | [**update_place_places_places_place_uuid_put**](docs/PlacesApi.md#update_place_places_places_place_uuid_put) | **PUT** /places/places/{place_uuid} | Update Place
*ProjectsApi* | [**add_member_to_project**](docs/ProjectsApi.md#add_member_to_project) | **POST** /sam/projects/projects/{project_uuid}/members/{entity_uuid} | Addmembertoproject
*ProjectsApi* | [**archive_project**](docs/ProjectsApi.md#archive_project) | **DELETE** /sam/projects/projects/{project_uuid} | Archiveproject
*ProjectsApi* | [**create_project**](docs/ProjectsApi.md#create_project) | **POST** /sam/projects/projects | Createproject
*ProjectsApi* | [**create_project_key**](docs/ProjectsApi.md#create_project_key) | **POST** /sam/projects/projects/{project_uuid}/keys | Createprojectkey
*ProjectsApi* | [**create_usage_type**](docs/ProjectsApi.md#create_usage_type) | **POST** /sam/projects/usage/types | Createusagetype
*ProjectsApi* | [**delete_project_key**](docs/ProjectsApi.md#delete_project_key) | **DELETE** /sam/projects/projects/{project_uuid}/keys | Deleteprojectkey
*ProjectsApi* | [**delete_usage_type**](docs/ProjectsApi.md#delete_usage_type) | **DELETE** /sam/projects/usage/types/{usage_type_key} | Deleteusagetype
*ProjectsApi* | [**get_all_project_usage**](docs/ProjectsApi.md#get_all_project_usage) | **GET** /sam/projects/projects/{project_uuid}/usage | Getallprojectusage
*ProjectsApi* | [**get_member_projects**](docs/ProjectsApi.md#get_member_projects) | **GET** /sam/projects/members/{entity_uuid}/projects | Getmemberprojects
*ProjectsApi* | [**get_project**](docs/ProjectsApi.md#get_project) | **GET** /sam/projects/projects/{project_uuid} | Getproject
*ProjectsApi* | [**get_project_keys**](docs/ProjectsApi.md#get_project_keys) | **GET** /sam/projects/projects/{project_uuid}/keys | Getprojectkeys
*ProjectsApi* | [**get_project_members**](docs/ProjectsApi.md#get_project_members) | **GET** /sam/projects/projects/{project_uuid}/members | Getprojectmembers
*ProjectsApi* | [**get_specific_project_usage**](docs/ProjectsApi.md#get_specific_project_usage) | **GET** /sam/projects/projects/{project_uuid}/usage/{usage_type_key} | Getspecificprojectusage
*ProjectsApi* | [**get_usage_type**](docs/ProjectsApi.md#get_usage_type) | **GET** /sam/projects/usage/types/{usage_type_key} | Getusagetype
*ProjectsApi* | [**remove_member_from_project**](docs/ProjectsApi.md#remove_member_from_project) | **DELETE** /sam/projects/projects/{project_uuid}/members/{entity_uuid} | Removememberfromproject
*ProjectsApi* | [**search_projects**](docs/ProjectsApi.md#search_projects) | **GET** /sam/projects/projects | Searchprojects
*ProjectsApi* | [**search_usage_type**](docs/ProjectsApi.md#search_usage_type) | **GET** /sam/projects/usage/types | Searchusagetype
*ProjectsApi* | [**update_project**](docs/ProjectsApi.md#update_project) | **PUT** /sam/projects/projects/{project_uuid} | Updateproject
*ProjectsApi* | [**update_usage_type**](docs/ProjectsApi.md#update_usage_type) | **PUT** /sam/projects/usage/types/{usage_type_key} | Updateusagetype
*SecurityApi* | [**create_encryption_key**](docs/SecurityApi.md#create_encryption_key) | **POST** /sam/security/encryption/categories/{category}/keys | Createencryptionkey
*SecurityApi* | [**create_key**](docs/SecurityApi.md#create_key) | **POST** /sam/security/keys | Createkey
*SecurityApi* | [**delete_key**](docs/SecurityApi.md#delete_key) | **DELETE** /sam/security/keys/{key_uuid} | Deletekey
*SecurityApi* | [**generate_token**](docs/SecurityApi.md#generate_token) | **POST** /sam/security/tokens | Generatetoken
*SecurityApi* | [**get_encryption_key**](docs/SecurityApi.md#get_encryption_key) | **GET** /sam/security/encryption/categories/{category}/keys | Getencryptionkey
*SecurityApi* | [**get_key**](docs/SecurityApi.md#get_key) | **GET** /sam/security/keys/{key_uuid} | Getkey
*SecurityApi* | [**search_keys**](docs/SecurityApi.md#search_keys) | **GET** /sam/security/keys | Searchkeys
*SecurityApi* | [**verify_key**](docs/SecurityApi.md#verify_key) | **POST** /sam/security/keys/verify | Verifykey
*StaffApi* | [**create_staff_places_staff_post**](docs/StaffApi.md#create_staff_places_staff_post) | **POST** /places/staff | Create Staff
*StaffApi* | [**delete_staff_places_staff_staff_uuid_delete**](docs/StaffApi.md#delete_staff_places_staff_staff_uuid_delete) | **DELETE** /places/staff/{staff_uuid} | Delete Staff
*StaffApi* | [**get_staff_places_staff_staff_uuid_get**](docs/StaffApi.md#get_staff_places_staff_staff_uuid_get) | **GET** /places/staff/{staff_uuid} | Get Staff
*StaffApi* | [**search_staff_places_staff_get**](docs/StaffApi.md#search_staff_places_staff_get) | **GET** /places/staff | Search Staff
*StaffApi* | [**update_staff_places_staff_staff_uuid_put**](docs/StaffApi.md#update_staff_places_staff_staff_uuid_put) | **PUT** /places/staff/{staff_uuid} | Update Staff
*SupportApi* | [**create_contact**](docs/SupportApi.md#create_contact) | **POST** /sam/support/contact | Createcontact
*SupportApi* | [**create_ticket**](docs/SupportApi.md#create_ticket) | **POST** /sam/support/projects/{project_uuid}/members/{member_uuid}/tickets | Createticket
*SupportApi* | [**list_tickets**](docs/SupportApi.md#list_tickets) | **GET** /sam/support/projects/{project_uuid}/members/{member_uuid}/tickets | Listtickets
*SupportApi* | [**update_ticket**](docs/SupportApi.md#update_ticket) | **PUT** /sam/support/projects/{project_uuid}/members/{member_uuid}/tickets/{ticket_id} | Updateticket
*SupportApi* | [**view_ticket**](docs/SupportApi.md#view_ticket) | **GET** /sam/support/projects/{project_uuid}/members/{member_uuid}/tickets/{ticket_id} | Viewticket
*TagApi* | [**create_tag_places_tags_post**](docs/TagApi.md#create_tag_places_tags_post) | **POST** /places/tags | Create Tag
*TagApi* | [**delete_tag_places_tags_tag_uuid_delete**](docs/TagApi.md#delete_tag_places_tags_tag_uuid_delete) | **DELETE** /places/tags/{tag_uuid} | Delete Tag
*TagApi* | [**get_tag_places_tags_tag_uuid_get**](docs/TagApi.md#get_tag_places_tags_tag_uuid_get) | **GET** /places/tags/{tag_uuid} | Get Tag
*TagApi* | [**search_tags_places_tags_get**](docs/TagApi.md#search_tags_places_tags_get) | **GET** /places/tags | Search Tags
*TagApi* | [**update_tag_places_tags_tag_uuid_put**](docs/TagApi.md#update_tag_places_tags_tag_uuid_put) | **PUT** /places/tags/{tag_uuid} | Update Tag
*UsersApi* | [**confirm_signup**](docs/UsersApi.md#confirm_signup) | **POST** /sam/users/auth/signup/confirm | Confirmsignup
*UsersApi* | [**create_participant**](docs/UsersApi.md#create_participant) | **POST** /sam/users/participants | Createparticipant
*UsersApi* | [**create_user**](docs/UsersApi.md#create_user) | **POST** /sam/users | Createuser
*UsersApi* | [**delete_participant**](docs/UsersApi.md#delete_participant) | **DELETE** /sam/users/participants/{participant_id} | Deleteparticipant
*UsersApi* | [**delete_user**](docs/UsersApi.md#delete_user) | **DELETE** /sam/users/{user_id} | Deleteuser
*UsersApi* | [**get_participant**](docs/UsersApi.md#get_participant) | **GET** /sam/users/participants/{participant_id} | Getparticipant
*UsersApi* | [**get_user**](docs/UsersApi.md#get_user) | **GET** /sam/users/{user_id} | Getuser
*UsersApi* | [**login**](docs/UsersApi.md#login) | **POST** /sam/users/auth/login | Login
*UsersApi* | [**refresh_token**](docs/UsersApi.md#refresh_token) | **POST** /sam/users/auth/{app_client}/refresh-token | Refreshtoken
*UsersApi* | [**reset_password**](docs/UsersApi.md#reset_password) | **POST** /sam/users/auth/password/reset | Resetpassword
*UsersApi* | [**reset_password_confirmation**](docs/UsersApi.md#reset_password_confirmation) | **POST** /sam/users/auth/password/reset/confirm | Resetpasswordconfirmation
*UsersApi* | [**search_participants**](docs/UsersApi.md#search_participants) | **GET** /sam/users/participants | Searchparticipants
*UsersApi* | [**signup**](docs/UsersApi.md#signup) | **POST** /sam/users/auth/signup | Signup
*UsersApi* | [**update_participant**](docs/UsersApi.md#update_participant) | **PUT** /sam/users/participants/{participant_id} | Updateparticipant
*UsersApi* | [**update_user**](docs/UsersApi.md#update_user) | **PUT** /sam/users/{user_id} | Updateuser
*UsersApi* | [**user_validations**](docs/UsersApi.md#user_validations) | **POST** /sam/users/validations/{field} | Uservalidations

## Documentation For Models

 - [AddressBase](docs/AddressBase.md)
 - [AlarmAcknowledge](docs/AlarmAcknowledge.md)
 - [AlarmAssign](docs/AlarmAssign.md)
 - [AlarmCreate](docs/AlarmCreate.md)
 - [AlarmIgnore](docs/AlarmIgnore.md)
 - [AlarmNote](docs/AlarmNote.md)
 - [AlarmResponse](docs/AlarmResponse.md)
 - [AlarmTerminate](docs/AlarmTerminate.md)
 - [AlarmTicket](docs/AlarmTicket.md)
 - [AppointmentBase](docs/AppointmentBase.md)
 - [AppointmentResponse](docs/AppointmentResponse.md)
 - [AttachPaymentToProject](docs/AttachPaymentToProject.md)
 - [BasicMeta](docs/BasicMeta.md)
 - [BasicMetaCreate](docs/BasicMetaCreate.md)
 - [CatalogBase](docs/CatalogBase.md)
 - [CatalogReturn](docs/CatalogReturn.md)
 - [CategoryBase](docs/CategoryBase.md)
 - [CategoryDb](docs/CategoryDb.md)
 - [CompanyBase](docs/CompanyBase.md)
 - [CompanyResponse](docs/CompanyResponse.md)
 - [Contact](docs/Contact.md)
 - [ContactBase](docs/ContactBase.md)
 - [ContactMethod](docs/ContactMethod.md)
 - [ContactResponse](docs/ContactResponse.md)
 - [CreateKeyResponse](docs/CreateKeyResponse.md)
 - [CreateReview](docs/CreateReview.md)
 - [CreateTicket](docs/CreateTicket.md)
 - [CustomList](docs/CustomList.md)
 - [DatesMeta](docs/DatesMeta.md)
 - [DetailedMeta](docs/DetailedMeta.md)
 - [DetailedMetaCreate](docs/DetailedMetaCreate.md)
 - [Field](docs/Field.md)
 - [FieldDynamo](docs/FieldDynamo.md)
 - [GetServiceServiceWithSpecsResponse](docs/GetServiceServiceWithSpecsResponse.md)
 - [GetServiceSpecResponse](docs/GetServiceSpecResponse.md)
 - [GetServiceSpecsResponse](docs/GetServiceSpecsResponse.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [HeartbeatResponse](docs/HeartbeatResponse.md)
 - [KpiResponse](docs/KpiResponse.md)
 - [LoggingDynamo](docs/LoggingDynamo.md)
 - [MetaChildren](docs/MetaChildren.md)
 - [MetaCreate](docs/MetaCreate.md)
 - [MetaCustom](docs/MetaCustom.md)
 - [MetaDynamo](docs/MetaDynamo.md)
 - [MetaSlugger](docs/MetaSlugger.md)
 - [NoteBase](docs/NoteBase.md)
 - [NoteDynamo](docs/NoteDynamo.md)
 - [NoteDynamoHistory](docs/NoteDynamoHistory.md)
 - [NoteMeta](docs/NoteMeta.md)
 - [NotesHTTPValidationError](docs/NotesHTTPValidationError.md)
 - [NotesValidationError](docs/NotesValidationError.md)
 - [OptionGroup](docs/OptionGroup.md)
 - [Options](docs/Options.md)
 - [Page](docs/Page.md)
 - [Pagination](docs/Pagination.md)
 - [ParticipantCreate](docs/ParticipantCreate.md)
 - [ParticipantUpdate](docs/ParticipantUpdate.md)
 - [ParticipantUserReturn](docs/ParticipantUserReturn.md)
 - [Payment](docs/Payment.md)
 - [PaymentMethodResponse](docs/PaymentMethodResponse.md)
 - [PlaceBase](docs/PlaceBase.md)
 - [PlaceResponse](docs/PlaceResponse.md)
 - [ProductBase](docs/ProductBase.md)
 - [ProductReturn](docs/ProductReturn.md)
 - [ProjectDB](docs/ProjectDB.md)
 - [ProjectsProjectCreate](docs/ProjectsProjectCreate.md)
 - [ProjectsProjectGet](docs/ProjectsProjectGet.md)
 - [ProjectsProjectMemberDB](docs/ProjectsProjectMemberDB.md)
 - [ProjectsProjectUpdate](docs/ProjectsProjectUpdate.md)
 - [ProjectsProjectUsageDB](docs/ProjectsProjectUsageDB.md)
 - [ProjectsUsageTypeCreate](docs/ProjectsUsageTypeCreate.md)
 - [ProjectsUsageTypeDB](docs/ProjectsUsageTypeDB.md)
 - [ProjectsUsageTypeGet](docs/ProjectsUsageTypeGet.md)
 - [ProjectsUsageTypeUnitPrice](docs/ProjectsUsageTypeUnitPrice.md)
 - [ProjectsUsageTypeUpdate](docs/ProjectsUsageTypeUpdate.md)
 - [SecurityCreateToken](docs/SecurityCreateToken.md)
 - [SecurityEncryptionKeyGet](docs/SecurityEncryptionKeyGet.md)
 - [SecurityEncryptionKeyResponse](docs/SecurityEncryptionKeyResponse.md)
 - [SecurityKeyCreate](docs/SecurityKeyCreate.md)
 - [SecurityKeyGet](docs/SecurityKeyGet.md)
 - [SecurityKeyVerify](docs/SecurityKeyVerify.md)
 - [Selection](docs/Selection.md)
 - [ServiceCreate](docs/ServiceCreate.md)
 - [ServiceMessageResponse](docs/ServiceMessageResponse.md)
 - [ServiceResponse](docs/ServiceResponse.md)
 - [StaffCreate](docs/StaffCreate.md)
 - [StaffDb](docs/StaffDb.md)
 - [StaffResponse](docs/StaffResponse.md)
 - [StatsVitalsResponse](docs/StatsVitalsResponse.md)
 - [StripeAccountResponse](docs/StripeAccountResponse.md)
 - [StripeCustomerSecretResponse](docs/StripeCustomerSecretResponse.md)
 - [TagBase](docs/TagBase.md)
 - [TagDb](docs/TagDb.md)
 - [TicketResponse](docs/TicketResponse.md)
 - [TicketsResponse](docs/TicketsResponse.md)
 - [UpdateReview](docs/UpdateReview.md)
 - [User](docs/User.md)
 - [UserConfirmation](docs/UserConfirmation.md)
 - [UserEmail](docs/UserEmail.md)
 - [UserFlags](docs/UserFlags.md)
 - [UserLogin](docs/UserLogin.md)
 - [UserLoginReturn](docs/UserLoginReturn.md)
 - [UserPasswordReset](docs/UserPasswordReset.md)
 - [UserPasswordResetConfirmation](docs/UserPasswordResetConfirmation.md)
 - [UserResponse](docs/UserResponse.md)
 - [UserSignup](docs/UserSignup.md)
 - [UserSignupReturn](docs/UserSignupReturn.md)
 - [UserTokenReturn](docs/UserTokenReturn.md)
 - [UserValidations](docs/UserValidations.md)
 - [ValidationError](docs/ValidationError.md)
 - [Validations](docs/Validations.md)

## Documentation For Authorization

 All endpoints do not require authorization.

## Author

support@ehelply.com
support@ehelply.com
support@ehelply.com
support@ehelply.com
support@ehelply.com
support@ehelply.com
support@ehelply.com
support@ehelply.com
support@ehelply.com
support@ehelply.com
support@ehelply.com
support@ehelply.com
support@ehelply.com
support@ehelply.com
support@ehelply.com

## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in ehelply_python_sdk.apis and ehelply_python_sdk.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from ehelply_python_sdk.api.default_api import DefaultApi`
- `from ehelply_python_sdk.model.pet import Pet`

Solution 1:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import ehelply_python_sdk
from ehelply_python_sdk.apis import *
from ehelply_python_sdk.models import *
```
