/// <reference types="node" />
import { SpawnSyncOptions } from 'child_process';
/**
 * A parsed stack trace line
 */
export interface StackTrace {
    readonly file: string;
    readonly methodName?: string;
    readonly lineNumber: number;
    readonly column: number;
}
/**
 * Parses the stack trace of an error
 */
export declare function parseStackTrace(error?: Error): StackTrace[];
/**
 * Returns the major version of node installation
 */
export declare function nodeMajorVersion(): number;
/**
 * Find a file by walking up parent directories
 */
export declare function findUp(name: string, directory?: string): string | undefined;
/**
 * Spawn sync with error handling
 */
export declare function exec(cmd: string, args: string[], options?: SpawnSyncOptions): import("child_process").SpawnSyncReturns<Buffer>;
/**
 * Extract versions for a list of modules.
 *
 * First lookup the version in the package.json and then fallback to requiring
 * the module's package.json. The fallback is needed for transitive dependencies.
 */
export declare function extractDependencies(pkgPath: string, modules: string[]): {
    [key: string]: string;
};
/**
 * Returns the installed esbuild version
 */
export declare function getEsBuildVersion(): string | undefined;
export declare enum LockFile {
    NPM = "package-lock.json",
    YARN = "yarn.lock"
}
