"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubCustomResource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const provider_1 = require("./custom-resource-provider/provider");
/**
 * ```typescript
 * const secret = secrets_manager.Secret.fromSecretNameV2(scope, "Auth", "cdk-github/test");
 *
 * new GithubCustomResource(scope, "GithubRepo", {
 *   onCreate: {
 *     // https://octokit.github.io/rest.js/v19/#repos-create-in-org
 *     endpoint: "repos",
 *     method: "createInOrg",
 *     parameters: {
 *       org: "pepperize",
 *       name: "cdk-github",
 *     },
 *     outputPaths: ["id", "full_name"],
 *     physicalResourceId: custom_resources.PhysicalResourceId.fromResponse("full_name"),
 *     ignoreErrorCodesMatching: "name already exists on this account",
 *   },
 *   onUpdate: {
 *     // https://octokit.github.io/rest.js/v19#repos-get
 *     endpoint: "repos",
 *     method: "get",
 *     parameters: {
 *       owner: "pepperize",
 *       repo: "cdk-github",
 *     },
 *     outputPaths: ["id", "full_name"],
 *     physicalResourceId: custom_resources.PhysicalResourceId.fromResponse("full_name"),
 *   },
 *   onDelete: {
 *     // https://octokit.github.io/rest.js/v19#repos-delete
 *     endpoint: "repos",
 *     method: "delete",
 *     parameters: {
 *       owner: "pepperize",
 *       repo: "cdk-github",
 *     },
 *     outputPaths: [],
 *   },
 *   authOptions: AuthOptions.appAuth(secret),
 * });
 * ```
 */
class GithubCustomResource extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const provider = provider_1.GithubCustomResourceProvider.getOrCreate(this);
        const authOptions = props.authOptions;
        authOptions._grantRead(provider);
        this.resource = new aws_cdk_lib_1.CustomResource(this, "Resource", {
            serviceToken: provider.serviceToken,
            resourceType: props.resourceType,
            properties: {
                Create: props.onCreate && aws_cdk_lib_1.Lazy.uncachedString({ produce: () => aws_cdk_lib_1.Stack.of(this).toJsonString(props.onCreate) }),
                Update: props.onUpdate && aws_cdk_lib_1.Lazy.uncachedString({ produce: () => aws_cdk_lib_1.Stack.of(this).toJsonString(props.onUpdate) }),
                Delete: props.onDelete && aws_cdk_lib_1.Lazy.uncachedString({ produce: () => aws_cdk_lib_1.Stack.of(this).toJsonString(props.onDelete) }),
                Auth: props.authOptions._auth,
            },
        });
    }
    /**
     * The physical name of this custom resource.
     */
    get ref() {
        return this.resource.ref;
    }
    /**
     * Returns the value of an attribute of the custom resource of an arbitrary
     * type. Attributes are returned from the custom resource provider through the
     * `Data` map where the key is the attribute name.
     *
     * @param attributeName the name of the attribute
     * @returns a token for `Fn::GetAtt`. Use `Token.asXxx` to encode the returned `Reference` as a specific type or
     * use the convenience `getAttString` for string attributes.
     */
    getAtt(attributeName) {
        return this.resource.getAtt(attributeName);
    }
    /**
     * Returns the value of an attribute of the custom resource of type string.
     * Attributes are returned from the custom resource provider through the
     * `Data` map where the key is the attribute name.
     *
     * @param attributeName the name of the attribute
     * @returns a token for `Fn::GetAtt` encoded as a string.
     */
    getAttString(attributeName) {
        return this.resource.getAttString(attributeName);
    }
}
exports.GithubCustomResource = GithubCustomResource;
_a = JSII_RTTI_SYMBOL_1;
GithubCustomResource[_a] = { fqn: "@pepperize/cdk-github.GithubCustomResource", version: "0.0.76" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2l0aHViLWN1c3RvbS1yZXNvdXJjZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9naXRodWItY3VzdG9tLXJlc291cmNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkNBQXFFO0FBRXJFLDJDQUF1QztBQUV2QyxrRUFBbUY7QUE4RW5GOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztHQXlDRztBQUNILE1BQWEsb0JBQXFCLFNBQVEsc0JBQVM7SUFFakQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFnQztRQUN4RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sUUFBUSxHQUFHLHVDQUE0QixDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUNoRSxNQUFNLFdBQVcsR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDO1FBQ3RDLFdBQVcsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUM7UUFFakMsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLDRCQUFjLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNuRCxZQUFZLEVBQUUsUUFBUSxDQUFDLFlBQVk7WUFDbkMsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZO1lBQ2hDLFVBQVUsRUFBRTtnQkFDVixNQUFNLEVBQUUsS0FBSyxDQUFDLFFBQVEsSUFBSSxrQkFBSSxDQUFDLGNBQWMsQ0FBQyxFQUFFLE9BQU8sRUFBRSxHQUFHLEVBQUUsQ0FBQyxtQkFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxFQUFFLENBQUM7Z0JBQzdHLE1BQU0sRUFBRSxLQUFLLENBQUMsUUFBUSxJQUFJLGtCQUFJLENBQUMsY0FBYyxDQUFDLEVBQUUsT0FBTyxFQUFFLEdBQUcsRUFBRSxDQUFDLG1CQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLEVBQUUsQ0FBQztnQkFDN0csTUFBTSxFQUFFLEtBQUssQ0FBQyxRQUFRLElBQUksa0JBQUksQ0FBQyxjQUFjLENBQUMsRUFBRSxPQUFPLEVBQUUsR0FBRyxFQUFFLENBQUMsbUJBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsRUFBRSxDQUFDO2dCQUM3RyxJQUFJLEVBQUUsS0FBSyxDQUFDLFdBQVcsQ0FBQyxLQUFLO2FBQzlCO1NBQ0YsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUNEOztPQUVHO0lBQ0gsSUFBSSxHQUFHO1FBQ0wsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQztJQUMzQixDQUFDO0lBQ0Q7Ozs7Ozs7O09BUUc7SUFDSCxNQUFNLENBQUMsYUFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBQ0Q7Ozs7Ozs7T0FPRztJQUNILFlBQVksQ0FBQyxhQUFxQjtRQUNoQyxPQUFPLElBQUksQ0FBQyxRQUFRLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ25ELENBQUM7O0FBaERILG9EQWlEQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEN1c3RvbVJlc291cmNlLCBMYXp5LCBSZWZlcmVuY2UsIFN0YWNrIH0gZnJvbSBcImF3cy1jZGstbGliXCI7XG5pbXBvcnQgKiBhcyBjdXN0b21fcmVzb3VyY2VzIGZyb20gXCJhd3MtY2RrLWxpYi9jdXN0b20tcmVzb3VyY2VzXCI7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tIFwiY29uc3RydWN0c1wiO1xuaW1wb3J0IHsgSUF1dGhPcHRpb25zIH0gZnJvbSBcIi4vYXV0aFwiO1xuaW1wb3J0IHsgR2l0aHViQ3VzdG9tUmVzb3VyY2VQcm92aWRlciB9IGZyb20gXCIuL2N1c3RvbS1yZXNvdXJjZS1wcm92aWRlci9wcm92aWRlclwiO1xuXG5leHBvcnQgaW50ZXJmYWNlIEdpdGh1YkFwaUNhbGwge1xuICAvKipcbiAgICogVGhlIGVuZHBvaW50IHRvIGNhbGwuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9naXRodWIuY29tL29jdG9raXQvcmVzdC5qc1xuICAgKi9cbiAgcmVhZG9ubHkgZW5kcG9pbnQ6IHN0cmluZztcbiAgLyoqXG4gICAqIFRoZSBtZXRob2QgdG8gY2FsbC5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2dpdGh1Yi5jb20vb2N0b2tpdC9yZXN0LmpzXG4gICAqL1xuICByZWFkb25seSBtZXRob2Q6IHN0cmluZztcbiAgLyoqXG4gICAqIFRoZSBwYXJhbWV0ZXJzIGZvciB0aGUgc2VydmljZSBhY3Rpb24uXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9naXRodWIuY29tL29jdG9raXQvcmVzdC5qc1xuICAgKi9cbiAgcmVhZG9ubHkgcGFyYW1ldGVycz86IGFueTtcbiAgLyoqXG4gICAqIFRoZSBwaHlzaWNhbCByZXNvdXJjZSBpZCBvZiB0aGUgY3VzdG9tIHJlc291cmNlIGZvciB0aGlzIGNhbGwuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvY3JwZy1yZWYtcmVzcG9uc2VzLmh0bWxcbiAgICpcbiAgICogQGRlZmF1bHQgdW5kZWZpbmVkIC0gZm9yIFwiQ3JlYXRlXCIgcmVxdWVzdHMsIGRlZmF1bHRzIHRvIHRoZSBldmVudCdzIFJlcXVlc3RJZCwgZm9yIFwiVXBkYXRlXCIgYW5kIFwiRGVsZXRlXCIsIGRlZmF1bHRzIHRvIHRoZSBjdXJyZW50IGBQaHlzaWNhbFJlc291cmNlSWRgLlxuICAgKi9cbiAgcmVhZG9ubHkgcGh5c2ljYWxSZXNvdXJjZUlkPzogY3VzdG9tX3Jlc291cmNlcy5QaHlzaWNhbFJlc291cmNlSWQ7XG4gIC8qKlxuICAgKiBUaGUgcmVnZXggcGF0dGVybiB0byB1c2UgdG8gY2F0Y2ggQVBJIGVycm9ycy4gVGhlIGBtZXNzYWdlYCBwcm9wZXJ0eSBvZiB0aGUgYFJlcXVlc3RFcnJvcmAgb2JqZWN0IHdpbGwgYmUgdGVzdGVkIGFnYWluc3QgdGhpcyBwYXR0ZXJuLiBJZiB0aGVyZSBpcyBhIG1hdGNoIGFuIGVycm9yIHdpbGwgbm90IGJlIHRocm93bi5cbiAgICovXG4gIHJlYWRvbmx5IGlnbm9yZUVycm9yQ29kZXNNYXRjaGluZz86IHN0cmluZztcbiAgLyoqXG4gICAqIEZpbHRlciB0aGUgZGF0YSByZXR1cm5lZCBieSB0aGUgY3VzdG9tIHJlc291cmNlIHRvIHNwZWNpZmljIHBhdGhzIGluIHRoZSBBUEkgcmVzcG9uc2UuXG4gICAqXG4gICAqIDxiPlRoZSB0b3RhbCBzaXplIG9mIHRoZSByZXNwb25zZSBib2R5IGNhbid0IGV4Y2VlZCA0MDk2IGJ5dGVzLjwvYj5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9jcnBnLXJlZi1yZXNwb25zZXMuaHRtbFxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5naXRodWIuY29tL2VuL3Jlc3RcbiAgICpcbiAgICogRXhhbXBsZSBmb3Igb2N0b2tpdC5yZXN0LnJlcG9zLmNyZWF0ZUluT3JnOiBbJ2lkJywgJ2Z1bGxfbmFtZScsICdvd25lci5pZCddXG4gICAqXG4gICAqIEBkZWZhdWx0IHVuZGVmaW5lZCAtIGl0J3MgcmVjb21tZW5kZWQgdG8gZGVmaW5lIGl0XG4gICAqL1xuICByZWFkb25seSBvdXRwdXRQYXRocz86IHN0cmluZ1tdO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIEdpdGh1YkN1c3RvbVJlc291cmNlUHJvcHMge1xuICAvKipcbiAgICogQ2xvdWRmb3JtYXRpb24gUmVzb3VyY2UgdHlwZS5cbiAgICovXG4gIHJlYWRvbmx5IHJlc291cmNlVHlwZT86IHN0cmluZztcbiAgLyoqXG4gICAqIFRoZSBHaXRIdWIgQXBpIGNhbGwgdG8gbWFrZSB3aGVuIHRoZSByZXNvdXJjZSBpcyBjcmVhdGVkLlxuICAgKi9cbiAgcmVhZG9ubHkgb25DcmVhdGU/OiBHaXRodWJBcGlDYWxsO1xuICAvKipcbiAgICogVGhlIEdpdEh1YiBBcGkgY2FsbCB0byBtYWtlIHdoZW4gdGhlIHJlc291cmNlIGlzIHVwZGF0ZWQuXG4gICAqL1xuICByZWFkb25seSBvblVwZGF0ZT86IEdpdGh1YkFwaUNhbGw7XG4gIC8qKlxuICAgKiBUaGUgR2l0SHViIEFwaSBjYWxsIHRvIG1ha2Ugd2hlbiB0aGUgcmVzb3VyY2UgaXMgZGVsZXRlZC5cbiAgICovXG4gIHJlYWRvbmx5IG9uRGVsZXRlPzogR2l0aHViQXBpQ2FsbDtcbiAgLyoqXG4gICAqIEN1cnJlbnRseSwgc3VwcG9ydHMgb25seSBHaXRIdWIgQXBwLlxuICAgKlxuICAgKiBgYGB0eXBlc2NyaXB0XG4gICAqIGNvbnN0IGF1dGggPSB7IGFwcElkLCBwcml2YXRlS2V5IH07XG4gICAqIGNvbnN0IGluc3RhbGxhdGlvbkF1dGggPSB7IGFwcElkLCBwcml2YXRlS2V5LCBpbnN0YWxsYXRpb25JZCB9O1xuICAgKiBgYGBcbiAgICpcbiAgICogQHNlZSBodHRwczovL2dpdGh1Yi5jb20vb2N0b2tpdC9hdXRoZW50aWNhdGlvbi1zdHJhdGVnaWVzLmpzLyNnaXRodWItYXBwLW9yLWluc3RhbGxhdGlvbi1hdXRoZW50aWNhdGlvblxuICAgKi9cbiAgcmVhZG9ubHkgYXV0aE9wdGlvbnM6IElBdXRoT3B0aW9ucztcbn1cblxuLyoqXG4gKiBgYGB0eXBlc2NyaXB0XG4gKiBjb25zdCBzZWNyZXQgPSBzZWNyZXRzX21hbmFnZXIuU2VjcmV0LmZyb21TZWNyZXROYW1lVjIoc2NvcGUsIFwiQXV0aFwiLCBcImNkay1naXRodWIvdGVzdFwiKTtcbiAqXG4gKiBuZXcgR2l0aHViQ3VzdG9tUmVzb3VyY2Uoc2NvcGUsIFwiR2l0aHViUmVwb1wiLCB7XG4gKiAgIG9uQ3JlYXRlOiB7XG4gKiAgICAgLy8gaHR0cHM6Ly9vY3Rva2l0LmdpdGh1Yi5pby9yZXN0LmpzL3YxOS8jcmVwb3MtY3JlYXRlLWluLW9yZ1xuICogICAgIGVuZHBvaW50OiBcInJlcG9zXCIsXG4gKiAgICAgbWV0aG9kOiBcImNyZWF0ZUluT3JnXCIsXG4gKiAgICAgcGFyYW1ldGVyczoge1xuICogICAgICAgb3JnOiBcInBlcHBlcml6ZVwiLFxuICogICAgICAgbmFtZTogXCJjZGstZ2l0aHViXCIsXG4gKiAgICAgfSxcbiAqICAgICBvdXRwdXRQYXRoczogW1wiaWRcIiwgXCJmdWxsX25hbWVcIl0sXG4gKiAgICAgcGh5c2ljYWxSZXNvdXJjZUlkOiBjdXN0b21fcmVzb3VyY2VzLlBoeXNpY2FsUmVzb3VyY2VJZC5mcm9tUmVzcG9uc2UoXCJmdWxsX25hbWVcIiksXG4gKiAgICAgaWdub3JlRXJyb3JDb2Rlc01hdGNoaW5nOiBcIm5hbWUgYWxyZWFkeSBleGlzdHMgb24gdGhpcyBhY2NvdW50XCIsXG4gKiAgIH0sXG4gKiAgIG9uVXBkYXRlOiB7XG4gKiAgICAgLy8gaHR0cHM6Ly9vY3Rva2l0LmdpdGh1Yi5pby9yZXN0LmpzL3YxOSNyZXBvcy1nZXRcbiAqICAgICBlbmRwb2ludDogXCJyZXBvc1wiLFxuICogICAgIG1ldGhvZDogXCJnZXRcIixcbiAqICAgICBwYXJhbWV0ZXJzOiB7XG4gKiAgICAgICBvd25lcjogXCJwZXBwZXJpemVcIixcbiAqICAgICAgIHJlcG86IFwiY2RrLWdpdGh1YlwiLFxuICogICAgIH0sXG4gKiAgICAgb3V0cHV0UGF0aHM6IFtcImlkXCIsIFwiZnVsbF9uYW1lXCJdLFxuICogICAgIHBoeXNpY2FsUmVzb3VyY2VJZDogY3VzdG9tX3Jlc291cmNlcy5QaHlzaWNhbFJlc291cmNlSWQuZnJvbVJlc3BvbnNlKFwiZnVsbF9uYW1lXCIpLFxuICogICB9LFxuICogICBvbkRlbGV0ZToge1xuICogICAgIC8vIGh0dHBzOi8vb2N0b2tpdC5naXRodWIuaW8vcmVzdC5qcy92MTkjcmVwb3MtZGVsZXRlXG4gKiAgICAgZW5kcG9pbnQ6IFwicmVwb3NcIixcbiAqICAgICBtZXRob2Q6IFwiZGVsZXRlXCIsXG4gKiAgICAgcGFyYW1ldGVyczoge1xuICogICAgICAgb3duZXI6IFwicGVwcGVyaXplXCIsXG4gKiAgICAgICByZXBvOiBcImNkay1naXRodWJcIixcbiAqICAgICB9LFxuICogICAgIG91dHB1dFBhdGhzOiBbXSxcbiAqICAgfSxcbiAqICAgYXV0aE9wdGlvbnM6IEF1dGhPcHRpb25zLmFwcEF1dGgoc2VjcmV0KSxcbiAqIH0pO1xuICogYGBgXG4gKi9cbmV4cG9ydCBjbGFzcyBHaXRodWJDdXN0b21SZXNvdXJjZSBleHRlbmRzIENvbnN0cnVjdCB7XG4gIHByaXZhdGUgcmVhZG9ubHkgcmVzb3VyY2U6IEN1c3RvbVJlc291cmNlO1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogR2l0aHViQ3VzdG9tUmVzb3VyY2VQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBjb25zdCBwcm92aWRlciA9IEdpdGh1YkN1c3RvbVJlc291cmNlUHJvdmlkZXIuZ2V0T3JDcmVhdGUodGhpcyk7XG4gICAgY29uc3QgYXV0aE9wdGlvbnMgPSBwcm9wcy5hdXRoT3B0aW9ucztcbiAgICBhdXRoT3B0aW9ucy5fZ3JhbnRSZWFkKHByb3ZpZGVyKTtcblxuICAgIHRoaXMucmVzb3VyY2UgPSBuZXcgQ3VzdG9tUmVzb3VyY2UodGhpcywgXCJSZXNvdXJjZVwiLCB7XG4gICAgICBzZXJ2aWNlVG9rZW46IHByb3ZpZGVyLnNlcnZpY2VUb2tlbixcbiAgICAgIHJlc291cmNlVHlwZTogcHJvcHMucmVzb3VyY2VUeXBlLFxuICAgICAgcHJvcGVydGllczoge1xuICAgICAgICBDcmVhdGU6IHByb3BzLm9uQ3JlYXRlICYmIExhenkudW5jYWNoZWRTdHJpbmcoeyBwcm9kdWNlOiAoKSA9PiBTdGFjay5vZih0aGlzKS50b0pzb25TdHJpbmcocHJvcHMub25DcmVhdGUpIH0pLFxuICAgICAgICBVcGRhdGU6IHByb3BzLm9uVXBkYXRlICYmIExhenkudW5jYWNoZWRTdHJpbmcoeyBwcm9kdWNlOiAoKSA9PiBTdGFjay5vZih0aGlzKS50b0pzb25TdHJpbmcocHJvcHMub25VcGRhdGUpIH0pLFxuICAgICAgICBEZWxldGU6IHByb3BzLm9uRGVsZXRlICYmIExhenkudW5jYWNoZWRTdHJpbmcoeyBwcm9kdWNlOiAoKSA9PiBTdGFjay5vZih0aGlzKS50b0pzb25TdHJpbmcocHJvcHMub25EZWxldGUpIH0pLFxuICAgICAgICBBdXRoOiBwcm9wcy5hdXRoT3B0aW9ucy5fYXV0aCxcbiAgICAgIH0sXG4gICAgfSk7XG4gIH1cbiAgLyoqXG4gICAqIFRoZSBwaHlzaWNhbCBuYW1lIG9mIHRoaXMgY3VzdG9tIHJlc291cmNlLlxuICAgKi9cbiAgZ2V0IHJlZigpOiBzdHJpbmcge1xuICAgIHJldHVybiB0aGlzLnJlc291cmNlLnJlZjtcbiAgfVxuICAvKipcbiAgICogUmV0dXJucyB0aGUgdmFsdWUgb2YgYW4gYXR0cmlidXRlIG9mIHRoZSBjdXN0b20gcmVzb3VyY2Ugb2YgYW4gYXJiaXRyYXJ5XG4gICAqIHR5cGUuIEF0dHJpYnV0ZXMgYXJlIHJldHVybmVkIGZyb20gdGhlIGN1c3RvbSByZXNvdXJjZSBwcm92aWRlciB0aHJvdWdoIHRoZVxuICAgKiBgRGF0YWAgbWFwIHdoZXJlIHRoZSBrZXkgaXMgdGhlIGF0dHJpYnV0ZSBuYW1lLlxuICAgKlxuICAgKiBAcGFyYW0gYXR0cmlidXRlTmFtZSB0aGUgbmFtZSBvZiB0aGUgYXR0cmlidXRlXG4gICAqIEByZXR1cm5zIGEgdG9rZW4gZm9yIGBGbjo6R2V0QXR0YC4gVXNlIGBUb2tlbi5hc1h4eGAgdG8gZW5jb2RlIHRoZSByZXR1cm5lZCBgUmVmZXJlbmNlYCBhcyBhIHNwZWNpZmljIHR5cGUgb3JcbiAgICogdXNlIHRoZSBjb252ZW5pZW5jZSBgZ2V0QXR0U3RyaW5nYCBmb3Igc3RyaW5nIGF0dHJpYnV0ZXMuXG4gICAqL1xuICBnZXRBdHQoYXR0cmlidXRlTmFtZTogc3RyaW5nKTogUmVmZXJlbmNlIHtcbiAgICByZXR1cm4gdGhpcy5yZXNvdXJjZS5nZXRBdHQoYXR0cmlidXRlTmFtZSk7XG4gIH1cbiAgLyoqXG4gICAqIFJldHVybnMgdGhlIHZhbHVlIG9mIGFuIGF0dHJpYnV0ZSBvZiB0aGUgY3VzdG9tIHJlc291cmNlIG9mIHR5cGUgc3RyaW5nLlxuICAgKiBBdHRyaWJ1dGVzIGFyZSByZXR1cm5lZCBmcm9tIHRoZSBjdXN0b20gcmVzb3VyY2UgcHJvdmlkZXIgdGhyb3VnaCB0aGVcbiAgICogYERhdGFgIG1hcCB3aGVyZSB0aGUga2V5IGlzIHRoZSBhdHRyaWJ1dGUgbmFtZS5cbiAgICpcbiAgICogQHBhcmFtIGF0dHJpYnV0ZU5hbWUgdGhlIG5hbWUgb2YgdGhlIGF0dHJpYnV0ZVxuICAgKiBAcmV0dXJucyBhIHRva2VuIGZvciBgRm46OkdldEF0dGAgZW5jb2RlZCBhcyBhIHN0cmluZy5cbiAgICovXG4gIGdldEF0dFN0cmluZyhhdHRyaWJ1dGVOYW1lOiBzdHJpbmcpOiBzdHJpbmcge1xuICAgIHJldHVybiB0aGlzLnJlc291cmNlLmdldEF0dFN0cmluZyhhdHRyaWJ1dGVOYW1lKTtcbiAgfVxufVxuIl19