# coding=utf-8
# +----------------------------------------------------------------------+
# | 波特智控 [ 以价值驱动应用, 以AI赋能控制, 让流程工业从稳态迈向自优化 ]          |
# +----------------------------------------------------------------------+
# | Copyright (c) 2020~2025 https://www.sdqbtech.com All rights reserved.|
# +----------------------------------------------------------------------+
# | Licensed 波特智控并不是自由软件，未经许可不得使用                           |
# +----------------------------------------------------------------------+
# | Author: 波特智控研究团队 <bodecontrol-team@sdqbtech.com>                |
# +----------------------------------------------------------------------+


from __future__ import annotations

import sys
import warnings


def ensure_python_version(major, minor) -> None:
    vi = sys.version_info  # namedtuple: major, minor, micro, releaselevel, serial
    required = (major, minor)

    if (vi.major, vi.minor) < required:
        raise RuntimeError(
            f"需要 Python 3.12.x，当前为 {vi.major}.{vi.minor}.{vi.micro}({vi.releaselevel})。请升级后重试。"
        )

    if (vi.major, vi.minor) > required:
        warnings.warn(
            f"检测到 Python {vi.major}.{vi.minor}.{vi.micro}，高于已验证版本 3.12.x；"
            "请进行完整回归测试以确认兼容性。",
            category=RuntimeWarning,
            stacklevel=2,  # 将警告定位到调用方
        )

def ensure_python_312() -> None:
    ensure_python_version(major=3, minor=12)
