# coding=utf-8
# +----------------------------------------------------------------------+
# | 波特智控 [ 以价值驱动应用, 以AI赋能控制, 让流程工业从稳态迈向自优化 ]          |
# +----------------------------------------------------------------------+
# | Copyright (c) 2020~2025 https://www.sdqbtech.com All rights reserved.|
# +----------------------------------------------------------------------+
# | Licensed 波特智控并不是自由软件，未经许可不得使用                           |
# +----------------------------------------------------------------------+
# | Author: 波特智控研究团队 <bodecontrol-team@sdqbtech.com>                |
# +----------------------------------------------------------------------+


import importlib
from loguru import logger

from qbtools.task.admin import TaskAdmin

def run_task(class_path: str,
             method: str = "start",
             init_kwargs: dict | None = None,
             call_kwargs: dict | None = None,
             job_id: str | None = None):
    """
    统一入口：进程/线程池都会调用这里。
    - class_path: "pkg.mod:ClsName"
    - method:    任务实例要调用的方法，默认 'start'
    """
    if init_kwargs is None:
        init_kwargs = {}
    if call_kwargs is None:
        call_kwargs = {}

    mod_path, _, cls_name = class_path.partition(":")
    cls = getattr(importlib.import_module(mod_path), cls_name)
    obj = cls(**init_kwargs)
    TaskAdmin._register_task_instance(job_id, obj)

    logger.debug(f"开始执行任务[{cls_name}], 函数:{method}")
    desc = getattr(obj, "desc", "")
    if desc:
        logger.info(f"任务[{cls_name}] - {desc} 开始执行")
    try:
        return getattr(obj, method)(**call_kwargs)
    finally:
        TaskAdmin._unregister_task_instance(job_id)
