# coding=utf-8
# +----------------------------------------------------------------------+
# | 波特智控 [ 以价值驱动应用, 以AI赋能控制, 让流程工业从稳态迈向自优化 ]          |
# +----------------------------------------------------------------------+
# | Copyright (c) 2020~2025 https://www.sdqbtech.com All rights reserved.|
# +----------------------------------------------------------------------+
# | Licensed 波特智控并不是自由软件，未经许可不得使用                           |
# +----------------------------------------------------------------------+
# | Author: 波特智控研究团队 <bodecontrol-team@sdqbtech.com>                |
# +----------------------------------------------------------------------+


from matplotlib import rcParams
from matplotlib import font_manager as fm
from pathlib import Path

def load_font_support(font_path):
    if not Path(font_path).exists():
        raise Exception(f"{font_path} not found.")
    fm.fontManager.addfont(font_path)
    my_font = fm.FontProperties(fname=font_path)
    rcParams['font.sans-serif'] = my_font.get_name()
    rcParams['font.family'] = my_font.get_name()
    rcParams['axes.unicode_minus'] = False  # 解决负号 '-' 显示为方块的问题
