# coding=utf-8
# +----------------------------------------------------------------------+
# | 波特智控 [ 以价值驱动应用, 以AI赋能控制, 让流程工业从稳态迈向自优化 ]          |
# +----------------------------------------------------------------------+
# | Copyright (c) 2020~2025 https://www.sdqbtech.com All rights reserved.|
# +----------------------------------------------------------------------+
# | Licensed 波特智控并不是自由软件，未经许可不得使用                           |
# +----------------------------------------------------------------------+
# | Author: 波特智控研究团队 <bodecontrol-team@sdqbtech.com>                |
# +----------------------------------------------------------------------+


from dataclasses import dataclass, field
from typing import List


class CardStatus():
    CONFIRMED = "confirmed"
    REJECT = "reject"
    PLC_WRITE_DONE = "plc_write_done"
    PLC_WRITE_FAIL = "plc_write_fail"
    TIMEOUT = "timeout"
    NULL = ""


class CardAction():
    REJECT = "reject"
    CONFIRM = "confirm"


@dataclass
class CheckItem:
    value: str
    text: str
    checked: bool


@dataclass
class CardParamMap:
    pass


@dataclass
class PlcCardParams(CardParamMap):
    need_user_num: int | None = None
    tagname: str | None = None
    checkboxItems: List[CheckItem] | None = None
    createTime: str | None = None
    processedTime: str | None = None
    ddlTime: str | None = None
    users: str | None = None
    status: str | None = None
    sub_title: str | None = None
    err_desc: str | None = None


@dataclass
class PlcUserData(CardParamMap):
    user_status: str | None = None
    user_checked: str | None = None


@dataclass
class CardUpdateOptions:
    updateCardDataByKey: bool = True
    updatePrivateDataByKey: bool = True


@dataclass
class RespCardData:
    cardParamMap: dict = field(default_factory=lambda: {})


@dataclass
class CardResponse:
    cardData: RespCardData
    userPrivateData: RespCardData = field(default_factory=lambda: RespCardData())
    userIdType: int = 1
    cardUpdateOptions: CardUpdateOptions = field(default_factory=lambda: CardUpdateOptions())
