# coding=utf-8
# +----------------------------------------------------------------------+
# | 波特智控 [ 以价值驱动应用, 以AI赋能控制, 让流程工业从稳态迈向自优化 ]          |
# +----------------------------------------------------------------------+
# | Copyright (c) 2020~2025 https://www.sdqbtech.com All rights reserved.|
# +----------------------------------------------------------------------+
# | Licensed 波特智控并不是自由软件，未经许可不得使用                           |
# +----------------------------------------------------------------------+
# | Author: 波特智控研究团队 <bodecontrol-team@sdqbtech.com>                |
# +----------------------------------------------------------------------+


import time
from datetime import datetime

import dingtalk_stream
from loguru import logger
from qbtools import get_p_time
from qbtools.task import BaseTask, TaskAdmin

from app import CACHE
from app import PROJCONF
from app.cdq.helpers.notification.dingtalk.handler import ChatBotSampleHandler
from app.cdq.helpers.notification.dingtalk.handler import PLCCardCallbackHandler
from app.cdq.helpers.notification.dingtalk.tool import DingtalkQingboRobot
from app.cdq.helpers.notification.dingtalk.types import CardStatus, PlcCardParams


@TaskAdmin.register()
class DingtalkRobotTask(BaseTask):
    def __init__(self):
        super().__init__()

    def clear_expired_card(self):
        default_robot_service = DingtalkQingboRobot()
        client = CACHE.message_sync.client.get_client(write=False)  # 拿到底层 redis-py 实例
        pattern = f'*:plcchangeinform.*'
        while self.is_alive:
            try:
                for raw_key in client.scan_iter(match=pattern):  # scan_iter 默认 count=10
                    key = raw_key.decode().split(":")[-1]
                    car_param = CACHE.message_sync.get(key)
                    status = car_param["status"]

                    if datetime.now() < get_p_time(car_param["ddlTime"]):
                        continue

                    logger.debug(f"删除超过时间的key: {key}")
                    CACHE.message_sync.delete(key)

                    # 已人工处理, 不需要更新卡片为超时状态
                    if status != "":
                        continue
                    default_robot_service.update_card(
                        out_track_id=key,
                        card_param=PlcCardParams(status=CardStatus.TIMEOUT),
                    )
                    logger.debug(f"update_card out_track_id: {key}")

            except Exception as e:
                logger.exception(e)
            time.sleep(1)

    def stop(self):
        self.stoped_event.set()

    def run(self):
        client_id = PROJCONF.dingding.app_key
        client_secret = PROJCONF.dingding.app_secret

        credential = dingtalk_stream.Credential(client_id=client_id, client_secret=client_secret)
        client = dingtalk_stream.DingTalkStreamClient(credential)
        client.register_callback_handler(dingtalk_stream.ChatbotMessage.TOPIC, ChatBotSampleHandler())

        client.register_callback_handler(
            dingtalk_stream.CallbackHandler.TOPIC_CARD_CALLBACK, PLCCardCallbackHandler(cache=CACHE.message_sync)
        )
        client.start_forever()
