import time

from loguru import logger
from qbtools import datacls

from ..tool import DingtalkQingboRobot
from ..types import CheckItem, PlcCardParams, CardResponse, CardStatus


def test_01():
    robot_service = DingtalkQingboRobot()
    opt_list = [CheckItem(value="kdll", text="空导流量: 23 --> 243", checked=False),
                CheckItem(value="xhf", text="循环风量: 123 --> 2323", checked=False),
                CheckItem(value="zf", text="振幅: 32 --> 12", checked=False),
                ]
    timeout = 20
    card_tracker = robot_service.send_plccard_message(opt_list=opt_list, timeout=timeout, need_user_num=1)
    result = card_tracker.wait_for_confirm(timeout=timeout)
    if not result:
        logger.warning("超时了")
        return
    card_resp: CardResponse = datacls.from_dict(CardResponse, result)
    card_params = datacls.from_dict(PlcCardParams, card_resp.cardData.cardParamMap)

    status = card_params.status
    if status != CardStatus.CONFIRMED:
        logger.error("没有确认")
        return
    # 假设向plc写入成功
    time.sleep(3)
    logger.info("写入plc成功")
    robot_service.update_card(
        out_track_id=card_tracker.out_track_id,
        card_param=PlcCardParams(status=CardStatus.PLC_WRITE_DONE))


if __name__ == "__main__":
    while True:
        test_01()
        time.sleep(10)
