# coding=utf-8
# +----------------------------------------------------------------------+
# | 波特智控 [ 以价值驱动应用, 以AI赋能控制, 让流程工业从稳态迈向自优化 ]          |
# +----------------------------------------------------------------------+
# | Copyright (c) 2020~2025 https://www.sdqbtech.com All rights reserved.|
# +----------------------------------------------------------------------+
# | Licensed 波特智控并不是自由软件，未经许可不得使用                           |
# +----------------------------------------------------------------------+
# | Author: 波特智控研究团队 <bodecontrol-team@sdqbtech.com>                |
# +----------------------------------------------------------------------+


import json
import time
from paho.mqtt import client as mqtt_client

from loguru import logger


class MqttPublisher:
    def __init__(self, client_id, broker, port, topic) -> None:
        super().__init__()
        self.client_id = client_id
        self.broker = broker
        self.port = port
        self.topic = topic

        logger.info(f"broker: {broker}, port: {port}, topic: {topic}")
        self.client = None

    def publish(self, content: str) -> bool:
        try:
            if self.client is None:
                self.client = self.connect_mqtt()

            disconnect_log = json.dumps({"msg": content})
            client = self.client
            for _ in range(10):
                result = client.publish(self.topic, disconnect_log)
                status = result[0]
                if status == 0:
                    logger.info(f"Send `{disconnect_log}` to topic `{self.topic}`")
                    break
                logger.info(f"Failed and resend message to topic {self.topic}")
                time.sleep(3)
            else:
                pass
            return True
        except Exception as e:
            logger.error(f"mqtt消息发送失败{e}")

        return False

    def connect_mqtt(self):
        def on_connect(client, userdata, flags, rc):
            if rc == 0:
                logger.info("Connected to MQTT Broker!")
            else:
                logger.error("Failed to connect, return code %d\n", rc)

        client = mqtt_client.Client(client_id=self.client_id)
        client.on_connect = on_connect
        client.connect(self.broker, self.port)
        return client
    
    def close(self):
        self.client.disconnect()

