# coding=utf-8
# +----------------------------------------------------------------------+
# | 波特智控 [ 以价值驱动应用, 以AI赋能控制, 让流程工业从稳态迈向自优化 ]          |
# +----------------------------------------------------------------------+
# | Copyright (c) 2020~2025 https://www.sdqbtech.com All rights reserved.|
# +----------------------------------------------------------------------+
# | Licensed 波特智控并不是自由软件，未经许可不得使用                           |
# +----------------------------------------------------------------------+
# | Author: 波特智控研究团队 <bodecontrol-team@sdqbtech.com>                |
# +----------------------------------------------------------------------+


import json
import re
from typing import Union


def get_default_resp_data():
    # 返回值模版
    return {"code": 1, "info": "ok"}

def pyjson_to_js_string(pyjson_str_or_obj: Union[dict, str]) -> str:
    if isinstance(pyjson_str_or_obj, dict):
        pyjson_str_or_obj = str(pyjson_str_or_obj)
    res = re.sub(r'"(.*?)":', r"\1:", pyjson_str_or_obj)
    # print(res)
    res = re.sub(r"'(\w+?)':", r"\1:", res)
    res = re.sub(r"False", r"false", res)
    res = re.sub(r"True", r"true", res)
    return res


def jsstr_to_pyjson(jsstr: str) -> str:
    res = re.sub(r"(\w+?):", r'"\1":', jsstr)
    res = re.sub(r"'", r'"', res)
    res = re.sub(r"(\S),([\s]*?)}", r"\1\2}", res)
    res = re.sub(r"(\.[\d]+)", r"0\1", res)
    res = re.sub(r"False", r"false", res)
    res = re.sub(r"True", r"true", res)
    res = json.loads(res)
    return res


def cvt_value_to_str(obj: dict) -> dict:
    result = {}
    for key, value in obj.items():
        if isinstance(value, str):
            result[key] = value
        else:
            result[key] = json.dumps(value, ensure_ascii=False)
    return result


def cvt_to_bool(val, none_is_false: bool=False) -> bool:
    """_summary_

    Args:
        val: 要转换的值
        none_is_false (bool, optional): none是否处理为False. Defaults to False.

    Raises:
        Exception: 类型错误或者其他

    Returns:
        bool: _description_
    """
    if isinstance(val, bool):
        return val
    if val is None:
        if none_is_false:
            return False
        raise Exception("cant process none if param none_is_false is False")
    
    if str(val).lower() in ['0', 'n', 'no', 'false']:
        return False
    elif str(val).lower() in ['1', 'y', 'yes', 'true']:
        return True
    else:
        raise Exception(f"{val}无法转换为bool类型")