# coding=utf-8
# +----------------------------------------------------------------------+
# | 波特智控 [ 以价值驱动应用, 以AI赋能控制, 让流程工业从稳态迈向自优化 ]          |
# +----------------------------------------------------------------------+
# | Copyright (c) 2020~2025 https://www.sdqbtech.com All rights reserved.|
# +----------------------------------------------------------------------+
# | Licensed 波特智控并不是自由软件，未经许可不得使用                           |
# +----------------------------------------------------------------------+
# | Author: 波特智控研究团队 <bodecontrol-team@sdqbtech.com>                |
# +----------------------------------------------------------------------+


import hashlib
import os
import pathlib
from typing import Union


def get_file_size(filepath: Union[str, pathlib.Path]) -> int:
    stat_info = os.stat(str(filepath))
    file_size = stat_info.st_size
    return file_size


def get_big_file_md5(filepath: Union[str, os.PathLike]):
    md5obj = hashlib.md5()
    max_buff = 8192
    f = open(filepath, 'rb')
    while True:
        buf = f.read(max_buff)
        if not buf:
            break
        md5obj.update(buf)
    f.close()
    hash = md5obj.hexdigest()
    return str(hash).upper()
