# coding=utf-8
# +----------------------------------------------------------------------+
# | 波特智控 [ 以价值驱动应用, 以AI赋能控制, 让流程工业从稳态迈向自优化 ]          |
# +----------------------------------------------------------------------+
# | Copyright (c) 2020~2025 https://www.sdqbtech.com All rights reserved.|
# +----------------------------------------------------------------------+
# | Licensed 波特智控并不是自由软件，未经许可不得使用                           |
# +----------------------------------------------------------------------+
# | Author: 波特智控研究团队 <bodecontrol-team@sdqbtech.com>                |
# +----------------------------------------------------------------------+


from .model_tools import get_model_field_info

NULL_STR = 'NULL_STR'


def get_where_map(q_list: dict, dj_model):
    fields_info = get_model_field_info(dj_model)

    ret = {}
    for k, v in q_list.items():
        k = str(k)
        v = str(v)
        if not k.startswith('_where_'):
            continue
        if v == '':
            continue
        n_k = k.split('_where_')[-1]

        if n_k == 'ctime_start':
            continue

        if n_k == 'ctime_end':
            continue

        field_info = fields_info.get(n_k)
        if not field_info:
            continue

        from_name = field_info['from_name']
        field_type = field_info['field_type']
        real_name = field_info['real_name']

        where_name = f"{from_name}__{real_name}" if from_name != '' else f"{real_name}"
        if field_type in ['IntegerField', 'BigIntegerField', 'AutoField']:
            if '-' in v:
                s = int(v.split('-')[0])
                e = int(v.split('-')[1])
                ret[where_name + '__gte'] = s
                ret[where_name + '__lte'] = e
            else:
                ret[where_name] = v
        elif field_type in ['CharField', 'TextField']:
            # 处理空字符串
            if v == NULL_STR:
                ret[where_name + '__isnull'] = True
                continue
            ret[where_name + "__contains"] = v
    return ret

