# -- 关键：FloatField / IntegerField 等，不再把 CharField 放在基类列表里 --
from __future__ import annotations
import datetime as _dt
from typing import TypeVar, Generic
from django.db.models import Field          # ① 仍然用 django-stubs 的双泛型 Field

T = TypeVar("T")

# ② ConversionMixin 需要两个基类：Field 泛型 + Generic
class ConversionMixin(Field[T, T]): 
    ...
    def _convert(self, value):
        pass

    def _to_db(self, value):
        pass


# ③ 各具体字段只继承 ConversionMixin
class FloatField(ConversionMixin[float]): ...
class IntegerField(ConversionMixin[int]): ...
class BooleanField(ConversionMixin[bool | None]): ...
class DateTimeField(ConversionMixin[_dt.datetime]): ...
class DateTimeMiliField(ConversionMixin[_dt.datetime]): ...

# 仍然导出 CharField 别名供其它代码引用
from django.db import models as _dj
CharField = _dj.CharField
