# coding=utf-8
# +----------------------------------------------------------------------+
# | 波特智控 [ 以价值驱动应用, 以AI赋能控制, 让流程工业从稳态迈向自优化 ]          |
# +----------------------------------------------------------------------+
# | Copyright (c) 2020~2025 https://www.sdqbtech.com All rights reserved.|
# +----------------------------------------------------------------------+
# | Licensed 波特智控并不是自由软件，未经许可不得使用                           |
# +----------------------------------------------------------------------+
# | Author: 波特智控研究团队 <bodecontrol-team@sdqbtech.com>                |
# +----------------------------------------------------------------------+


from django.contrib import admin
from django.urls import path
from django.apps import apps
from pathlib import Path
import importlib
from loguru import logger

def get_local_installed_app_names():
    return  [x.name for x in list(apps.get_app_configs())]


def get_local_app_urls():
    """
       将本地app的url加入到项目中
       注意：由于编译后不存在源码文件，所以本方法将不起作用
    Returns:
        _type_: _description_
    """
    urlpatterns = []
    _installed_apps = get_local_installed_app_names()
    for _app_name in _installed_apps:
        _app_name_path = _app_name.replace('.', '/')
        app_path = Path(_app_name_path) / "apps.py"
        if not app_path.exists():
            continue
        m_path = f'{_app_name}.urls'
        module = importlib.import_module(m_path)
        if hasattr(module, "urlpatterns"):
            urlpatterns += getattr(module, "urlpatterns")
    
    if len(urlpatterns) == 0:
        logger.warning("没有找到app的url，可能是编译后不存在源码文件造成的")
    return urlpatterns


def init_django_env(settings_module: str, conf_logging=True):
    """
    此代码初始化django的ORM环境，可以第三方调用django的ORM模型
    使用时直接引入本文件即可，无需额外操作
    settings_module:str =  'Makaflow.settings'
    """
    import os
    import django
    from django import conf as dj_conf

    if dj_conf.settings.configured:
        return

    os.environ.setdefault("DJANGO_SETTINGS_MODULE", settings_module)
    os.environ.setdefault("DJANGO_ALLOW_ASYNC_UNSAFE", "true")
    if conf_logging:
        django.setup()
    else:
        from django.apps import apps
        from django.conf import settings
        from django.urls import set_script_prefix
        set_script_prefix(
            "/" if settings.FORCE_SCRIPT_NAME is None else settings.FORCE_SCRIPT_NAME
        )
        apps.populate(settings.INSTALLED_APPS)
