
from  datetime import  datetime
from zoneinfo import ZoneInfo
import time

# 获取格式化字符串时间
def get_f_time(dt_time: datetime | None = None, format: str = "%Y-%m-%d %H:%M:%S") -> str:
    if dt_time is None:
        dt_time = datetime.now()
    return dt_time.strftime(format)

def get_f_time_milis(dt_time: datetime | None = None) -> str:
    if dt_time is None:
        dt_time = datetime.now()
    time_str = dt_time.strftime("%Y-%m-%d %H:%M:%S.%f")[:-3]
    return time_str

def get_timestamp(dt_time: datetime | None = None):
    if dt_time is None:
        dt_time = datetime.now()
    return int(dt_time.now().timestamp())

def get_milli_timestamp(dt_time: datetime | None = None):
    if dt_time is None:
        dt_time = datetime.now()
    return int(dt_time.timestamp() * 1000)

def timestamp2_formate_time(ts,  fmt_str: str = "%Y-%m-%d %H:%M:%S"):
    date = datetime.fromtimestamp(int(ts))
    return date.strftime(fmt_str)


def get_p_time(str_dtime, fmt_str: str = "%Y-%m-%d %H:%M:%S", zoninfo:ZoneInfo|None|str=None):
    p_time = datetime.strptime(str_dtime, fmt_str)
    if zoninfo is not None:
        if isinstance(zoninfo, str):
            zoninfo = ZoneInfo(zoninfo)
        p_time = p_time.replace(tzinfo=zoninfo)
    return p_time

def get_now_time(zoninfo:ZoneInfo|None|str=None):
    p_time = datetime.now()
    if zoninfo is not None:
        if isinstance(zoninfo, str):
            zoninfo = ZoneInfo(zoninfo)
        p_time = p_time.replace(tzinfo=zoninfo)
    return p_time

class CostRecord:
    def __init__(self):
        self.cur = time.time()

    def record(self, comment):
        cur = time.time()
        self.cur = cur
        return f"{comment} cost:{cur - self.cur}"

_start_point:datetime|str = 'now'
_real_start:datetime = datetime.now()
_zoneinfo = ZoneInfo("Asia/Shanghai")

def set_start_point(dt:datetime):
    global _start_point
    _start_point = dt

def get_start_point():
    global _start_point
    return _start_point


def set_realstart(dt:datetime):
    global _real_start
    _real_start = dt

def get_realstart():
    global _real_start
    return _real_start

def set_zoneinfo(zoneinfo:ZoneInfo):
    global _zoneinfo
    _zoneinfo = zoneinfo

def get_zoneinfo() -> ZoneInfo:
    global _zoneinfo
    return _zoneinfo

# 获取当前时间
def app_now_time() -> datetime:
    global _start_point
    _now = datetime.now(get_zoneinfo())
    if _start_point == 'now':
        return _now
    if not isinstance(_start_point, datetime):
        raise Exception("开始时间点应该是datetime类型")
    _now = _start_point  + (_now - get_realstart())
    return _now

def real_time() -> datetime:
    """
    获取当前时间，和now_time()不同的是，这个函数返回的是实际的当前时间，而不是模拟的时间。
    """
    return datetime.now(get_zoneinfo())





