from __future__ import annotations

from typing import Any, Dict, Iterator, Mapping, Optional, Sequence, Type, TypeVar, overload

import pandas as pd

__all__ = ["InfluxQuerySet"]

TInflux = TypeVar("TInflux", bound="InfluxDB2Base")

class InfluxQuerySet(Sequence[TInflux]):
    _df: pd.DataFrame
    _cache: list[Optional[TInflux]]
    query: Optional[str]

    def __init__(
        self,
        df: pd.DataFrame,
        model_cls: Type[TInflux],
        allowed_fields: set[str],
        tag_value_to_field: Dict[str, str],
        query: Optional[str] = ...,
    ) -> None: ...

    def __len__(self) -> int: ...

    @overload
    def __getitem__(self, idx: int) -> TInflux: ...

    @overload
    def __getitem__(self, idx: slice) -> "InfluxQuerySet[TInflux]": ...

    def __iter__(self) -> Iterator[TInflux]: ...

    def to_json(self, *, as_str: bool = ...) -> str | list[Dict[str, Any]]: ...

    def to_dataframe(self, *, copy: bool = True) -> pd.DataFrame: ...
