from __future__ import annotations

from datetime import datetime
from typing import Any, Callable, Generic, Mapping, Optional, Type, TypeVar, Union, overload
from typing import TYPE_CHECKING
from zoneinfo import ZoneInfo

from .enums import Agg, Fill

__all__ = [
    "FieldSpec",
    "FloatField",
    "IntField",
    "BoolField",
    "StringField",
    "DateTimeField",
]

TField = TypeVar("TField")
TModel = TypeVar("TModel", bound="InfluxDB2Base")

if TYPE_CHECKING:  # pragma: no cover
    from .base import InfluxDB2Base

class FieldSpec(Generic[TField]):
    tags: Mapping[str, str]
    field: str
    dtype: Optional[Union[type, Callable[[Any], Any]]]
    fill: Fill
    agg: Agg
    label: Optional[str]
    post: Optional[Callable[[Mapping[str, Any]], Any]]
    src_tz: Optional[Union[str, ZoneInfo]]

    def __init__(
        self,
        tags: Mapping[str, str] = ...,
        field: str = ...,
        dtype: Optional[Union[type, Callable[[Any], Any]]] = ...,
        fill: Fill = ...,
        agg: Agg = ...,
        label: Optional[str] = ...,
        post: Optional[Callable[[Mapping[str, Any]], Any]] = ...,
        src_tz: Optional[Union[str, ZoneInfo]] = ...,
    ) -> None: ...

    def target_type(self) -> Optional[Union[type, Callable[[Any], Any]]]: ...

    def resolved_dtype(self) -> Optional[Union[type, Callable[[Any], Any]]]: ...

    def __set_name__(self, owner: type, name: str) -> None: ...
    
    @overload
    def __get__(self, instance: None, owner: Type[TModel]) -> "FieldSpec[TField]": ...
    
    @overload
    def __get__(self, instance: TModel, owner: Type[TModel]) -> TField: ...

    def __set__(self, instance: TModel, value: TField) -> None: ...

class FloatField(FieldSpec[float]): ...

class IntField(FieldSpec[int]): ...

class BoolField(FieldSpec[bool]): ...

class StringField(FieldSpec[str]): ...

class DateTimeField(FieldSpec[datetime]): ...
