import time
from datetime import datetime
from typing import ClassVar

from ..base import InfluxDB2Base
from ..fields import FloatField, StringField, DateTimeField, IntField, BoolField
from ..enums import Fill, Agg

class FsfDecideLog(InfluxDB2Base):
    measurement = "fsf_decide_log"

    # ----------- 历史状态 -----------
    last_action_time: DateTimeField = DateTimeField(
        tags={"name": "last_action_time"},
        field="tvalue",
        fill=Fill.last,
        agg=Agg.last,
        label="上一次调节时间",
    )
    last_action_step: FloatField = FloatField(
        tags={"name": "last_action_step"},
        field="value",
        fill=Fill.last,
        agg=Agg.last,
        label="上一次调节步幅",
    )

def main():

    while True:
        now = datetime.now()
        print(now)
        obj = FsfDecideLog(last_action_step=0.2, time=now)
        obj.save()
        time.sleep(1)
if __name__ == '__main__':
    main()
